/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.integration.papi;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.competition.Competition;
import net.momirealms.customfishing.integration.papi.CompetitionPapi;
import net.momirealms.customfishing.integration.papi.ParseUtil;
import net.momirealms.customfishing.integration.papi.StatisticsPapi;
import net.momirealms.customfishing.manager.MessageManager;
import net.momirealms.customfishing.object.Function;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class PlaceholderManager
extends Function {
    private CustomFishing plugin;
    private final Pattern basicPattern = Pattern.compile("%([^%]*)%");
    private final Pattern betterPattern = Pattern.compile("\\{(.+?)\\}");
    private final Pattern allPattern = Pattern.compile("%([^%]*)%|\\{(.+?)\\}");
    private CompetitionPapi competitionPapi;
    private StatisticsPapi statisticsPapi;
    private boolean hasPlaceholderAPI = false;

    public PlaceholderManager(CustomFishing plugin) {
        this.plugin = plugin;
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.hasPlaceholderAPI = true;
            this.competitionPapi = new CompetitionPapi();
            this.statisticsPapi = new StatisticsPapi(plugin);
        }
    }

    @Override
    public void load() {
        if (this.competitionPapi != null) {
            this.competitionPapi.register();
        }
        if (this.statisticsPapi != null) {
            this.statisticsPapi.register();
        }
    }

    @Override
    public void unload() {
        if (this.competitionPapi != null) {
            this.competitionPapi.unregister();
        }
        if (this.statisticsPapi != null) {
            this.statisticsPapi.unregister();
        }
    }

    public String parse(OfflinePlayer player, String text) {
        if (this.hasPlaceholderAPI) {
            return ParseUtil.setPlaceholders(player, this.parseInner(player, text));
        }
        return this.parseInner(player, text);
    }

    public String parseInner(OfflinePlayer player, String text) {
        List<String> papis = this.detectBetterPlaceholders(text);
        for (String papi : papis) {
            text = text.replace(papi, this.parseSingleInner(player, papi));
        }
        return text;
    }

    public String parseSinglePlaceholder(OfflinePlayer player, String placeholder) {
        if (placeholder.startsWith("{")) {
            return this.parseSingleInner(player, placeholder);
        }
        if (this.hasPlaceholderAPI) {
            return ParseUtil.setPlaceholders(player, placeholder);
        }
        return placeholder;
    }

    public List<String> detectBasicPlaceholders(String text) {
        ArrayList<String> placeholders = new ArrayList<String>();
        Matcher matcher = this.basicPattern.matcher(text);
        while (matcher.find()) {
            placeholders.add(matcher.group());
        }
        return placeholders;
    }

    public List<String> detectBetterPlaceholders(String text) {
        ArrayList<String> placeholders = new ArrayList<String>();
        Matcher matcher = this.betterPattern.matcher(text);
        while (matcher.find()) {
            placeholders.add(matcher.group());
        }
        return placeholders;
    }

    public List<String> detectAllPlaceholders(String text) {
        ArrayList<String> placeholders = new ArrayList<String>();
        Matcher matcher = this.allPattern.matcher(text);
        while (matcher.find()) {
            placeholders.add(matcher.group());
        }
        return placeholders;
    }

    public List<String> detectPlaceholders(String text) {
        return this.hasPlaceholderAPI ? this.detectAllPlaceholders(text) : this.detectBetterPlaceholders(text);
    }

    public String parseSingleInner(OfflinePlayer player, String placeholder) {
        switch (placeholder) {
            case "{player}": {
                return player.getName();
            }
            case "{rank}": {
                return Competition.currentCompetition.getPlayerRank(player);
            }
            case "{time}": {
                return String.valueOf(Competition.currentCompetition.getRemainingTime());
            }
            case "{goal}": {
                return Competition.currentCompetition.getGoal().getDisplay();
            }
            case "{minute}": {
                return String.format("%02d", Competition.currentCompetition.getRemainingTime() / 60L);
            }
            case "{second}": {
                return String.format("%02d", Competition.currentCompetition.getRemainingTime() % 60L);
            }
            case "{score}": {
                return String.format("%.1f", Competition.currentCompetition.getScore(player));
            }
            case "{1st_player}": {
                return Optional.ofNullable(Competition.currentCompetition.getRanking().getPlayerAt(1)).orElse(MessageManager.noPlayer);
            }
            case "{1st_score}": {
                return Competition.currentCompetition.getRanking().getScoreAt(1) <= 0.0f ? MessageManager.noScore : String.format("%.1f", Float.valueOf(Competition.currentCompetition.getRanking().getScoreAt(1)));
            }
            case "{2nd_player}": {
                return Optional.ofNullable(Competition.currentCompetition.getRanking().getPlayerAt(2)).orElse(MessageManager.noPlayer);
            }
            case "{2nd_score}": {
                return Competition.currentCompetition.getRanking().getScoreAt(2) <= 0.0f ? MessageManager.noScore : String.format("%.1f", Float.valueOf(Competition.currentCompetition.getRanking().getScoreAt(2)));
            }
            case "{3rd_player}": {
                return Optional.ofNullable(Competition.currentCompetition.getRanking().getPlayerAt(3)).orElse(MessageManager.noPlayer);
            }
            case "{3rd_score}": {
                return Competition.currentCompetition.getRanking().getScoreAt(3) <= 0.0f ? MessageManager.noScore : String.format("%.1f", Float.valueOf(Competition.currentCompetition.getRanking().getScoreAt(3)));
            }
        }
        return placeholder;
    }
}

