/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.MiniGameConfig;
import net.momirealms.customfishing.fishing.bar.FishingBar;
import net.momirealms.customfishing.fishing.bar.ModeOneBar;
import net.momirealms.customfishing.fishing.bar.ModeThreeBar;
import net.momirealms.customfishing.fishing.bar.ModeTwoBar;
import net.momirealms.customfishing.object.Function;
import net.momirealms.customfishing.util.AdventureUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class BarMechanicManager
extends Function {
    private final CustomFishing plugin;
    private final HashMap<String, FishingBar> bars;
    private final HashMap<String, MiniGameConfig> miniGames;

    public BarMechanicManager(CustomFishing plugin) {
        this.plugin = plugin;
        this.bars = new HashMap();
        this.miniGames = new HashMap();
    }

    @Override
    public void load() {
        this.loadBars();
        this.loadGames();
    }

    @Override
    public void unload() {
        this.bars.clear();
        this.miniGames.clear();
    }

    private void loadGames() {
        File[] files;
        File game_file = new File(this.plugin.getDataFolder() + File.separator + "minigames");
        if (!game_file.exists()) {
            if (!game_file.mkdir()) {
                return;
            }
            this.plugin.saveResource("minigames" + File.separator + "default.yml", false);
        }
        if ((files = game_file.listFiles()) == null) {
            return;
        }
        for (File file : files) {
            if (!file.getName().endsWith(".yml")) continue;
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            for (String key : config.getKeys(false)) {
                ConfigurationSection section = config.getConfigurationSection(key);
                if (section == null) continue;
                ArrayList<FishingBar> fishingBarList = new ArrayList<FishingBar>();
                for (String bar : section.getStringList("bars")) {
                    if (this.bars.containsKey(bar)) {
                        fishingBarList.add(this.bars.get(bar));
                        continue;
                    }
                    AdventureUtils.consoleMessage("<red>[CustomFishing] Bar " + bar + " doesn't exist");
                }
                int[] difficulties = section.getIntegerList("difficulty").stream().mapToInt(Integer::intValue).toArray();
                if (difficulties.length == 0) {
                    AdventureUtils.consoleMessage("<red>[CustomFishing] Game " + key + " doesn't have difficulties");
                    continue;
                }
                MiniGameConfig miniGameConfig = new MiniGameConfig(section.getInt("time", 10), fishingBarList.toArray(new FishingBar[0]), difficulties);
                this.miniGames.put(key, miniGameConfig);
            }
        }
        AdventureUtils.consoleMessage("[CustomFishing] Loaded <green>" + this.miniGames.size() + " <gray>game(s)");
    }

    private void loadBars() {
        File[] files;
        File bar_file = new File(this.plugin.getDataFolder() + File.separator + "bars");
        if (!bar_file.exists()) {
            if (!bar_file.mkdir()) {
                return;
            }
            this.plugin.saveResource("bars" + File.separator + "default.yml", false);
        }
        if ((files = bar_file.listFiles()) == null) {
            return;
        }
        for (File file : files) {
            if (!file.getName().endsWith(".yml")) continue;
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            for (String key : config.getKeys(false)) {
                ConfigurationSection section = config.getConfigurationSection(key);
                if (section == null) continue;
                int type = section.getInt("game-type");
                if (type == 1) {
                    ModeOneBar modeOneBar = new ModeOneBar(section);
                    this.bars.put(key, modeOneBar);
                    continue;
                }
                if (type == 2) {
                    ModeTwoBar modeTwoBar = new ModeTwoBar(section);
                    this.bars.put(key, modeTwoBar);
                    continue;
                }
                if (type != 3) continue;
                ModeThreeBar modeThreeBar = new ModeThreeBar(section);
                this.bars.put(key, modeThreeBar);
            }
        }
        AdventureUtils.consoleMessage("[CustomFishing] Loaded <green>" + this.bars.size() + " <gray>bar(s)");
    }

    public MiniGameConfig getGameConfig(String game) {
        return this.miniGames.get(game);
    }

    public MiniGameConfig getRandomGame() {
        Collection<MiniGameConfig> miniGameConfigs = this.miniGames.values();
        return (MiniGameConfig)miniGameConfigs.toArray()[new Random().nextInt(miniGameConfigs.size())];
    }
}

