/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.manager;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.data.storage.DataStorageInterface;
import net.momirealms.customfishing.data.storage.FileStorageImpl;
import net.momirealms.customfishing.data.storage.MySQLStorageImpl;
import net.momirealms.customfishing.data.storage.StorageType;
import net.momirealms.customfishing.manager.ConfigManager;
import net.momirealms.customfishing.object.Function;
import net.momirealms.customfishing.util.AdventureUtils;
import net.momirealms.customfishing.util.ConfigUtils;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataManager
extends Function {
    private DataStorageInterface dataStorageInterface;
    private final CustomFishing plugin;
    private StorageType storageType;
    private ScheduledFuture<?> timerSave;

    public DataManager(CustomFishing plugin) {
        this.plugin = plugin;
    }

    public DataStorageInterface getDataStorageInterface() {
        return this.dataStorageInterface;
    }

    private boolean loadStorageMode() {
        YamlConfiguration config = ConfigUtils.getConfig("database.yml");
        if (config.getString("data-storage-method", "YAML").equalsIgnoreCase("YAML")) {
            if (this.storageType != StorageType.YAML) {
                this.dataStorageInterface = new FileStorageImpl(this.plugin);
                this.storageType = StorageType.YAML;
                return true;
            }
        } else if (this.storageType != StorageType.SQL) {
            this.dataStorageInterface = new MySQLStorageImpl(this.plugin);
            this.storageType = StorageType.SQL;
            return true;
        }
        return false;
    }

    @Override
    public void load() {
        if (this.loadStorageMode()) {
            this.dataStorageInterface.initialize();
        }
        this.timerSave = this.plugin.getScheduler().runTaskTimerAsync(() -> {
            if (ConfigManager.enableFishingBag) {
                if (!ConfigManager.hideSaveInfo) {
                    AdventureUtils.consoleMessage("[CustomFishing] Saving fishing bag data...");
                }
                this.plugin.getBagDataManager().saveBagDataForOnlinePlayers(false);
            }
            if (ConfigManager.enableStatistics) {
                if (!ConfigManager.hideSaveInfo) {
                    AdventureUtils.consoleMessage("[CustomFishing] Saving statistics data...");
                }
                this.plugin.getStatisticsManager().saveStatisticsDataForOnlinePlayers(false);
            }
            if (!ConfigManager.hideSaveInfo) {
                AdventureUtils.consoleMessage("[CustomFishing] Data saved for all online players.");
            }
        }, 20L, 20L, TimeUnit.MINUTES);
    }

    @Override
    public void unload() {
        YamlConfiguration config;
        StorageType st;
        if (this.timerSave != null && !this.timerSave.isCancelled()) {
            this.timerSave.cancel(false);
        }
        StorageType storageType = st = (config = ConfigUtils.getConfig("database.yml")).getString("data-storage-method", "YAML").equalsIgnoreCase("YAML") ? StorageType.YAML : StorageType.SQL;
        if (this.dataStorageInterface != null && this.dataStorageInterface.getStorageType() != st) {
            this.dataStorageInterface.disable();
        }
    }

    @Override
    public void disable() {
        if (this.dataStorageInterface != null) {
            this.dataStorageInterface.disable();
        }
        if (this.timerSave != null && !this.timerSave.isCancelled()) {
            this.timerSave.cancel(false);
        }
    }
}

