/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.api.CustomFishingAPI;
import net.momirealms.customfishing.api.event.FishFinderEvent;
import net.momirealms.customfishing.api.event.FishResultEvent;
import net.momirealms.customfishing.api.event.MiniGameStartEvent;
import net.momirealms.customfishing.api.event.RodCastEvent;
import net.momirealms.customfishing.api.event.TotemActivationEvent;
import net.momirealms.customfishing.fishing.BobberCheckTask;
import net.momirealms.customfishing.fishing.Effect;
import net.momirealms.customfishing.fishing.FishResult;
import net.momirealms.customfishing.fishing.FishingCondition;
import net.momirealms.customfishing.fishing.MiniGameConfig;
import net.momirealms.customfishing.fishing.VanillaLoot;
import net.momirealms.customfishing.fishing.action.Action;
import net.momirealms.customfishing.fishing.action.VanillaXPImpl;
import net.momirealms.customfishing.fishing.bar.FishingBar;
import net.momirealms.customfishing.fishing.bar.ModeOneBar;
import net.momirealms.customfishing.fishing.bar.ModeThreeBar;
import net.momirealms.customfishing.fishing.bar.ModeTwoBar;
import net.momirealms.customfishing.fishing.competition.Competition;
import net.momirealms.customfishing.fishing.competition.CompetitionGoal;
import net.momirealms.customfishing.fishing.loot.DroppedItem;
import net.momirealms.customfishing.fishing.loot.Loot;
import net.momirealms.customfishing.fishing.loot.Mob;
import net.momirealms.customfishing.fishing.mode.FishingGame;
import net.momirealms.customfishing.fishing.mode.ModeOneGame;
import net.momirealms.customfishing.fishing.mode.ModeThreeGame;
import net.momirealms.customfishing.fishing.mode.ModeTwoGame;
import net.momirealms.customfishing.fishing.requirements.RequirementInterface;
import net.momirealms.customfishing.fishing.totem.ActivatedTotem;
import net.momirealms.customfishing.fishing.totem.TotemConfig;
import net.momirealms.customfishing.integration.MobInterface;
import net.momirealms.customfishing.integration.item.McMMOTreasure;
import net.momirealms.customfishing.libs.de.tr7zw.changeme.nbtapi.NBTCompound;
import net.momirealms.customfishing.libs.de.tr7zw.changeme.nbtapi.NBTItem;
import net.momirealms.customfishing.libs.net.kyori.adventure.key.Key;
import net.momirealms.customfishing.libs.net.kyori.adventure.sound.Sound;
import net.momirealms.customfishing.libs.net.kyori.adventure.text.Component;
import net.momirealms.customfishing.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.momirealms.customfishing.listener.BreakBlockListener;
import net.momirealms.customfishing.listener.ConsumeItemListener;
import net.momirealms.customfishing.listener.InteractListener;
import net.momirealms.customfishing.listener.JobsRebornXPListener;
import net.momirealms.customfishing.listener.JoinQuitListener;
import net.momirealms.customfishing.listener.MMOItemsListener;
import net.momirealms.customfishing.listener.PickUpListener;
import net.momirealms.customfishing.listener.PlayerFishListener;
import net.momirealms.customfishing.manager.ConfigManager;
import net.momirealms.customfishing.manager.MessageManager;
import net.momirealms.customfishing.object.Function;
import net.momirealms.customfishing.object.SimpleLocation;
import net.momirealms.customfishing.util.AdventureUtils;
import net.momirealms.customfishing.util.FakeItemUtils;
import net.momirealms.customfishing.util.ItemStackUtils;
import net.momirealms.customfishing.util.LocationUtils;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishingManager
extends Function {
    private final CustomFishing plugin;
    private final PlayerFishListener playerFishListener;
    private final InteractListener interactListener;
    private final ConsumeItemListener consumeItemListener;
    private PickUpListener pickUpListener;
    private MMOItemsListener mmoItemsListener;
    private JobsRebornXPListener jobsRebornXPListener;
    private final JoinQuitListener joinQuitListener;
    private final BreakBlockListener breakBlockListener;
    private final HashMap<UUID, Long> coolDown;
    private final HashMap<UUID, FishHook> hooks;
    private final HashMap<UUID, Loot> nextLoot;
    private final HashMap<UUID, Effect> nextEffect;
    private final HashMap<UUID, VanillaLoot> vanillaLoot;
    private final ConcurrentHashMap<UUID, FishingGame> fishingPlayerMap;
    private final ConcurrentHashMap<SimpleLocation, ActivatedTotem> activeTotemMap;
    private final ConcurrentHashMap<SimpleLocation, SimpleLocation> breakDetectionMap;
    private final ConcurrentHashMap<UUID, BobberCheckTask> hookCheckTaskMap;

    public FishingManager(CustomFishing plugin) {
        this.plugin = plugin;
        this.playerFishListener = new PlayerFishListener(this);
        this.interactListener = new InteractListener(this);
        this.breakBlockListener = new BreakBlockListener(this);
        this.consumeItemListener = new ConsumeItemListener(this);
        this.joinQuitListener = new JoinQuitListener(this);
        this.coolDown = new HashMap();
        this.hooks = new HashMap();
        this.nextLoot = new HashMap();
        this.nextEffect = new HashMap();
        this.vanillaLoot = new HashMap();
        this.fishingPlayerMap = new ConcurrentHashMap();
        this.activeTotemMap = new ConcurrentHashMap();
        this.hookCheckTaskMap = new ConcurrentHashMap();
        this.breakDetectionMap = new ConcurrentHashMap();
        this.load();
    }

    @Override
    public void load() {
        Bukkit.getPluginManager().registerEvents((Listener)this.playerFishListener, (Plugin)this.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)this.interactListener, (Plugin)this.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)this.breakBlockListener, (Plugin)this.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)this.consumeItemListener, (Plugin)this.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)this.joinQuitListener, (Plugin)this.plugin);
        if (ConfigManager.preventPickUp) {
            this.pickUpListener = new PickUpListener();
            Bukkit.getPluginManager().registerEvents((Listener)this.pickUpListener, (Plugin)this.plugin);
        }
        if (ConfigManager.convertMMOItems) {
            this.mmoItemsListener = new MMOItemsListener(this);
            Bukkit.getPluginManager().registerEvents((Listener)this.mmoItemsListener, (Plugin)this.plugin);
        }
        if (ConfigManager.disableJobsXp) {
            this.jobsRebornXPListener = new JobsRebornXPListener();
            Bukkit.getPluginManager().registerEvents((Listener)this.jobsRebornXPListener, (Plugin)this.plugin);
        }
    }

    @Override
    public void unload() {
        HandlerList.unregisterAll((Listener)this.playerFishListener);
        HandlerList.unregisterAll((Listener)this.interactListener);
        HandlerList.unregisterAll((Listener)this.breakBlockListener);
        HandlerList.unregisterAll((Listener)this.consumeItemListener);
        HandlerList.unregisterAll((Listener)this.joinQuitListener);
        if (this.pickUpListener != null) {
            HandlerList.unregisterAll((Listener)this.pickUpListener);
        }
        if (this.mmoItemsListener != null) {
            HandlerList.unregisterAll((Listener)this.mmoItemsListener);
        }
        if (this.jobsRebornXPListener != null) {
            HandlerList.unregisterAll((Listener)this.jobsRebornXPListener);
        }
        for (BobberCheckTask bobberCheckTask : this.hookCheckTaskMap.values()) {
            bobberCheckTask.stop();
        }
    }

    public void onFishing(PlayerFishEvent event) {
        Effect rod_effect;
        Player player = event.getPlayer();
        FishHook fishHook = event.getHook();
        this.hooks.put(player.getUniqueId(), fishHook);
        boolean noBait = true;
        boolean rodOnMainHand = false;
        ItemStack baitAnimationItem = null;
        ItemStack baitRealItem = null;
        Effect initialEffect = new Effect();
        initialEffect.setWeightMD(new HashMap<String, Double>(8));
        initialEffect.setWeightAS(new HashMap<String, Integer>(8));
        PlayerInventory inventory = player.getInventory();
        ItemStack mainHandItem = inventory.getItemInMainHand();
        ItemStack offHandItem = inventory.getItemInOffHand();
        if (mainHandItem.getType() == Material.FISHING_ROD) {
            rodOnMainHand = true;
        }
        String rod_id = Optional.ofNullable(rodOnMainHand ? CustomFishingAPI.getRodID(mainHandItem) : CustomFishingAPI.getRodID(offHandItem)).orElse("vanilla");
        FishingCondition fishingCondition = new FishingCondition(player.getLocation(), player, rod_id, null);
        String bait_id = Optional.ofNullable(rodOnMainHand ? CustomFishingAPI.getBaitID(offHandItem) : CustomFishingAPI.getBaitID(mainHandItem)).orElse("");
        Effect baitEffect = this.plugin.getEffectManager().getBaitEffect(bait_id);
        if (baitEffect != null && initialEffect.canAddEffect(baitEffect, fishingCondition)) {
            initialEffect.addEffect(baitEffect);
            baitAnimationItem = rodOnMainHand ? offHandItem.clone() : mainHandItem.clone();
            baitRealItem = rodOnMainHand ? offHandItem : mainHandItem;
            noBait = false;
        }
        for (ActivatedTotem activatedTotem : this.activeTotemMap.values()) {
            if (!activatedTotem.getNearbyPlayerSet().contains(player)) continue;
            initialEffect.addEffect(activatedTotem.getTotem().getEffect());
            break;
        }
        if (ConfigManager.enableFishingBag) {
            Inventory fishingBag = this.plugin.getBagDataManager().getPlayerBagData(player.getUniqueId());
            HashSet<String> uniqueUtils = new HashSet<String>(4);
            if (fishingBag != null) {
                for (int i = 0; i < fishingBag.getSize(); ++i) {
                    Effect utilEffect;
                    NBTCompound cfCompound;
                    ItemStack itemStack = fishingBag.getItem(i);
                    if (itemStack == null || itemStack.getType() == Material.AIR || (cfCompound = new NBTItem(itemStack).getCompound("CustomFishing")) == null) continue;
                    String type = cfCompound.getString("type");
                    String id = cfCompound.getString("id");
                    if (noBait && type.equals("bait")) {
                        Effect effect = this.plugin.getEffectManager().getBaitEffect(id);
                        if (effect == null || itemStack.getAmount() <= 0 || !initialEffect.canAddEffect(effect, fishingCondition)) continue;
                        initialEffect.addEffect(effect);
                        noBait = false;
                        bait_id = id;
                        baitAnimationItem = itemStack.clone();
                        baitRealItem = itemStack;
                        continue;
                    }
                    if (!type.equals("util") || (utilEffect = this.plugin.getEffectManager().getUtilEffect(id)) == null || uniqueUtils.contains(id)) continue;
                    initialEffect.addEffect(utilEffect);
                    uniqueUtils.add(id);
                }
            }
        }
        if ((rod_effect = this.plugin.getEffectManager().getRodEffect(rod_id)) != null) {
            if (!initialEffect.canAddEffect(rod_effect, new FishingCondition(player.getLocation(), player, rod_id, bait_id))) {
                event.setCancelled(true);
                return;
            }
            initialEffect.addEffect(rod_effect);
            initialEffect.setSpecialRodID(rod_id);
        }
        this.addEnchantEffect(initialEffect, rodOnMainHand ? mainHandItem : offHandItem, fishingCondition);
        RodCastEvent rodCastEvent = new RodCastEvent(player, initialEffect);
        Bukkit.getPluginManager().callEvent((Event)rodCastEvent);
        if (rodCastEvent.isCancelled()) {
            event.setCancelled(true);
            return;
        }
        if (baitRealItem != null) {
            baitRealItem.setAmount(baitRealItem.getAmount() - 1);
        }
        int lureLevel = rodOnMainHand ? mainHandItem.getEnchantmentLevel(Enchantment.LURE) : offHandItem.getEnchantmentLevel(Enchantment.LURE);
        fishHook.setMaxWaitTime((int)((double)fishHook.getMaxWaitTime() * initialEffect.getTimeModifier()));
        fishHook.setMinWaitTime((int)((double)fishHook.getMinWaitTime() * initialEffect.getTimeModifier()));
        this.nextEffect.put(player.getUniqueId(), initialEffect);
        if (ConfigManager.needRodToFish && !initialEffect.hasSpecialRod()) {
            this.nextLoot.put(player.getUniqueId(), Loot.EMPTY);
            return;
        }
        int entityID = 0;
        if (baitAnimationItem != null && ConfigManager.baitAnimation) {
            baitAnimationItem.setAmount(1);
            entityID = new Random().nextInt(Integer.MAX_VALUE);
            CustomFishing.getProtocolManager().sendServerPacket(player, FakeItemUtils.getSpawnPacket(entityID, fishHook.getLocation()));
            CustomFishing.getProtocolManager().sendServerPacket(player, FakeItemUtils.getMetaPacket(entityID, baitAnimationItem));
        }
        BobberCheckTask bobberCheckTask = new BobberCheckTask(this.plugin, player, initialEffect, fishHook, this, lureLevel, entityID, rod_id, bait_id);
        this.hookCheckTaskMap.put(player.getUniqueId(), bobberCheckTask);
    }

    public void onBite(PlayerFishEvent event) {
        if (ConfigManager.disableBar || !ConfigManager.instantBar) {
            return;
        }
        this.showBar(event.getPlayer());
    }

    public void getNextLoot(Player player, Effect initialEffect, List<Loot> possibleLoots) {
        ArrayList<Loot> availableLoots = new ArrayList<Loot>();
        if (possibleLoots.size() == 0) {
            this.nextLoot.put(player.getUniqueId(), null);
            return;
        }
        HashMap<String, Integer> as = initialEffect.getWeightAS();
        HashMap<String, Double> md = initialEffect.getWeightMD();
        double[] weights = new double[possibleLoots.size()];
        int index = 0;
        for (Loot loot : possibleLoots) {
            double weight = loot.getWeight();
            String group = loot.getGroup();
            if (group != null) {
                if (as.get(group) != null) {
                    weight += (double)as.get(group).intValue();
                }
                if (md.get(group) != null) {
                    weight *= md.get(group).doubleValue();
                }
            }
            if (weight <= 0.0) continue;
            availableLoots.add(loot);
            weights[index++] = weight;
        }
        double total = Arrays.stream(weights).sum();
        double[] weightRatios = new double[index];
        for (int i = 0; i < index; ++i) {
            weightRatios[i] = weights[i] / total;
        }
        double[] weightRange = new double[index];
        double startPos = 0.0;
        for (int i = 0; i < index; ++i) {
            weightRange[i] = startPos + weightRatios[i];
            startPos += weightRatios[i];
        }
        double random = Math.random();
        int pos = Arrays.binarySearch(weightRange, random);
        if (pos < 0) {
            pos = -pos - 1;
        }
        if (pos < weightRange.length && random < weightRange[pos]) {
            this.nextLoot.put(player.getUniqueId(), (Loot)availableLoots.get(pos));
            return;
        }
        this.nextLoot.put(player.getUniqueId(), null);
    }

    public void onCaughtFish(PlayerFishEvent event) {
        Player player = event.getPlayer();
        Entity entity = event.getCaught();
        if (!(entity instanceof Item)) {
            return;
        }
        Item item = (Item)entity;
        UUID uuid = player.getUniqueId();
        FishingGame fishingGame = this.fishingPlayerMap.remove(uuid);
        if (fishingGame == null) {
            Loot loot = this.nextLoot.get(uuid);
            if (loot == Loot.EMPTY) {
                return;
            }
            if (ConfigManager.enableVanillaLoot) {
                if (ConfigManager.vanillaLootRatio < Math.random()) {
                    if (loot != null) {
                        this.vanillaLoot.remove(uuid);
                        if (loot.isDisableBar() || ConfigManager.disableBar) {
                            this.noBarWaterReelIn(event);
                            return;
                        }
                        this.showFishingBar(player, loot);
                    } else {
                        this.vanillaLoot.put(uuid, new VanillaLoot(item.getItemStack(), event.getExpToDrop()));
                        if (ConfigManager.disableBar) {
                            this.noBarWaterReelIn(event);
                            return;
                        }
                        this.showFishingBar(player, this.plugin.getLootManager().getVanilla_loot());
                    }
                    event.setCancelled(true);
                } else if (!this.plugin.getLootManager().getVanilla_loot().isDisableBar() && !ConfigManager.disableBar) {
                    event.setCancelled(true);
                    this.vanillaLoot.put(uuid, new VanillaLoot(item.getItemStack(), event.getExpToDrop()));
                    this.showFishingBar(player, this.plugin.getLootManager().getVanilla_loot());
                }
            } else if (loot == null) {
                event.setCancelled(true);
                this.removeHook(uuid);
                AdventureUtils.playerMessage(player, MessageManager.prefix + MessageManager.noLoot);
            } else {
                if (loot.isDisableBar() || ConfigManager.disableBar) {
                    this.noBarWaterReelIn(event);
                    return;
                }
                event.setCancelled(true);
                this.showFishingBar(player, loot);
            }
        } else {
            event.setCancelled(true);
            this.removeHook(uuid);
            this.proceedReelIn(event.getHook().getLocation(), player, fishingGame);
        }
    }

    public void onReelIn(PlayerFishEvent event) {
        Player player = event.getPlayer();
        if (ConfigManager.disableBar) {
            this.noBarLavaReelIn(event);
            return;
        }
        UUID uuid = player.getUniqueId();
        FishingGame fishingGame = this.fishingPlayerMap.remove(uuid);
        if (fishingGame != null) {
            this.proceedReelIn(event.getHook().getLocation(), player, fishingGame);
            this.hookCheckTaskMap.remove(uuid);
            return;
        }
        BobberCheckTask bobberCheckTask = this.hookCheckTaskMap.get(uuid);
        if (bobberCheckTask != null && bobberCheckTask.isHooked()) {
            Loot loot = this.nextLoot.get(uuid);
            if (loot == Loot.EMPTY) {
                return;
            }
            if (loot.isDisableBar()) {
                this.noBarLavaReelIn(event);
                return;
            }
            this.showFishingBar(player, loot);
            event.setCancelled(true);
        }
    }

    public void onCaughtEntity(PlayerFishEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        FishingGame fishingGame = this.fishingPlayerMap.remove(uuid);
        if (fishingGame != null) {
            Entity entity = event.getCaught();
            if (entity != null && entity.getType() == EntityType.ARMOR_STAND) {
                this.proceedReelIn(event.getHook().getLocation(), player, fishingGame);
            } else {
                fishingGame.cancel();
                this.nextEffect.remove(uuid);
                this.nextLoot.remove(uuid);
                AdventureUtils.playerMessage(player, MessageManager.prefix + MessageManager.hookOther);
            }
        }
    }

    private void noBarWaterReelIn(PlayerFishEvent event) {
        Entity entity = event.getCaught();
        if (!(entity instanceof Item)) {
            return;
        }
        Item item = (Item)entity;
        entity.remove();
        event.setExpToDrop(0);
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        Loot loot = this.nextLoot.remove(uuid);
        VanillaLoot vanilla = this.vanillaLoot.remove(uuid);
        Effect effect = this.nextEffect.remove(uuid);
        if (vanilla != null) {
            this.dropVanillaLoot(player, vanilla, item.getLocation(), effect.getDoubleLootChance() > Math.random());
        } else if (loot instanceof Mob) {
            Mob mob = (Mob)loot;
            this.summonMob(player, loot, item.getLocation(), mob, effect.getScoreMultiplier());
        } else if (loot instanceof DroppedItem) {
            DroppedItem droppedItem = (DroppedItem)loot;
            if (ConfigManager.enableMcMMOLoot && Math.random() < ConfigManager.mcMMOLootChance && this.dropMcMMOLoot(player, item.getLocation(), effect.getDoubleLootChance() > Math.random())) {
                return;
            }
            this.dropCustomFishingLoot(player, item.getLocation(), droppedItem, effect.getDoubleLootChance() > Math.random(), effect.getScoreMultiplier(), effect.getSizeMultiplier());
        }
    }

    private void noBarLavaReelIn(PlayerFishEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        BobberCheckTask bobberCheckTask = this.hookCheckTaskMap.remove(uuid);
        if (bobberCheckTask != null && bobberCheckTask.isHooked()) {
            Loot loot = this.nextLoot.remove(uuid);
            VanillaLoot vanilla = this.vanillaLoot.remove(uuid);
            Effect effect = this.nextEffect.remove(uuid);
            if (vanilla != null) {
                this.dropVanillaLoot(player, vanilla, event.getHook().getLocation(), effect.getDoubleLootChance() > Math.random());
            } else if (loot instanceof Mob) {
                Mob mob = (Mob)loot;
                this.summonMob(player, loot, event.getHook().getLocation(), mob, effect.getScoreMultiplier());
            } else if (loot instanceof DroppedItem) {
                DroppedItem droppedItem = (DroppedItem)loot;
                if (ConfigManager.enableMcMMOLoot && Math.random() < ConfigManager.mcMMOLootChance && this.dropMcMMOLoot(player, event.getHook().getLocation(), effect.getDoubleLootChance() > Math.random())) {
                    return;
                }
                this.dropCustomFishingLoot(player, event.getHook().getLocation(), droppedItem, effect.getDoubleLootChance() > Math.random(), effect.getScoreMultiplier(), effect.getSizeMultiplier());
            }
        }
    }

    public void proceedReelIn(Location hookLoc, Player player, FishingGame fishingGame) {
        fishingGame.cancel();
        UUID uuid = player.getUniqueId();
        Loot loot = this.nextLoot.remove(uuid);
        VanillaLoot vanilla = this.vanillaLoot.remove(uuid);
        Effect effect = this.nextEffect.remove(uuid);
        player.removePotionEffect(PotionEffectType.SLOW);
        if (fishingGame.isSuccess()) {
            if (ConfigManager.rodLoseDurability) {
                this.loseDurability(player);
            }
            if (hookLoc.getBlock().getType() == Material.LAVA) {
                hookLoc.add(0.0, 0.3, 0.0);
            }
            if (vanilla != null) {
                this.dropVanillaLoot(player, vanilla, hookLoc, effect.getDoubleLootChance() > Math.random());
            } else if (loot instanceof Mob) {
                Mob mob = (Mob)loot;
                this.summonMob(player, loot, hookLoc, mob, effect.getScoreMultiplier());
            } else if (loot instanceof DroppedItem) {
                DroppedItem droppedItem = (DroppedItem)loot;
                if (ConfigManager.enableMcMMOLoot && Math.random() < ConfigManager.mcMMOLootChance && this.dropMcMMOLoot(player, hookLoc, effect.getDoubleLootChance() > Math.random())) {
                    return;
                }
                this.dropCustomFishingLoot(player, hookLoc, droppedItem, effect.getDoubleLootChance() > Math.random(), effect.getScoreMultiplier(), effect.getSizeMultiplier());
            }
        } else {
            this.fail(player, loot, vanilla != null);
        }
    }

    private void dropCustomFishingLoot(Player player, Location location, DroppedItem droppedItem, boolean isDouble, double scoreMultiplier, double sizeMultiplier) {
        ItemStack drop = this.getCustomFishingLootItemStack(droppedItem, player, sizeMultiplier);
        FishResultEvent fishResultEvent = new FishResultEvent(player, FishResult.CATCH_SPECIAL_ITEM, isDouble, drop, droppedItem.getKey());
        Bukkit.getPluginManager().callEvent((Event)fishResultEvent);
        if (fishResultEvent.isCancelled()) {
            return;
        }
        if (Competition.currentCompetition != null) {
            float score = Competition.currentCompetition.getGoal() == CompetitionGoal.MAX_SIZE || Competition.currentCompetition.getGoal() == CompetitionGoal.TOTAL_SIZE ? this.getSize(drop) : (float)((double)((float)droppedItem.getScore()) * scoreMultiplier);
            Competition.currentCompetition.refreshData(player, score, fishResultEvent.isDouble());
            Competition.currentCompetition.tryJoinCompetition(player);
        }
        if (droppedItem.getSuccessActions() != null) {
            for (Action action : droppedItem.getSuccessActions()) {
                action.doOn(player, null);
            }
        }
        if (this.plugin.getVersionHelper().isFolia()) {
            this.plugin.getScheduler().runTask(() -> this.dropItem(player, location, fishResultEvent.isDouble(), drop), location);
        } else {
            this.dropItem(player, location, fishResultEvent.isDouble(), drop);
        }
        this.addStats(player.getUniqueId(), droppedItem, isDouble ? 2 : 1);
        this.sendSuccessTitle(player, droppedItem.getNick());
    }

    public ItemStack getCustomFishingLootItemStack(DroppedItem droppedItem, Player player) {
        return this.getCustomFishingLootItemStack(droppedItem, player, 1.0);
    }

    public ItemStack getCustomFishingLootItemStack(DroppedItem droppedItem, @Nullable Player player, double sizeMultiplier) {
        ItemStack drop = this.plugin.getIntegrationManager().build(droppedItem.getMaterial());
        if (drop.getType() != Material.AIR) {
            if (droppedItem.getRandomEnchants() != null) {
                ItemStackUtils.addRandomEnchants(drop, droppedItem.getRandomEnchants());
            }
            if (droppedItem.isRandomDurability()) {
                ItemStackUtils.addRandomDamage(drop);
            }
            if (ConfigManager.preventPickUp && player != null) {
                ItemStackUtils.addOwner(drop, player.getName());
            }
            ItemStackUtils.addExtraMeta(drop, droppedItem, sizeMultiplier);
        }
        return drop;
    }

    private boolean dropMcMMOLoot(Player player, Location location, boolean isDouble) {
        ItemStack itemStack = McMMOTreasure.getTreasure(player);
        if (itemStack == null) {
            return false;
        }
        FishResultEvent fishResultEvent = new FishResultEvent(player, FishResult.CATCH_VANILLA_ITEM, isDouble, itemStack, "vanilla");
        Bukkit.getPluginManager().callEvent((Event)fishResultEvent);
        if (fishResultEvent.isCancelled()) {
            return true;
        }
        this.doVanillaActions(player, location, itemStack, fishResultEvent.isDouble());
        new VanillaXPImpl(new Random().nextInt(24), true).doOn(player, null);
        return true;
    }

    private void dropVanillaLoot(Player player, VanillaLoot vanillaLoot, Location location, boolean isDouble) {
        ItemStack mcMMOItemStack;
        ItemStack itemStack = vanillaLoot.getItemStack();
        if (ConfigManager.enableMcMMOLoot && Math.random() < ConfigManager.mcMMOLootChance && (mcMMOItemStack = McMMOTreasure.getTreasure(player)) != null) {
            itemStack = mcMMOItemStack;
        }
        FishResultEvent fishResultEvent = new FishResultEvent(player, FishResult.CATCH_VANILLA_ITEM, isDouble, itemStack, "vanilla");
        Bukkit.getPluginManager().callEvent((Event)fishResultEvent);
        if (fishResultEvent.isCancelled()) {
            return;
        }
        this.doVanillaActions(player, location, itemStack, fishResultEvent.isDouble());
        new VanillaXPImpl(vanillaLoot.getXp(), true).doOn(player, null);
    }

    private void doVanillaActions(Player player, Location location, ItemStack itemStack, boolean isDouble) {
        if (Competition.currentCompetition != null) {
            Competition.currentCompetition.refreshData(player, (float)this.plugin.getLootManager().getVanilla_loot().getScore(), isDouble);
            Competition.currentCompetition.tryJoinCompetition(player);
        }
        Loot vanilla = this.plugin.getLootManager().getVanilla_loot();
        this.addStats(player.getUniqueId(), vanilla, isDouble ? 2 : 1);
        if (vanilla.getSuccessActions() != null) {
            for (Action action : vanilla.getSuccessActions()) {
                action.doOn(player, null);
            }
        }
        AdventureUtils.playerSound(player, Sound.Source.PLAYER, Key.key("minecraft:entity.experience_orb.pickup"), 1.0f, 1.0f);
        if (this.plugin.getVersionHelper().isFolia()) {
            this.plugin.getScheduler().runTask(() -> this.dropItem(player, location, isDouble, itemStack), location);
        } else {
            this.dropItem(player, location, isDouble, itemStack);
        }
        this.sendSuccessTitle(player, itemStack);
    }

    private void dropItem(Player player, Location location, boolean isDouble, ItemStack itemStack) {
        if (itemStack.getType() == Material.AIR) {
            return;
        }
        Item item = location.getWorld().dropItem(location, itemStack);
        Vector vector = player.getLocation().subtract(location).toVector().multiply(0.105);
        vector = vector.setY((vector.getY() + 0.2) * 1.18);
        item.setVelocity(vector);
        if (isDouble) {
            Item item2 = location.getWorld().dropItem(location, itemStack);
            item2.setVelocity(vector);
        }
    }

    private void addStats(UUID uuid, Loot loot, int amount) {
        if (!ConfigManager.enableStatistics) {
            return;
        }
        if (loot.isDisableStats()) {
            return;
        }
        this.plugin.getStatisticsManager().addFishAmount(uuid, loot, amount);
    }

    private void summonMob(Player player, Loot loot, Location location, Mob mob, double scoreMultiplier) {
        MobInterface mobInterface = this.plugin.getIntegrationManager().getMobInterface();
        if (mobInterface == null) {
            return;
        }
        FishResultEvent fishResultEvent = new FishResultEvent(player, FishResult.CATCH_MOB, false, null, loot.getKey());
        if (fishResultEvent.isCancelled()) {
            return;
        }
        if (Competition.currentCompetition != null) {
            float score = Competition.currentCompetition.getGoal() == CompetitionGoal.MAX_SIZE || Competition.currentCompetition.getGoal() == CompetitionGoal.TOTAL_SIZE ? 0.0f : (float)loot.getScore();
            Competition.currentCompetition.refreshData(player, (float)((double)score * scoreMultiplier), false);
            Competition.currentCompetition.tryJoinCompetition(player);
        }
        if (loot.getSuccessActions() != null) {
            for (Action action : loot.getSuccessActions()) {
                action.doOn(player, null);
            }
        }
        mobInterface.summon(player.getLocation(), location, mob);
        this.addStats(player.getUniqueId(), mob, 1);
        this.sendSuccessTitle(player, loot.getNick());
    }

    @NotNull
    private Component getTitleComponent(ItemStack itemStack, String text) {
        int lootIndex;
        Component titleComponent = Component.text("");
        int startIndex = 0;
        while ((lootIndex = text.indexOf("{loot}", startIndex)) != -1) {
            String before = text.substring(startIndex, lootIndex);
            titleComponent = titleComponent.append(AdventureUtils.getComponentFromMiniMessage(before));
            startIndex = lootIndex + 6;
            titleComponent = titleComponent.append(this.getDisplayName(itemStack));
        }
        String after = text.substring(startIndex);
        titleComponent = titleComponent.append(AdventureUtils.getComponentFromMiniMessage(after));
        return titleComponent;
    }

    private void sendSuccessTitle(Player player, String loot) {
        if (!ConfigManager.enableSuccessTitle) {
            return;
        }
        this.plugin.getScheduler().runTaskAsyncLater(() -> AdventureUtils.playerTitle(player, ConfigManager.successTitle[new Random().nextInt(ConfigManager.successTitle.length)].replace("{loot}", loot).replace("{player}", player.getName()), ConfigManager.successSubTitle[new Random().nextInt(ConfigManager.successSubTitle.length)].replace("{loot}", loot).replace("{player}", player.getName()), ConfigManager.successFadeIn, ConfigManager.successFadeStay, ConfigManager.successFadeOut), 400L, TimeUnit.MILLISECONDS);
    }

    private void sendSuccessTitle(Player player, ItemStack itemStack) {
        if (!ConfigManager.enableSuccessTitle) {
            return;
        }
        String title = ConfigManager.successTitle[new Random().nextInt(ConfigManager.successTitle.length)];
        Component titleComponent = this.getTitleComponent(itemStack, title);
        String subTitle = ConfigManager.successSubTitle[new Random().nextInt(ConfigManager.successSubTitle.length)];
        Component subtitleComponent = this.getTitleComponent(itemStack, subTitle);
        this.plugin.getScheduler().runTaskAsyncLater(() -> AdventureUtils.playerTitle(player, titleComponent, subtitleComponent, ConfigManager.successFadeIn, ConfigManager.successFadeStay, ConfigManager.successFadeOut), 400L, TimeUnit.MILLISECONDS);
    }

    private void loseDurability(Player player) {
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        this.plugin.getScheduler().runTaskAsyncLater(() -> {
            ItemStack rod = this.getFishingRod(player);
            if (rod != null) {
                this.plugin.getIntegrationManager().loseCustomDurability(rod, player);
            }
        }, 50L, TimeUnit.MILLISECONDS);
    }

    private ItemStack getFishingRod(Player player) {
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        if (mainHand.getType() == Material.FISHING_ROD) {
            return mainHand;
        }
        ItemStack offHand = player.getInventory().getItemInOffHand();
        if (offHand.getType() == Material.FISHING_ROD) {
            return offHand;
        }
        return null;
    }

    public void fail(Player player, Loot loot, boolean isVanilla) {
        FishResultEvent fishResultEvent = new FishResultEvent(player, FishResult.FAILURE, false, null, null);
        Bukkit.getServer().getPluginManager().callEvent((Event)fishResultEvent);
        if (fishResultEvent.isCancelled()) {
            return;
        }
        if (!isVanilla && loot != null && loot.getFailureActions() != null) {
            for (Action action : loot.getFailureActions()) {
                action.doOn(player, null);
            }
        }
        if (!ConfigManager.enableFailureTitle) {
            return;
        }
        this.plugin.getScheduler().runTaskAsyncLater(() -> AdventureUtils.playerTitle(player, ConfigManager.failureTitle[new Random().nextInt(ConfigManager.failureTitle.length)], ConfigManager.failureSubTitle[new Random().nextInt(ConfigManager.failureSubTitle.length)], ConfigManager.failureFadeIn, ConfigManager.failureFadeStay, ConfigManager.failureFadeOut), 400L, TimeUnit.MILLISECONDS);
    }

    public void showBar(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.fishingPlayerMap.get(uuid) != null) {
            return;
        }
        Loot loot = this.nextLoot.get(uuid);
        if (loot != null) {
            if (loot == Loot.EMPTY) {
                return;
            }
            this.showFishingBar(player, loot);
        }
    }

    public void onMMOItemsRodCast(PlayerFishEvent event) {
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        this.setCustomTag(inventory.getItemInMainHand());
        this.setCustomTag(inventory.getItemInOffHand());
    }

    private void setCustomTag(ItemStack itemStack) {
        if (itemStack.getType() != Material.FISHING_ROD) {
            return;
        }
        NBTItem nbtItem = new NBTItem(itemStack);
        if (nbtItem.getCompound("CustomFishing") != null || !nbtItem.hasTag("MMOITEMS_ITEM_ID")) {
            return;
        }
        ItemStackUtils.addIdentifier(itemStack, "rod", nbtItem.getString("MMOITEMS_ITEM_ID"));
    }

    public boolean isCoolDown(Player player, long delay) {
        long time = System.currentTimeMillis();
        return this.coolDown.computeIfAbsent(player.getUniqueId(), k -> time - delay) + delay > time;
    }

    private void addEnchantEffect(Effect initialEffect, ItemStack itemStack, FishingCondition fishingCondition) {
        for (String key : this.plugin.getIntegrationManager().getEnchantmentInterface().getEnchants(itemStack)) {
            Effect enchantEffect = this.plugin.getEffectManager().getEnchantEffect(key);
            if (enchantEffect == null) continue;
            initialEffect.addEffect(enchantEffect);
        }
    }

    public List<Loot> getPossibleLootList(FishingCondition fishingCondition, boolean finder, Collection<Loot> values) {
        Stream<Loot> stream = values.stream();
        if (finder) {
            stream = stream.filter(Loot::isShowInFinder);
        }
        return stream.filter(loot -> {
            RequirementInterface[] requirements = loot.getRequirements();
            if (requirements == null) {
                return true;
            }
            for (RequirementInterface requirement : requirements) {
                if (requirement.isConditionMet(fishingCondition)) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    @Override
    public void onInteract(PlayerInteractEvent event) {
        ItemStack itemStack = event.getItem();
        Player player = event.getPlayer();
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        NBTItem nbtItem = new NBTItem(itemStack);
        NBTCompound cfCompound = nbtItem.getCompound("CustomFishing");
        if (cfCompound != null && cfCompound.getString("type").equals("util") && cfCompound.getString("id").equals("fishfinder")) {
            if (this.isCoolDown(player, 1000L)) {
                return;
            }
            this.useFinder(event.getPlayer());
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        String totemID = nbtItem.getString("Totem");
        if (totemID.equals("")) {
            return;
        }
        TotemConfig totem = this.plugin.getTotemManager().getTotem(totemID);
        if (totem == null) {
            return;
        }
        if (this.isCoolDown(player, 1000L)) {
            return;
        }
        String blockID = this.plugin.getIntegrationManager().getBlockInterface().getID(block);
        if (blockID == null) {
            return;
        }
        List<TotemConfig> totemList = this.plugin.getTotemManager().getTotemsByCoreID(blockID);
        if (totemList == null || !totemList.contains(totem)) {
            return;
        }
        FishingCondition fishingCondition = new FishingCondition(block.getLocation(), player, null, null);
        if (totem.getRequirements() != null) {
            for (RequirementInterface requirementInterface : totem.getRequirements()) {
                if (requirementInterface.isConditionMet(fishingCondition)) continue;
                return;
            }
        }
        Location coreLoc = block.getLocation();
        int direction = this.plugin.getTotemManager().checkLocationModel(totem.getOriginalModel(), coreLoc);
        if (direction == 0) {
            return;
        }
        TotemActivationEvent totemActivationEvent = new TotemActivationEvent(player, coreLoc, totem);
        Bukkit.getPluginManager().callEvent((Event)totemActivationEvent);
        if (totemActivationEvent.isCancelled()) {
            return;
        }
        if (this.activeTotemMap.get(LocationUtils.getSimpleLocation(coreLoc)) != null) {
            this.activeTotemMap.get(LocationUtils.getSimpleLocation(coreLoc)).stop();
        }
        this.plugin.getTotemManager().removeModel(totem.getFinalModel(), coreLoc, direction);
        if (player.getGameMode() != GameMode.CREATIVE) {
            itemStack.setAmount(itemStack.getAmount() - 1);
        }
        if (totem.getActivatorActions() != null) {
            for (Action action : totem.getActivatorActions()) {
                action.doOn(player, null);
            }
        }
        if (totem.getNearbyActions() != null) {
            for (Action action : totem.getNearbyActions()) {
                for (Player nearby : LocationUtils.getNearbyPlayers(coreLoc, totem.getRadius())) {
                    action.doOn(nearby, player);
                }
            }
        }
        ActivatedTotem activatedTotem = new ActivatedTotem(coreLoc, totem, this, direction, player.getName());
        this.activeTotemMap.put(LocationUtils.getSimpleLocation(coreLoc), activatedTotem);
    }

    private void useFinder(Player player) {
        if (!ConfigManager.getWorldsList().contains(player.getWorld().getName())) {
            return;
        }
        FishingCondition fishingCondition = new FishingCondition(player.getLocation(), player, null, null);
        List<Loot> possibleLoots = this.getPossibleLootList(fishingCondition, true, this.plugin.getLootManager().getAllLoots());
        FishFinderEvent fishFinderEvent = new FishFinderEvent(player, possibleLoots);
        Bukkit.getPluginManager().callEvent((Event)fishFinderEvent);
        if (fishFinderEvent.isCancelled()) {
            return;
        }
        if (possibleLoots.size() == 0) {
            AdventureUtils.playerMessage(player, MessageManager.prefix + MessageManager.noLoot);
            return;
        }
        StringJoiner stringJoiner = new StringJoiner(MessageManager.splitChar);
        possibleLoots.forEach(loot -> stringJoiner.add(loot.getNick()));
        AdventureUtils.playerMessage(player, MessageManager.prefix + MessageManager.possibleLoots + stringJoiner);
    }

    private void showFishingBar(Player player, @NotNull Loot loot) {
        MiniGameConfig game = loot.getFishingGames() != null ? loot.getFishingGames()[new Random().nextInt(loot.getFishingGames().length)] : this.plugin.getBarMechanicManager().getRandomGame();
        int difficult = game.getRandomDifficulty() + this.nextEffect.getOrDefault(player.getUniqueId(), new Effect()).getDifficulty();
        MiniGameStartEvent miniGameStartEvent = new MiniGameStartEvent(player, Math.min(10, Math.max(1, difficult)));
        Bukkit.getPluginManager().callEvent((Event)miniGameStartEvent);
        if (miniGameStartEvent.isCancelled()) {
            return;
        }
        FishingBar fishingBar = game.getRandomBar();
        FishingGame fishingGame = null;
        Location hookLoc = this.getHookLocation(player);
        if (hookLoc == null) {
            return;
        }
        if (fishingBar instanceof ModeOneBar) {
            ModeOneBar modeOneBar = (ModeOneBar)fishingBar;
            fishingGame = new ModeOneGame(this.plugin, this, System.currentTimeMillis() + (long)game.getTime() * 1000L, player, miniGameStartEvent.getDifficulty(), modeOneBar);
        } else if (fishingBar instanceof ModeTwoBar) {
            ModeTwoBar modeTwoBar = (ModeTwoBar)fishingBar;
            fishingGame = new ModeTwoGame(this.plugin, this, System.currentTimeMillis() + (long)game.getTime() * 1000L, player, miniGameStartEvent.getDifficulty(), modeTwoBar, hookLoc);
        } else if (fishingBar instanceof ModeThreeBar) {
            ModeThreeBar modeThreeBar = (ModeThreeBar)fishingBar;
            fishingGame = new ModeThreeGame(this.plugin, this, System.currentTimeMillis() + (long)game.getTime() * 1000L, player, miniGameStartEvent.getDifficulty(), modeThreeBar);
        }
        if (fishingGame != null) {
            this.fishingPlayerMap.put(player.getUniqueId(), fishingGame);
        }
        if (loot.getHookActions() != null) {
            for (Action action : loot.getHookActions()) {
                action.doOn(player, null);
            }
        }
        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, game.getTime() * 20, 3));
    }

    @Override
    public void onQuit(Player player) {
        UUID uuid = player.getUniqueId();
        this.coolDown.remove(uuid);
        this.nextLoot.remove(uuid);
        this.nextEffect.remove(uuid);
        this.vanillaLoot.remove(uuid);
        BobberCheckTask task = this.hookCheckTaskMap.remove(uuid);
        if (task != null) {
            task.stop();
        }
        this.removeHook(uuid);
    }

    public void removeFishingPlayer(Player player) {
        this.fishingPlayerMap.remove(player.getUniqueId());
    }

    private Component getDisplayName(ItemStack itemStack) {
        String name;
        NBTItem nbtItem = new NBTItem(itemStack);
        NBTCompound nbtCompound = nbtItem.getCompound("display");
        if (nbtCompound != null && !(name = nbtCompound.getString("Name")).equals("")) {
            return GsonComponentSerializer.gson().deserialize(name);
        }
        String type = itemStack.getType().toString().toLowerCase();
        if (itemStack.getType().isBlock()) {
            return GsonComponentSerializer.gson().deserialize("{\"translate\":\"block.minecraft." + type + "\"}");
        }
        return GsonComponentSerializer.gson().deserialize("{\"translate\":\"item.minecraft." + type + "\"}");
    }

    public void removeTotem(Location coreLoc) {
        this.activeTotemMap.remove(LocationUtils.getSimpleLocation(coreLoc));
    }

    public void removePlayerFromLavaFishing(Player player) {
        this.hookCheckTaskMap.remove(player.getUniqueId());
    }

    public float getSize(ItemStack itemStack) {
        NBTCompound fishMeta = new NBTItem(itemStack).getCompound("FishMeta");
        return fishMeta != null ? fishMeta.getFloat("size").floatValue() : 0.0f;
    }

    public void addTotemBreakDetectToCache(SimpleLocation part, SimpleLocation coreLoc) {
        this.breakDetectionMap.put(part, coreLoc);
    }

    public void removeTotemBreakDetectFromCache(SimpleLocation part) {
        this.breakDetectionMap.remove(part);
    }

    @Override
    public void onBreakBlock(BlockBreakEvent event) {
        ActivatedTotem activatedTotem;
        SimpleLocation coreLoc = this.breakDetectionMap.get(LocationUtils.getSimpleLocation(event.getBlock().getLocation()));
        if (coreLoc != null && (activatedTotem = this.activeTotemMap.get(coreLoc)) != null) {
            activatedTotem.stop();
        }
    }

    public void removeHook(UUID uuid) {
        FishHook fishHook = this.hooks.remove(uuid);
        if (fishHook != null) {
            if (this.plugin.getVersionHelper().isFolia()) {
                this.plugin.getScheduler().runTask(() -> ((FishHook)fishHook).remove(), fishHook.getLocation());
            } else {
                fishHook.remove();
            }
        }
    }

    @Nullable
    public FishHook getHook(UUID uuid) {
        return this.hooks.get(uuid);
    }

    @Nullable
    public Location getHookLocation(Player player) {
        FishHook fishHook = this.hooks.get(player.getUniqueId());
        if (fishHook != null) {
            return fishHook.getLocation();
        }
        return null;
    }

    @Override
    public void onConsumeItem(PlayerItemConsumeEvent event) {
        ItemStack itemStack = event.getItem();
        NBTCompound nbtCompound = new NBTItem(itemStack).getCompound("CustomFishing");
        if (nbtCompound == null) {
            return;
        }
        if (!nbtCompound.getString("type").equals("loot")) {
            return;
        }
        String lootKey = nbtCompound.getString("id");
        Loot loot = this.plugin.getLootManager().getLoot(lootKey);
        if (loot == null) {
            return;
        }
        if (!(loot instanceof DroppedItem)) {
            return;
        }
        DroppedItem droppedItem = (DroppedItem)loot;
        Player player = event.getPlayer();
        if (droppedItem.getConsumeActions() != null) {
            for (Action action : droppedItem.getConsumeActions()) {
                action.doOn(player, null);
            }
        }
    }
}

