/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.manager;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.data.PlayerStatisticsData;
import net.momirealms.customfishing.fishing.loot.Loot;
import net.momirealms.customfishing.listener.JoinQuitListener;
import net.momirealms.customfishing.manager.ConfigManager;
import net.momirealms.customfishing.object.DataFunction;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class StatisticsManager
extends DataFunction {
    private final ConcurrentHashMap<UUID, PlayerStatisticsData> statisticsDataMap = new ConcurrentHashMap();
    private final JoinQuitListener joinQuitListener = new JoinQuitListener(this);
    private final CustomFishing plugin;

    public StatisticsManager(CustomFishing plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        if (!ConfigManager.enableStatistics) {
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)this.joinQuitListener, (Plugin)this.plugin);
    }

    @Override
    public void unload() {
        HandlerList.unregisterAll((Listener)this.joinQuitListener);
    }

    public void saveStatisticsDataForOnlinePlayers(boolean unlock) {
        this.plugin.getDataManager().getDataStorageInterface().saveStatistics(this.statisticsDataMap.entrySet(), unlock);
    }

    @Override
    public void disable() {
        this.unload();
        this.saveStatisticsDataForOnlinePlayers(true);
        this.statisticsDataMap.clear();
    }

    @Override
    public void onQuit(Player player) {
        UUID uuid = player.getUniqueId();
        PlayerStatisticsData playerStatisticsData = this.statisticsDataMap.remove(uuid);
        this.triedTimes.remove(player.getUniqueId());
        if (playerStatisticsData != null) {
            this.plugin.getScheduler().runTaskAsync(() -> this.plugin.getDataManager().getDataStorageInterface().saveStatistics(uuid, playerStatisticsData, true));
        }
    }

    @Override
    public void onJoin(Player player) {
        this.plugin.getScheduler().runTaskAsyncLater(() -> this.joinReadData(player, false), 500L, TimeUnit.MILLISECONDS);
    }

    public void joinReadData(Player player, boolean force) {
        if (player == null || !player.isOnline()) {
            return;
        }
        PlayerStatisticsData statisticsData = this.plugin.getDataManager().getDataStorageInterface().loadStatistics(player.getUniqueId(), force);
        if (statisticsData != null) {
            this.statisticsDataMap.put(player.getUniqueId(), statisticsData);
        } else if (!force) {
            if (this.checkTriedTimes(player.getUniqueId())) {
                this.plugin.getScheduler().runTaskAsyncLater(() -> this.joinReadData(player, false), 2500L, TimeUnit.MILLISECONDS);
            } else {
                this.plugin.getScheduler().runTaskAsyncLater(() -> this.joinReadData(player, true), 2500L, TimeUnit.MILLISECONDS);
            }
        }
    }

    public void addFishAmount(UUID uuid, Loot loot, int amount) {
        PlayerStatisticsData statisticsData = this.statisticsDataMap.get(uuid);
        if (statisticsData != null) {
            statisticsData.addFishAmount(loot, uuid, amount);
        }
    }

    public int getFishAmount(UUID uuid, String key) {
        PlayerStatisticsData statisticsData = this.statisticsDataMap.get(uuid);
        if (statisticsData != null) {
            return statisticsData.getFishAmount(key);
        }
        return -1;
    }

    public int getTotalFishAmount(UUID uuid) {
        PlayerStatisticsData statisticsData = this.statisticsDataMap.get(uuid);
        if (statisticsData != null) {
            return statisticsData.getTotalCatchAmount();
        }
        return -1;
    }

    public boolean hasFished(UUID uuid, String key) {
        PlayerStatisticsData statisticsData = this.statisticsDataMap.get(uuid);
        if (statisticsData != null) {
            return statisticsData.hasFished(key);
        }
        return false;
    }

    public double getCategoryUnlockProgress(UUID uuid, String category) {
        PlayerStatisticsData statisticsData = this.statisticsDataMap.get(uuid);
        if (statisticsData != null) {
            return statisticsData.getCategoryUnlockProgress(category);
        }
        return -1.0;
    }

    public int getCategoryTotalFishAmount(UUID uuid, String category) {
        PlayerStatisticsData statisticsData = this.statisticsDataMap.get(uuid);
        if (statisticsData != null) {
            return statisticsData.getCategoryTotalFishAmount(category);
        }
        return -1;
    }

    public boolean reset(UUID uuid) {
        PlayerStatisticsData statisticsData = this.statisticsDataMap.get(uuid);
        if (statisticsData != null) {
            statisticsData.reset();
            return true;
        }
        return false;
    }

    public void setData(UUID uuid, String key, int amount) {
        PlayerStatisticsData statisticsData = this.statisticsDataMap.get(uuid);
        if (statisticsData != null) {
            statisticsData.setData(key, amount);
        }
    }
}

