/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.action.Action;
import net.momirealms.customfishing.fishing.action.CommandActionImpl;
import net.momirealms.customfishing.fishing.action.MessageActionImpl;
import net.momirealms.customfishing.fishing.totem.CorePos;
import net.momirealms.customfishing.fishing.totem.FinalModel;
import net.momirealms.customfishing.fishing.totem.OriginalModel;
import net.momirealms.customfishing.fishing.totem.TotemConfig;
import net.momirealms.customfishing.integration.BlockInterface;
import net.momirealms.customfishing.object.Function;
import net.momirealms.customfishing.util.AdventureUtils;
import net.momirealms.customfishing.util.ConfigUtils;
import net.momirealms.customfishing.util.LocationUtils;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class TotemManager
extends Function {
    private final CustomFishing plugin;
    private final HashMap<String, TotemConfig> totems;
    private final HashMap<String, List<TotemConfig>> cores;
    private final HashMap<String, String> blockIDs;
    private final HashMap<String, String> invertedIDs;

    public TotemManager(CustomFishing plugin) {
        this.plugin = plugin;
        this.totems = new HashMap();
        this.cores = new HashMap();
        this.blockIDs = new HashMap();
        this.invertedIDs = new HashMap();
    }

    @Override
    public void unload() {
        this.totems.clear();
        this.cores.clear();
        this.blockIDs.clear();
        this.invertedIDs.clear();
    }

    @Override
    public void load() {
        this.loadBlocks();
        this.loadTotems();
    }

    @Nullable
    public TotemConfig getTotem(String key) {
        return this.totems.get(key);
    }

    public HashMap<String, TotemConfig> getTotems() {
        return this.totems;
    }

    @Nullable
    public List<TotemConfig> getTotemsByCoreID(String core) {
        return this.cores.get(core);
    }

    public HashMap<String, List<TotemConfig>> getCores() {
        return this.cores;
    }

    @Nullable
    public String getBlockID(String block) {
        return this.blockIDs.get(block);
    }

    public HashMap<String, String> getBlockIDs() {
        return this.blockIDs;
    }

    @Nullable
    public String getInvertedBlock(String id) {
        return this.invertedIDs.get(id);
    }

    public HashMap<String, String> getInvertedIDs() {
        return this.invertedIDs;
    }

    private void loadBlocks() {
        YamlConfiguration config = ConfigUtils.getConfig("totem_blocks/default.yml");
        config.getKeys(false).forEach(key -> this.blockIDs.put((String)key, config.getString(key)));
        config.getKeys(false).forEach(key -> this.invertedIDs.put(config.getString(key), (String)key));
    }

    private void loadTotems() {
        YamlConfiguration config = ConfigUtils.getConfig("totems/default.yml");
        for (String key : config.getKeys(false)) {
            List cores = config.getStringList(key + ".core");
            List flat = config.getStringList(key + ".layer.1");
            int length = ((String)flat.get(0)).split("\\s+").length;
            int width = flat.size();
            int height = Objects.requireNonNull(config.getConfigurationSection(key + ".layer")).getKeys(false).size();
            CorePos corePos = null;
            OriginalModel originalModel = new OriginalModel(length, width, height);
            FinalModel finalModel = new FinalModel(length, width, height);
            for (int k = 0; k < height; ++k) {
                List layer = config.getStringList(key + ".layer." + (k + 1));
                if (layer.size() != width) {
                    AdventureUtils.consoleMessage("<red>[CustomFishing] Each layer should have the same size! Error exists in totem:" + key + " layer:" + (k + 1));
                    return;
                }
                for (int j = 0; j < width; ++j) {
                    String[] args = ((String)layer.get(j)).split("\\s+");
                    if (args.length != length) {
                        AdventureUtils.consoleMessage("<red>[CustomFishing] Each layer should have the same size! Error exists in totem:" + key + " layer:" + (k + 1) + " line:" + (k + 1));
                        return;
                    }
                    for (int i = 0; i < length; ++i) {
                        if (args[i].startsWith("(") && args[i].endsWith(")")) {
                            String content = args[i].substring(1, args[i].length() - 1);
                            corePos = this.getCorePos(cores, corePos, originalModel, k, j, i, content);
                            finalModel.setElement("*", i, j, k);
                            continue;
                        }
                        if (args[i].contains(">")) {
                            String before = args[i].split(">")[0];
                            String after = args[i].split(">")[1];
                            finalModel.setElement(after, i, j, k);
                            corePos = this.getCorePos(cores, corePos, originalModel, k, j, i, before);
                            continue;
                        }
                        Object elements = args[i].split("\\|");
                        originalModel.setElement((String[])elements, i, j, k);
                        for (String core : cores) {
                            for (String element : elements) {
                                if (!element.equals(core)) continue;
                                corePos = new CorePos(i, j, k);
                            }
                        }
                    }
                }
            }
            if (corePos == null) {
                AdventureUtils.consoleMessage("<red>[CustomTotems] No core block set for totem:" + key);
                return;
            }
            finalModel.setCorePos(corePos);
            originalModel.setCorePos(corePos);
            TotemConfig totem = new TotemConfig(originalModel, finalModel, config.getInt(key + ".radius", 16), config.getInt(key + ".duration", 300), Particle.valueOf((String)config.getString(key + ".particle", "SPELL_MOB").toUpperCase()), ConfigUtils.getEffect(config.getConfigurationSection(key + ".effect")));
            ArrayList<Record> actionList = new ArrayList<Record>();
            ArrayList<Record> nearActionList = new ArrayList<Record>();
            if (config.contains(key + ".action")) {
                for (String action : Objects.requireNonNull(config.getConfigurationSection(key + ".action")).getKeys(false)) {
                    switch (action) {
                        case "commands-activator": {
                            actionList.add(new CommandActionImpl(config.getStringList(key + ".action." + action).toArray(new String[0]), null));
                            break;
                        }
                        case "commands-nearby-players": {
                            nearActionList.add(new CommandActionImpl(config.getStringList(key + ".action." + action).toArray(new String[0]), null));
                            break;
                        }
                        case "messages-activator": {
                            actionList.add(new MessageActionImpl(config.getStringList(key + ".action." + action).toArray(new String[0]), null));
                            break;
                        }
                        case "messages-nearby-players": {
                            nearActionList.add(new MessageActionImpl(config.getStringList(key + ".action." + action).toArray(new String[0]), null));
                        }
                    }
                }
            }
            totem.setActivatorActions(actionList.toArray(new Action[0]));
            totem.setNearbyActions(nearActionList.toArray(new Action[0]));
            totem.setRequirements(ConfigUtils.getRequirementsWithMsg(config.getConfigurationSection(key + ".requirements")));
            if (config.getBoolean(key + ".hologram.enable", false)) {
                totem.setHoloText(config.getStringList(key + ".hologram.text").toArray(new String[0]));
                totem.setHoloOffset(config.getDouble(key + ".hologram.y-offset"));
            }
            if (config.contains(key + ".potion-effects")) {
                ArrayList<PotionEffect> potionEffectList = new ArrayList<PotionEffect>();
                for (String potion : config.getConfigurationSection(key + ".potion-effects").getKeys(false)) {
                    PotionEffectType potionType = PotionEffectType.getByName((String)potion.toUpperCase());
                    if (potionType == null) continue;
                    int time = 40;
                    if (potionType.equals((Object)PotionEffectType.NIGHT_VISION)) {
                        time = 400;
                    }
                    PotionEffect potionEffect = new PotionEffect(potionType, time, config.getInt(key + ".potion-effects." + potion, 1) - 1);
                    potionEffectList.add(potionEffect);
                }
                totem.setPotionEffects(potionEffectList.toArray(new PotionEffect[0]));
            }
            this.totems.put(key, totem);
            for (String core : cores) {
                if (this.cores.get(core) == null) {
                    ArrayList<TotemConfig> totems = new ArrayList<TotemConfig>();
                    totems.add(totem);
                    this.cores.put(core, totems);
                    continue;
                }
                this.cores.get(core).add(totem);
            }
        }
        AdventureUtils.consoleMessage("[CustomFishing] Loaded <green>" + this.totems.size() + " <gray>totem(s)");
    }

    private CorePos getCorePos(List<String> cores, CorePos corePos, OriginalModel originalModel, int k, int j, int i, String content) {
        String[] elements = content.split("\\|");
        originalModel.setElement(elements, i, j, k);
        for (String core : cores) {
            for (String element : elements) {
                if (!element.equals(core)) continue;
                corePos = new CorePos(i, j, k);
            }
        }
        return corePos;
    }

    public int checkLocationModel(OriginalModel model, Location location) {
        block47: {
            String id;
            String[] elements;
            int x;
            int z;
            Location loc;
            int i;
            Location startLoc;
            int width;
            int length;
            int height;
            int zOffset;
            int xOffset;
            BlockInterface blockInterface;
            block46: {
                block45: {
                    block44: {
                        block43: {
                            block42: {
                                block41: {
                                    block40: {
                                        blockInterface = this.plugin.getIntegrationManager().getBlockInterface();
                                        CorePos corePos = model.getCorePos();
                                        xOffset = corePos.getX();
                                        int yOffset = corePos.getY();
                                        zOffset = corePos.getZ();
                                        height = model.getHeight();
                                        length = model.getLength();
                                        width = model.getWidth();
                                        startLoc = location.clone().subtract(0.0, (double)yOffset, 0.0);
                                        for (i = 0; i < height; ++i) {
                                            loc = startLoc.clone().add((double)(-xOffset), (double)i, (double)(-zOffset));
                                            for (z = 0; z < width; ++z) {
                                                block2: for (x = 0; x < length; ++x) {
                                                    elements = model.getElement(x, z, i);
                                                    id = blockInterface.getID(loc.clone().add((double)x, 0.0, (double)z).getBlock());
                                                    for (String element : elements) {
                                                        if (element.equals("*")) continue block2;
                                                        if (id != null) {
                                                            if (id.equals(element)) continue block2;
                                                            continue;
                                                        }
                                                        break block40;
                                                    }
                                                    break block40;
                                                }
                                            }
                                        }
                                        return 1;
                                    }
                                    for (i = 0; i < height; ++i) {
                                        loc = startLoc.clone().add((double)xOffset, (double)i, (double)zOffset);
                                        for (z = 0; z < width; ++z) {
                                            block6: for (x = 0; x < length; ++x) {
                                                elements = model.getElement(x, z, i);
                                                id = blockInterface.getID(loc.clone().add((double)(-x), 0.0, (double)(-z)).getBlock());
                                                for (String element : elements) {
                                                    if (element.equals("*")) continue block6;
                                                    if (id != null) {
                                                        if (id.equals(element)) continue block6;
                                                        continue;
                                                    }
                                                    break block41;
                                                }
                                                break block41;
                                            }
                                        }
                                    }
                                    return 2;
                                }
                                for (i = 0; i < height; ++i) {
                                    loc = startLoc.clone().add((double)(-zOffset), (double)i, (double)xOffset);
                                    for (z = 0; z < width; ++z) {
                                        block10: for (x = 0; x < length; ++x) {
                                            elements = model.getElement(x, z, i);
                                            id = blockInterface.getID(loc.clone().add((double)z, 0.0, (double)(-x)).getBlock());
                                            for (String element : elements) {
                                                if (element.equals("*")) continue block10;
                                                if (id != null) {
                                                    if (id.equals(element)) continue block10;
                                                    continue;
                                                }
                                                break block42;
                                            }
                                            break block42;
                                        }
                                    }
                                }
                                return 3;
                            }
                            for (i = 0; i < height; ++i) {
                                loc = startLoc.clone().add((double)zOffset, (double)i, (double)(-xOffset));
                                for (z = 0; z < width; ++z) {
                                    block14: for (x = 0; x < length; ++x) {
                                        elements = model.getElement(x, z, i);
                                        id = blockInterface.getID(loc.clone().add((double)(-z), 0.0, (double)x).getBlock());
                                        for (String element : elements) {
                                            if (element.equals("*")) continue block14;
                                            if (id != null) {
                                                if (id.equals(element)) continue block14;
                                                continue;
                                            }
                                            break block43;
                                        }
                                        break block43;
                                    }
                                }
                            }
                            return 4;
                        }
                        for (i = 0; i < height; ++i) {
                            loc = startLoc.clone().add((double)(-zOffset), (double)i, (double)(-xOffset));
                            for (z = 0; z < width; ++z) {
                                block18: for (x = 0; x < length; ++x) {
                                    elements = model.getElement(x, z, i);
                                    id = blockInterface.getID(loc.clone().add((double)z, 0.0, (double)x).getBlock());
                                    for (String element : elements) {
                                        if (element.equals("*")) continue block18;
                                        if (id != null) {
                                            if (id.equals(element)) continue block18;
                                            continue;
                                        }
                                        break block44;
                                    }
                                    break block44;
                                }
                            }
                        }
                        return 5;
                    }
                    for (i = 0; i < height; ++i) {
                        loc = startLoc.clone().add((double)zOffset, (double)i, (double)xOffset);
                        for (z = 0; z < width; ++z) {
                            block22: for (x = 0; x < length; ++x) {
                                elements = model.getElement(x, z, i);
                                id = blockInterface.getID(loc.clone().add((double)(-z), 0.0, (double)(-x)).getBlock());
                                for (String element : elements) {
                                    if (element.equals("*")) continue block22;
                                    if (id != null) {
                                        if (id.equals(element)) continue block22;
                                        continue;
                                    }
                                    break block45;
                                }
                                break block45;
                            }
                        }
                    }
                    return 6;
                }
                for (i = 0; i < height; ++i) {
                    loc = startLoc.clone().add((double)(-xOffset), (double)i, (double)zOffset);
                    for (z = 0; z < width; ++z) {
                        block26: for (x = 0; x < length; ++x) {
                            elements = model.getElement(x, z, i);
                            id = blockInterface.getID(loc.clone().add((double)x, 0.0, (double)(-z)).getBlock());
                            for (String element : elements) {
                                if (element.equals("*")) continue block26;
                                if (id != null) {
                                    if (id.equals(element)) continue block26;
                                    continue;
                                }
                                break block46;
                            }
                            break block46;
                        }
                    }
                }
                return 7;
            }
            for (i = 0; i < height; ++i) {
                loc = startLoc.clone().add((double)xOffset, (double)i, (double)(-zOffset));
                for (z = 0; z < width; ++z) {
                    block30: for (x = 0; x < length; ++x) {
                        elements = model.getElement(x, z, i);
                        id = blockInterface.getID(loc.clone().add((double)(-x), 0.0, (double)z).getBlock());
                        for (String element : elements) {
                            if (element.equals("*")) continue block30;
                            if (id != null) {
                                if (id.equals(element)) continue block30;
                                continue;
                            }
                            break block47;
                        }
                        break block47;
                    }
                }
            }
            return 8;
        }
        return 0;
    }

    public void removeModel(FinalModel model, Location coreLoc, int direction) {
        BlockInterface blockInterface = this.plugin.getIntegrationManager().getBlockInterface();
        CorePos corePos = model.getCorePos();
        int xOffset = corePos.getX();
        int yOffset = corePos.getY();
        int zOffset = corePos.getZ();
        int height = model.getHeight();
        int length = model.getLength();
        int width = model.getWidth();
        Location startLoc = coreLoc.clone().subtract(0.0, (double)yOffset, 0.0);
        switch (direction) {
            case 1: {
                for (int i = 0; i < height; ++i) {
                    Location loc = startLoc.clone().add((double)(-xOffset), (double)i, (double)(-zOffset));
                    for (int z = 0; z < width; ++z) {
                        for (int x = 0; x < length; ++x) {
                            if (model.getElement(x, z, i) == null) {
                                blockInterface.removeBlock(loc.clone().add((double)x, 0.0, (double)z).getBlock());
                                continue;
                            }
                            if (!model.getElement(x, z, i).equals("*")) {
                                blockInterface.replaceBlock(loc.clone().add((double)x, 0.0, (double)z), model.getElement(x, z, i));
                            }
                            this.plugin.getFishingManager().addTotemBreakDetectToCache(LocationUtils.getSimpleLocation(loc.clone().add((double)x, 0.0, (double)z)), LocationUtils.getSimpleLocation(coreLoc));
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int i = 0; i < height; ++i) {
                    Location loc = startLoc.clone().add((double)xOffset, (double)i, (double)zOffset);
                    for (int z = 0; z < width; ++z) {
                        for (int x = 0; x < length; ++x) {
                            if (model.getElement(x, z, i) == null) {
                                blockInterface.removeBlock(loc.clone().add((double)(-x), 0.0, (double)(-z)).getBlock());
                                continue;
                            }
                            if (!model.getElement(x, z, i).equals("*")) {
                                blockInterface.replaceBlock(loc.clone().add((double)(-x), 0.0, (double)(-z)), model.getElement(x, z, i));
                            }
                            this.plugin.getFishingManager().addTotemBreakDetectToCache(LocationUtils.getSimpleLocation(loc.clone().add((double)(-x), 0.0, (double)(-z))), LocationUtils.getSimpleLocation(coreLoc));
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int i = 0; i < height; ++i) {
                    Location loc = startLoc.clone().add((double)(-zOffset), (double)i, (double)xOffset);
                    for (int z = 0; z < width; ++z) {
                        for (int x = 0; x < length; ++x) {
                            if (model.getElement(x, z, i) == null) {
                                blockInterface.removeBlock(loc.clone().add((double)z, 0.0, (double)(-x)).getBlock());
                                continue;
                            }
                            if (!model.getElement(x, z, i).equals("*")) {
                                blockInterface.replaceBlock(loc.clone().add((double)z, 0.0, (double)(-x)), model.getElement(x, z, i));
                            }
                            this.plugin.getFishingManager().addTotemBreakDetectToCache(LocationUtils.getSimpleLocation(loc.clone().add((double)z, 0.0, (double)(-x))), LocationUtils.getSimpleLocation(coreLoc));
                        }
                    }
                }
                break;
            }
            case 4: {
                for (int i = 0; i < height; ++i) {
                    Location loc = startLoc.clone().add((double)zOffset, (double)i, (double)(-xOffset));
                    for (int z = 0; z < width; ++z) {
                        for (int x = 0; x < length; ++x) {
                            if (model.getElement(x, z, i) == null) {
                                blockInterface.removeBlock(loc.clone().add((double)(-z), 0.0, (double)x).getBlock());
                                continue;
                            }
                            if (!model.getElement(x, z, i).equals("*")) {
                                blockInterface.replaceBlock(loc.clone().add((double)(-z), 0.0, (double)x), model.getElement(x, z, i));
                            }
                            this.plugin.getFishingManager().addTotemBreakDetectToCache(LocationUtils.getSimpleLocation(loc.clone().add((double)(-z), 0.0, (double)x)), LocationUtils.getSimpleLocation(coreLoc));
                        }
                    }
                }
                break;
            }
            case 5: {
                for (int i = 0; i < height; ++i) {
                    Location loc = startLoc.clone().add((double)(-zOffset), (double)i, (double)(-xOffset));
                    for (int z = 0; z < width; ++z) {
                        for (int x = 0; x < length; ++x) {
                            if (model.getElement(x, z, i) == null) {
                                blockInterface.removeBlock(loc.clone().add((double)z, 0.0, (double)x).getBlock());
                                continue;
                            }
                            if (!model.getElement(x, z, i).equals("*")) {
                                blockInterface.replaceBlock(loc.clone().add((double)z, 0.0, (double)x), model.getElement(x, z, i));
                            }
                            this.plugin.getFishingManager().addTotemBreakDetectToCache(LocationUtils.getSimpleLocation(loc.clone().add((double)z, 0.0, (double)x)), LocationUtils.getSimpleLocation(coreLoc));
                        }
                    }
                }
                break;
            }
            case 6: {
                for (int i = 0; i < height; ++i) {
                    Location loc = startLoc.clone().add((double)zOffset, (double)i, (double)xOffset);
                    for (int z = 0; z < width; ++z) {
                        for (int x = 0; x < length; ++x) {
                            if (model.getElement(x, z, i) == null) {
                                blockInterface.removeBlock(loc.clone().add((double)(-z), 0.0, (double)(-x)).getBlock());
                                continue;
                            }
                            if (!model.getElement(x, z, i).equals("*")) {
                                blockInterface.replaceBlock(loc.clone().add((double)(-z), 0.0, (double)(-x)), model.getElement(x, z, i));
                            }
                            this.plugin.getFishingManager().addTotemBreakDetectToCache(LocationUtils.getSimpleLocation(loc.clone().add((double)(-z), 0.0, (double)(-x))), LocationUtils.getSimpleLocation(coreLoc));
                        }
                    }
                }
                break;
            }
            case 7: {
                for (int i = 0; i < height; ++i) {
                    Location loc = startLoc.clone().add((double)(-xOffset), (double)i, (double)zOffset);
                    for (int z = 0; z < width; ++z) {
                        for (int x = 0; x < length; ++x) {
                            if (model.getElement(x, z, i) == null) {
                                blockInterface.removeBlock(loc.clone().add((double)x, 0.0, (double)(-z)).getBlock());
                                continue;
                            }
                            if (!model.getElement(x, z, i).equals("*")) {
                                blockInterface.replaceBlock(loc.clone().add((double)x, 0.0, (double)(-z)), model.getElement(x, z, i));
                            }
                            this.plugin.getFishingManager().addTotemBreakDetectToCache(LocationUtils.getSimpleLocation(loc.clone().add((double)x, 0.0, (double)(-z))), LocationUtils.getSimpleLocation(coreLoc));
                        }
                    }
                }
                break;
            }
            case 8: {
                for (int i = 0; i < height; ++i) {
                    Location loc = startLoc.clone().add((double)xOffset, (double)i, (double)(-zOffset));
                    for (int z = 0; z < width; ++z) {
                        for (int x = 0; x < length; ++x) {
                            if (model.getElement(x, z, i) == null) {
                                blockInterface.removeBlock(loc.clone().add((double)(-x), 0.0, (double)z).getBlock());
                                continue;
                            }
                            if (!model.getElement(x, z, i).equals("*")) {
                                blockInterface.replaceBlock(loc.clone().add((double)(-x), 0.0, (double)z), model.getElement(x, z, i));
                            }
                            this.plugin.getFishingManager().addTotemBreakDetectToCache(LocationUtils.getSimpleLocation(loc.clone().add((double)(-x), 0.0, (double)z)), LocationUtils.getSimpleLocation(coreLoc));
                        }
                    }
                }
                break;
            }
        }
    }

    public void clearBreakDetectCache(FinalModel model, Location startLoc, int direction) {
        CorePos corePos = model.getCorePos();
        int xOffset = corePos.getX();
        int zOffset = corePos.getZ();
        int height = model.getHeight();
        int length = model.getLength();
        int width = model.getWidth();
        switch (direction) {
            case 1: {
                for (int i = 0; i < height; ++i) {
                    Location loc = startLoc.clone().add((double)(-xOffset), (double)i, (double)(-zOffset));
                    for (int z = 0; z < width; ++z) {
                        for (int x = 0; x < length; ++x) {
                            if (model.getElement(x, z, i) == null) continue;
                            this.plugin.getFishingManager().removeTotemBreakDetectFromCache(LocationUtils.getSimpleLocation(loc.clone().add((double)x, 0.0, (double)z)));
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int i = 0; i < height; ++i) {
                    Location loc = startLoc.clone().add((double)xOffset, (double)i, (double)zOffset);
                    for (int z = 0; z < width; ++z) {
                        for (int x = 0; x < length; ++x) {
                            if (model.getElement(x, z, i) == null) continue;
                            this.plugin.getFishingManager().removeTotemBreakDetectFromCache(LocationUtils.getSimpleLocation(loc.clone().add((double)(-x), 0.0, (double)(-z))));
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int i = 0; i < height; ++i) {
                    Location loc = startLoc.clone().add((double)(-zOffset), (double)i, (double)xOffset);
                    for (int z = 0; z < width; ++z) {
                        for (int x = 0; x < length; ++x) {
                            if (model.getElement(x, z, i) == null) continue;
                            this.plugin.getFishingManager().removeTotemBreakDetectFromCache(LocationUtils.getSimpleLocation(loc.clone().add((double)z, 0.0, (double)(-x))));
                        }
                    }
                }
                break;
            }
            case 4: {
                for (int i = 0; i < height; ++i) {
                    Location loc = startLoc.clone().add((double)zOffset, (double)i, (double)(-xOffset));
                    for (int z = 0; z < width; ++z) {
                        for (int x = 0; x < length; ++x) {
                            if (model.getElement(x, z, i) == null) continue;
                            this.plugin.getFishingManager().removeTotemBreakDetectFromCache(LocationUtils.getSimpleLocation(loc.clone().add((double)(-z), 0.0, (double)x)));
                        }
                    }
                }
                break;
            }
            case 5: {
                for (int i = 0; i < height; ++i) {
                    Location loc = startLoc.clone().add((double)(-zOffset), (double)i, (double)(-xOffset));
                    for (int z = 0; z < width; ++z) {
                        for (int x = 0; x < length; ++x) {
                            if (model.getElement(x, z, i) == null) continue;
                            this.plugin.getFishingManager().removeTotemBreakDetectFromCache(LocationUtils.getSimpleLocation(loc.clone().add((double)z, 0.0, (double)x)));
                        }
                    }
                }
                break;
            }
            case 6: {
                for (int i = 0; i < height; ++i) {
                    Location loc = startLoc.clone().add((double)zOffset, (double)i, (double)xOffset);
                    for (int z = 0; z < width; ++z) {
                        for (int x = 0; x < length; ++x) {
                            if (model.getElement(x, z, i) == null) continue;
                            this.plugin.getFishingManager().removeTotemBreakDetectFromCache(LocationUtils.getSimpleLocation(loc.clone().add((double)(-z), 0.0, (double)(-x))));
                        }
                    }
                }
                break;
            }
            case 7: {
                for (int i = 0; i < height; ++i) {
                    Location loc = startLoc.clone().add((double)(-xOffset), (double)i, (double)zOffset);
                    for (int z = 0; z < width; ++z) {
                        for (int x = 0; x < length; ++x) {
                            if (model.getElement(x, z, i) == null) continue;
                            this.plugin.getFishingManager().removeTotemBreakDetectFromCache(LocationUtils.getSimpleLocation(loc.clone().add((double)x, 0.0, (double)(-z))));
                        }
                    }
                }
                break;
            }
            case 8: {
                for (int i = 0; i < height; ++i) {
                    Location loc = startLoc.clone().add((double)xOffset, (double)i, (double)(-zOffset));
                    for (int z = 0; z < width; ++z) {
                        for (int x = 0; x < length; ++x) {
                            if (model.getElement(x, z, i) == null) continue;
                            this.plugin.getFishingManager().removeTotemBreakDetectFromCache(LocationUtils.getSimpleLocation(loc.clone().add((double)(-x), 0.0, (double)z)));
                        }
                    }
                }
                break;
            }
        }
    }
}

