/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.object;

import java.util.ArrayList;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.integration.papi.PlaceholderManager;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class DynamicText {
    private final Player owner;
    private String originalValue;
    private String latestValue;
    private String[] ownerPlaceholders;

    public DynamicText(Player owner, String rawValue) {
        this.owner = owner;
        this.analyze(rawValue);
    }

    private void analyze(String value) {
        ArrayList<String> placeholdersOwner = new ArrayList<String>(CustomFishing.getInstance().getIntegrationManager().getPlaceholderManager().detectPlaceholders(value));
        String origin = value;
        for (String placeholder : placeholdersOwner) {
            origin = origin.replace(placeholder, "%s");
        }
        this.originalValue = origin;
        this.ownerPlaceholders = placeholdersOwner.toArray(new String[0]);
        this.latestValue = this.originalValue;
        this.update();
    }

    public String getLatestValue() {
        return this.latestValue;
    }

    public boolean update() {
        String string = this.originalValue;
        if (this.ownerPlaceholders.length != 0) {
            PlaceholderManager placeholderManager = CustomFishing.getInstance().getIntegrationManager().getPlaceholderManager();
            if ("%s".equals(this.originalValue)) {
                string = placeholderManager.parseSinglePlaceholder((OfflinePlayer)this.owner, this.ownerPlaceholders[0]);
            } else {
                Object[] values = new String[this.ownerPlaceholders.length];
                for (int i = 0; i < this.ownerPlaceholders.length; ++i) {
                    values[i] = placeholderManager.parseSinglePlaceholder((OfflinePlayer)this.owner, this.ownerPlaceholders[i]);
                }
                string = String.format(this.originalValue, values);
            }
        }
        if (!this.latestValue.equals(string)) {
            this.latestValue = string;
            return true;
        }
        return false;
    }
}

