/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.scheduler;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.manager.ConfigManager;
import net.momirealms.customfishing.object.Function;
import net.momirealms.customfishing.scheduler.BukkitSchedulerImpl;
import net.momirealms.customfishing.scheduler.FoliaSchedulerImpl;
import net.momirealms.customfishing.scheduler.SchedulerPlatform;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public class Scheduler
extends Function {
    private final ScheduledThreadPoolExecutor schedule;
    private final SchedulerPlatform schedulerPlatform;

    public Scheduler(CustomFishing plugin) {
        this.schedulerPlatform = plugin.getVersionHelper().isFolia() ? new FoliaSchedulerImpl(plugin) : new BukkitSchedulerImpl(plugin);
        this.schedule = new ScheduledThreadPoolExecutor(1);
        this.schedule.setMaximumPoolSize(1);
        this.schedule.setKeepAliveTime(10L, TimeUnit.SECONDS);
        this.schedule.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
    }

    public void reload() {
        this.schedule.getQueue().clear();
        this.schedule.setCorePoolSize(ConfigManager.corePoolSize);
        this.schedule.setMaximumPoolSize(ConfigManager.maximumPoolSize);
        this.schedule.setKeepAliveTime(ConfigManager.keepAliveTime, TimeUnit.SECONDS);
    }

    @Override
    public void disable() {
        this.schedule.shutdown();
    }

    public ScheduledFuture<?> runTaskAsyncLater(Runnable runnable, long delay, TimeUnit timeUnit) {
        return this.schedule.schedule(runnable, delay, timeUnit);
    }

    public void runTaskAsync(Runnable runnable) {
        this.schedule.execute(runnable);
    }

    public void runTask(Runnable runnable) {
        this.schedulerPlatform.runTask(runnable);
    }

    public void runTask(Runnable runnable, Location location) {
        this.schedulerPlatform.runTask(runnable, location);
    }

    public ScheduledFuture<?> runTaskLater(Runnable runnable, long delay, TimeUnit timeUnit) {
        return this.schedule.schedule(() -> this.runTask(runnable), delay, timeUnit);
    }

    public ScheduledFuture<?> runTaskLater(Runnable runnable, long delay, TimeUnit timeUnit, Location location) {
        return this.schedule.schedule(() -> this.runTask(runnable, location), delay, timeUnit);
    }

    public <T> Future<T> callSyncMethod(@NotNull Callable<T> task) {
        return this.schedulerPlatform.callSyncMethod(task);
    }

    public ScheduledFuture<?> runTaskTimerAsync(Runnable runnable, long delay, long interval, TimeUnit timeUnit) {
        return this.schedule.scheduleAtFixedRate(runnable, delay, interval, timeUnit);
    }

    public ScheduledFuture<?> runTaskTimer(Runnable runnable, long delay, long interval, TimeUnit timeUnit) {
        return this.schedule.scheduleAtFixedRate(() -> this.runTask(runnable), delay, interval, timeUnit);
    }

    public ScheduledFuture<?> runTaskTimer(Runnable runnable, long delay, long interval, TimeUnit timeUnit, Location location) {
        return this.schedule.scheduleAtFixedRate(() -> this.runTask(runnable, location), delay, interval, timeUnit);
    }
}

