/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.util;

import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.dvs.versioning.BasicVersioning;
import dev.dejvokep.boostedyaml.dvs.versioning.Versioning;
import dev.dejvokep.boostedyaml.settings.dumper.DumperSettings;
import dev.dejvokep.boostedyaml.settings.general.GeneralSettings;
import dev.dejvokep.boostedyaml.settings.loader.LoaderSettings;
import dev.dejvokep.boostedyaml.settings.updater.UpdaterSettings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.Effect;
import net.momirealms.customfishing.fishing.action.Action;
import net.momirealms.customfishing.fishing.action.CommandActionImpl;
import net.momirealms.customfishing.fishing.action.JobXPImpl;
import net.momirealms.customfishing.fishing.action.MessageActionImpl;
import net.momirealms.customfishing.fishing.action.PotionEffectImpl;
import net.momirealms.customfishing.fishing.action.SkillXPImpl;
import net.momirealms.customfishing.fishing.action.SoundActionImpl;
import net.momirealms.customfishing.fishing.action.VanillaXPImpl;
import net.momirealms.customfishing.fishing.requirements.BaitImpl;
import net.momirealms.customfishing.fishing.requirements.BiomeImpl;
import net.momirealms.customfishing.fishing.requirements.CustomPapi;
import net.momirealms.customfishing.fishing.requirements.DateImpl;
import net.momirealms.customfishing.fishing.requirements.JobLevelImpl;
import net.momirealms.customfishing.fishing.requirements.PermissionImpl;
import net.momirealms.customfishing.fishing.requirements.Requirement;
import net.momirealms.customfishing.fishing.requirements.RequirementInterface;
import net.momirealms.customfishing.fishing.requirements.RodImpl;
import net.momirealms.customfishing.fishing.requirements.SeasonImpl;
import net.momirealms.customfishing.fishing.requirements.SkillLevelImpl;
import net.momirealms.customfishing.fishing.requirements.TimeImpl;
import net.momirealms.customfishing.fishing.requirements.WeatherImpl;
import net.momirealms.customfishing.fishing.requirements.WorldImpl;
import net.momirealms.customfishing.fishing.requirements.YPosImpl;
import net.momirealms.customfishing.helper.Log;
import net.momirealms.customfishing.util.AdventureUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ConfigUtils {
    public static YamlConfiguration getConfig(String configName) {
        File file = new File(CustomFishing.getInstance().getDataFolder(), configName);
        if (!file.exists()) {
            CustomFishing.getInstance().saveResource(configName, false);
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public static void update(String fileName) {
        try {
            YamlDocument.create((File)new File(CustomFishing.getInstance().getDataFolder(), fileName), (InputStream)Objects.requireNonNull(CustomFishing.getInstance().getResource(fileName)), (GeneralSettings)GeneralSettings.DEFAULT, (LoaderSettings)LoaderSettings.builder().setAutoUpdate(true).build(), (DumperSettings)DumperSettings.DEFAULT, (UpdaterSettings)UpdaterSettings.builder().setVersioning((Versioning)new BasicVersioning("config-version")).build());
        }
        catch (IOException e) {
            Log.warn(e.getMessage());
        }
    }

    public static YamlConfiguration readData(File file) {
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                AdventureUtils.consoleMessage("<red>[CustomFishing] Failed to generate data files!</red>");
            }
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public static RequirementInterface[] getRequirements(ConfigurationSection section) {
        if (section != null) {
            ArrayList<Requirement> requirements = new ArrayList<Requirement>();
            Iterator iterator = section.getKeys(false).iterator();
            while (iterator.hasNext()) {
                String type;
                switch (type = (String)iterator.next()) {
                    case "biome": {
                        requirements.add(new BiomeImpl(null, new HashSet<String>(section.getStringList(type))));
                        break;
                    }
                    case "weather": {
                        requirements.add(new WeatherImpl(null, section.getStringList(type)));
                        break;
                    }
                    case "ypos": {
                        requirements.add(new YPosImpl(null, section.getStringList(type)));
                        break;
                    }
                    case "season": {
                        requirements.add(new SeasonImpl(null, section.getStringList(type)));
                        break;
                    }
                    case "world": {
                        requirements.add(new WorldImpl(null, section.getStringList(type)));
                        break;
                    }
                    case "permission": {
                        requirements.add(new PermissionImpl(null, section.getString(type)));
                        break;
                    }
                    case "time": {
                        requirements.add(new TimeImpl(null, section.getStringList(type)));
                        break;
                    }
                    case "skill-level": {
                        requirements.add(new SkillLevelImpl(null, section.getInt(type)));
                        break;
                    }
                    case "job-level": {
                        requirements.add(new JobLevelImpl(null, section.getInt(type)));
                        break;
                    }
                    case "date": {
                        requirements.add(new DateImpl(null, new HashSet<String>(section.getStringList(type))));
                        break;
                    }
                    case "rod": {
                        requirements.add(new RodImpl(null, new HashSet<String>(section.getStringList(type))));
                        break;
                    }
                    case "bait": {
                        requirements.add(new BaitImpl(null, new HashSet<String>(section.getStringList(type))));
                        break;
                    }
                    case "papi-condition": {
                        requirements.add(new CustomPapi(null, Objects.requireNonNull(section.getConfigurationSection(type)).getValues(false)));
                    }
                }
            }
            return requirements.toArray(new RequirementInterface[0]);
        }
        return null;
    }

    public static RequirementInterface[] getRequirementsWithMsg(ConfigurationSection section) {
        if (section != null) {
            ArrayList<Requirement> requirements = new ArrayList<Requirement>();
            for (String id : section.getKeys(false)) {
                String[] stringArray;
                String type;
                ConfigurationSection innerSec = section.getConfigurationSection(id);
                if (innerSec == null || (type = innerSec.getString("type")) == null) continue;
                if (innerSec.getStringList("message").size() == 0) {
                    if (innerSec.getString("message") == null) {
                        stringArray = null;
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = innerSec.getString("message");
                    }
                } else {
                    stringArray = innerSec.getStringList("message").toArray(new String[0]);
                }
                String[] msg = stringArray;
                switch (type) {
                    case "biome": {
                        requirements.add(new BiomeImpl(msg, new HashSet<String>(innerSec.getStringList("value"))));
                        break;
                    }
                    case "weather": {
                        requirements.add(new WeatherImpl(msg, innerSec.getStringList("value")));
                        break;
                    }
                    case "ypos": {
                        requirements.add(new YPosImpl(msg, innerSec.getStringList("value")));
                        break;
                    }
                    case "season": {
                        requirements.add(new SeasonImpl(msg, innerSec.getStringList("value")));
                        break;
                    }
                    case "world": {
                        requirements.add(new WorldImpl(msg, innerSec.getStringList("value")));
                        break;
                    }
                    case "permission": {
                        requirements.add(new PermissionImpl(msg, innerSec.getString("value")));
                        break;
                    }
                    case "time": {
                        requirements.add(new TimeImpl(msg, innerSec.getStringList("value")));
                        break;
                    }
                    case "skill-level": {
                        requirements.add(new SkillLevelImpl(msg, innerSec.getInt("value")));
                        break;
                    }
                    case "job-level": {
                        requirements.add(new JobLevelImpl(msg, innerSec.getInt("value")));
                        break;
                    }
                    case "date": {
                        requirements.add(new DateImpl(msg, new HashSet<String>(innerSec.getStringList("value"))));
                        break;
                    }
                    case "rod": {
                        requirements.add(new RodImpl(msg, new HashSet<String>(innerSec.getStringList("value"))));
                        break;
                    }
                    case "bait": {
                        requirements.add(new BaitImpl(msg, new HashSet<String>(innerSec.getStringList("value"))));
                        break;
                    }
                    case "papi-condition": {
                        requirements.add(new CustomPapi(msg, Objects.requireNonNull(innerSec.getConfigurationSection("value")).getValues(false)));
                    }
                }
            }
            return requirements.toArray(new RequirementInterface[0]);
        }
        return null;
    }

    public static Action[] getActions(ConfigurationSection section, String nick) {
        if (section != null) {
            ArrayList<Record> actions = new ArrayList<Record>();
            Iterator iterator = section.getKeys(false).iterator();
            while (iterator.hasNext()) {
                String action;
                switch (action = (String)iterator.next()) {
                    case "message": {
                        actions.add(new MessageActionImpl(section.getStringList(action).toArray(new String[0]), nick));
                        break;
                    }
                    case "command": {
                        actions.add(new CommandActionImpl(section.getStringList(action).toArray(new String[0]), nick));
                        break;
                    }
                    case "exp": {
                        actions.add(new VanillaXPImpl(section.getInt(action), false));
                        break;
                    }
                    case "mending": {
                        actions.add(new VanillaXPImpl(section.getInt(action), true));
                        break;
                    }
                    case "skill-xp": {
                        actions.add(new SkillXPImpl(section.getDouble(action)));
                        break;
                    }
                    case "job-xp": {
                        actions.add(new JobXPImpl(section.getDouble(action)));
                        break;
                    }
                    case "sound": {
                        actions.add(new SoundActionImpl(section.getString(action + ".source"), section.getString(action + ".key"), (float)section.getDouble(action + ".volume"), (float)section.getDouble(action + ".pitch")));
                        break;
                    }
                    case "potion-effect": {
                        ArrayList<PotionEffect> potionEffectList = new ArrayList<PotionEffect>();
                        for (String key : section.getConfigurationSection(action).getKeys(false)) {
                            PotionEffectType type = PotionEffectType.getByName((String)section.getString(action + "." + key + ".type", "BLINDNESS").toUpperCase());
                            if (type == null) {
                                AdventureUtils.consoleMessage("<red>[CustomFishing] Potion effect " + section.getString(action + "." + key + ".type", "BLINDNESS") + " doesn't exists");
                            }
                            potionEffectList.add(new PotionEffect(type == null ? PotionEffectType.LUCK : type, section.getInt(action + "." + key + ".duration"), section.getInt(action + "." + key + ".amplifier")));
                        }
                        actions.add(new PotionEffectImpl(potionEffectList.toArray(new PotionEffect[0])));
                    }
                }
            }
            return actions.toArray(new Action[0]);
        }
        return null;
    }

    public static Effect getEffect(ConfigurationSection section) {
        Effect effect = new Effect();
        if (section == null) {
            return effect;
        }
        Iterator iterator = section.getKeys(false).iterator();
        while (iterator.hasNext()) {
            String modifier;
            switch (modifier = (String)iterator.next()) {
                case "weight-add": {
                    HashMap<String, Integer> as = new HashMap<String, Integer>();
                    Objects.requireNonNull(section.getConfigurationSection(modifier)).getValues(false).forEach((group, value) -> as.put((String)group, (Integer)value));
                    effect.setWeightAS(as);
                    break;
                }
                case "weight-multiply": {
                    HashMap<String, Double> md = new HashMap<String, Double>();
                    Objects.requireNonNull(section.getConfigurationSection(modifier)).getValues(false).forEach((group, value) -> md.put((String)group, Double.parseDouble(String.valueOf(value)) - 1.0));
                    effect.setWeightMD(md);
                    break;
                }
                case "time": {
                    effect.setTimeModifier(section.getDouble(modifier));
                    break;
                }
                case "difficulty": {
                    effect.setDifficulty(section.getInt(modifier));
                    break;
                }
                case "double-loot": {
                    effect.setDoubleLootChance(section.getDouble(modifier));
                    break;
                }
                case "score": {
                    effect.setScoreMultiplier(section.getDouble(modifier));
                    break;
                }
                case "size-multiply": {
                    effect.setSizeMultiplier(section.getDouble(modifier));
                    break;
                }
                case "lava-fishing": {
                    effect.setCanLavaFishing(section.getBoolean(modifier, false));
                }
            }
        }
        return effect;
    }
}

