/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.libs.net.kyori.adventure.text.Component;
import net.momirealms.customfishing.object.Reflection;
import net.momirealms.customfishing.util.AdventureUtils;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class InventoryUtils {
    @NotNull
    public static String toBase64(ItemStack[] contents) {
        boolean convert = false;
        for (ItemStack content : contents) {
            if (content == null) continue;
            convert = true;
            break;
        }
        if (convert) {
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
                dataOutput.writeInt(contents.length);
                for (ItemStack itemStack : contents) {
                    dataOutput.writeObject((Object)itemStack);
                }
                dataOutput.close();
                byte[] byteArr = outputStream.toByteArray();
                outputStream.close();
                return Base64Coder.encodeLines((byte[])byteArr);
            }
            catch (IOException e) {
                throw new RuntimeException("[CustomFishing] Data save error", e);
            }
        }
        return "";
    }

    @Nullable
    public static ItemStack[] getInventoryItems(String base64) {
        ItemStack[] itemStacks = null;
        try {
            itemStacks = InventoryUtils.stacksFromBase64(base64);
        }
        catch (IllegalArgumentException exception) {
            exception.printStackTrace();
        }
        return itemStacks;
    }

    private static ItemStack[] stacksFromBase64(String data) {
        ByteArrayInputStream inputStream;
        if (data == null || data.equals("")) {
            return new ItemStack[0];
        }
        try {
            inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
        }
        catch (IllegalArgumentException e) {
            return new ItemStack[0];
        }
        BukkitObjectInputStream dataInput = null;
        ItemStack[] stacks = null;
        try {
            dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            stacks = new ItemStack[dataInput.readInt()];
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (stacks == null) {
            return new ItemStack[0];
        }
        for (int i = 0; i < stacks.length; ++i) {
            try {
                stacks[i] = (ItemStack)dataInput.readObject();
                continue;
            }
            catch (IOException | ClassNotFoundException | NullPointerException e) {
                try {
                    dataInput.close();
                }
                catch (IOException exception) {
                    AdventureUtils.consoleMessage("<red>[CustomFishing] Error! Failed to read fishing bag data");
                }
                return null;
            }
        }
        try {
            dataInput.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stacks;
    }

    @NotNull
    public static Inventory createInventory(InventoryHolder inventoryHolder, int size, Component component) {
        try {
            Method createInvMethod = Reflection.bukkitClass.getMethod("createInventory", InventoryHolder.class, Integer.TYPE, Reflection.componentClass);
            return (Inventory)createInvMethod.invoke(null, inventoryHolder, size, AdventureUtils.getPaperComponent(component));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            exception.printStackTrace();
            throw new RuntimeException("Failed to create inventory");
        }
    }

    public static Inventory createInventory(InventoryHolder inventoryHolder, int size, String title) {
        if (CustomFishing.getInstance().getVersionHelper().isSpigot()) {
            return Bukkit.createInventory((InventoryHolder)inventoryHolder, (int)size, (String)AdventureUtils.replaceMiniMessage(title));
        }
        try {
            Method createInvMethod = Reflection.bukkitClass.getMethod("createInventory", InventoryHolder.class, Integer.TYPE, Reflection.componentClass);
            return (Inventory)createInvMethod.invoke(null, inventoryHolder, size, AdventureUtils.getPaperComponent(AdventureUtils.getComponentFromMiniMessage(title)));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            exception.printStackTrace();
            throw new RuntimeException("Failed to create inventory");
        }
    }
}

