/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.util;

import java.util.Collection;
import java.util.stream.Collectors;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.object.SimpleLocation;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class LocationUtils {
    public static SimpleLocation getSimpleLocation(Location location) {
        return new SimpleLocation(location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Nullable
    public static Location getLocation(SimpleLocation location) {
        World world = Bukkit.getWorld((String)location.worldName());
        if (world == null) {
            return null;
        }
        return new Location(world, (double)location.x(), (double)location.y(), (double)location.z());
    }

    public static Collection<Player> getNearbyPlayers(Location location, double radius) {
        Collection nearbyPlayers = CustomFishing.getInstance().getVersionHelper().isSpigot() ? (Collection)location.getWorld().getNearbyEntities(location, radius, radius, radius).stream().filter(entity -> entity instanceof Player).map(entity -> (Player)entity).collect(Collectors.toList()) : location.getNearbyPlayers(radius);
        return nearbyPlayers;
    }

    public static double getDistance(Location location1, Location location2) {
        double deltaX = location1.getX() - location2.getX();
        double deltaY = location1.getY() - location2.getY();
        double deltaZ = location1.getZ() - location2.getZ();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }
}

