/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.generator;

import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import com.plotsquared.core.util.MathMan;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.biome.BiomeType;
import java.util.Random;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.checkerframework.checker.nullness.qual.NonNull;

final class DelegatePlotGenerator
extends IndependentPlotGenerator {
    private final ChunkGenerator chunkGenerator;
    private final String world;

    public DelegatePlotGenerator(ChunkGenerator chunkGenerator, String string) {
        this.chunkGenerator = chunkGenerator;
        this.world = string;
    }

    @Override
    public void initialize(PlotArea plotArea) {
    }

    @Override
    public BiomeType getBiome(PlotArea plotArea, int n, int n2, int n3) {
        return null;
    }

    @Override
    public String getName() {
        return this.chunkGenerator.getClass().getName();
    }

    @Override
    public PlotArea getNewPlotArea(String string, String string2, PlotId plotId, PlotId plotId2) {
        return PlotSquared.platform().defaultGenerator().getNewPlotArea(string, string2, plotId, plotId2);
    }

    @Override
    public void generateChunk(final ZeroedDelegateScopedQueueCoordinator zeroedDelegateScopedQueueCoordinator, PlotArea plotArea, boolean bl) {
        World world = BukkitUtil.getWorld(this.world);
        Location location = zeroedDelegateScopedQueueCoordinator.getMin();
        int n = location.getX() >> 4;
        int n2 = location.getZ() >> 4;
        Random random = new Random(MathMan.pair((short)n, (short)n2));
        try {
            ChunkGenerator.BiomeGrid biomeGrid = new ChunkGenerator.BiomeGrid(){

                public void setBiome(int n, int n2, @NonNull Biome biome) {
                    zeroedDelegateScopedQueueCoordinator.setBiome(n, n2, BukkitAdapter.adapt((Biome)biome));
                }

                public void setBiome(int n, int n2, int n3, @NonNull Biome biome) {
                    zeroedDelegateScopedQueueCoordinator.setBiome(n, n3, BukkitAdapter.adapt((Biome)biome));
                }

                public @NonNull Biome getBiome(int n, int n2) {
                    return Biome.FOREST;
                }

                public @NonNull Biome getBiome(int n, int n2, int n3) {
                    return Biome.FOREST;
                }
            };
            this.chunkGenerator.generateChunkData(world, random, n, n2, biomeGrid);
            return;
        }
        catch (Throwable throwable) {
            for (BlockPopulator blockPopulator : this.chunkGenerator.getDefaultPopulators(world)) {
                blockPopulator.populate(world, random, world.getChunkAt(n, n2));
            }
            return;
        }
    }
}

