/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.CopperOxideFlag;
import com.plotsquared.core.plot.flag.implementations.MiscInteractFlag;
import com.plotsquared.core.plot.flag.implementations.SculkSensorInteractFlag;
import com.plotsquared.core.util.PlotFlagUtil;
import com.plotsquared.google.Inject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockReceiveGameEvent;

public class BlockEventListener117
implements Listener {
    private static final Set<Material> COPPER_OXIDIZING = Set.of(Material.COPPER_BLOCK, Material.EXPOSED_COPPER, Material.WEATHERED_COPPER, Material.OXIDIZED_COPPER, Material.CUT_COPPER, Material.EXPOSED_CUT_COPPER, Material.WEATHERED_CUT_COPPER, Material.OXIDIZED_CUT_COPPER, Material.CUT_COPPER_STAIRS, Material.EXPOSED_CUT_COPPER_STAIRS, Material.WEATHERED_CUT_COPPER_STAIRS, Material.OXIDIZED_CUT_COPPER_STAIRS, Material.CUT_COPPER_SLAB, Material.EXPOSED_CUT_COPPER_SLAB, Material.WEATHERED_CUT_COPPER_SLAB, Material.OXIDIZED_CUT_COPPER_SLAB);

    @Inject
    public BlockEventListener117() {
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockReceiveGame(BlockReceiveGameEvent blockReceiveGameEvent) {
        Object object;
        Block block = blockReceiveGameEvent.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        Entity entity = blockReceiveGameEvent.getEntity();
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        BukkitPlayer bukkitPlayer = null;
        if (entity instanceof Player && plotArea.notifyIfOutsideBuildArea(bukkitPlayer = BukkitUtil.adapt((Player)(object = (Player)entity)), location.getY())) {
            blockReceiveGameEvent.setCancelled(true);
            return;
        }
        object = location.getOwnedPlot();
        if (object == null && !PlotFlagUtil.isAreaRoadFlagsAndFlagEquals(plotArea, MiscInteractFlag.class, true) || object != null && (!((Boolean)((Plot)object).getFlag(MiscInteractFlag.class)).booleanValue() || !((Boolean)((Plot)object).getFlag(SculkSensorInteractFlag.class)).booleanValue())) {
            if (bukkitPlayer != null) {
                if (object != null && !((Plot)object).isAdded(bukkitPlayer.getUUID())) {
                    ((Plot)object).debug(bukkitPlayer.getName() + " couldn't trigger sculk sensors because both sculk-sensor-interact and misc-interact = false");
                    blockReceiveGameEvent.setCancelled(true);
                }
                return;
            }
            if (entity instanceof Item) {
                Item item = (Item)entity;
                UUID uUID = item.getThrower();
                if (object != null) {
                    if (uUID == null && (uUID = item.getOwner()) == null) {
                        ((Plot)object).debug("A thrown item couldn't trigger sculk sensors because both sculk-sensor-interact and misc-interact = false and the item's owner could not be resolved.");
                        blockReceiveGameEvent.setCancelled(true);
                        return;
                    }
                    if (!((Plot)object).isAdded(uUID) && !((Plot)object).isAdded(uUID)) {
                        ((Plot)object).debug("A thrown item couldn't trigger sculk sensors because both sculk-sensor-interact and misc-interact = false");
                        blockReceiveGameEvent.setCancelled(true);
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockFertilize(BlockFertilizeEvent blockFertilizeEvent) {
        Block block = blockFertilizeEvent.getBlock();
        List list = blockFertilizeEvent.getBlocks();
        Location location = BukkitUtil.adapt(((BlockState)list.get(0)).getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                Location location2 = BukkitUtil.adapt(((BlockState)list.get(i)).getLocation());
                if (!location2.isPlotArea()) continue;
                list.remove(i);
            }
        } else {
            Plot plot = plotArea.getOwnedPlot(location);
            if (plot == null) {
                blockFertilizeEvent.setCancelled(true);
                return;
            }
            for (int i = list.size() - 1; i >= 0; --i) {
                Location location3 = BukkitUtil.adapt(((BlockState)list.get(i)).getLocation());
                if (!plotArea.contains(location3.getX(), location3.getZ())) {
                    list.remove(i);
                    continue;
                }
                Plot plot2 = plotArea.getOwnedPlot(location3);
                if (!Objects.equals(plot2, plot)) {
                    blockFertilizeEvent.getBlocks().remove(i);
                    continue;
                }
                if (plotArea.buildRangeContainsY(location.getY())) continue;
                blockFertilizeEvent.getBlocks().remove(i);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent blockFormEvent) {
        Block block = blockFormEvent.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        if (location.isPlotRoad()) {
            blockFormEvent.setCancelled(true);
            return;
        }
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = plotArea.getOwnedPlot(location);
        if (plot == null) {
            return;
        }
        if (COPPER_OXIDIZING.contains(blockFormEvent.getNewState().getType()) && !((Boolean)plot.getFlag(CopperOxideFlag.class)).booleanValue()) {
            plot.debug("Copper could not oxide because copper-oxide = false");
            blockFormEvent.setCancelled(true);
        }
    }
}

