/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.plotsquared.bukkit.paperlib.PaperLib;
import com.plotsquared.bukkit.util.BukkitEntityUtil;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;

public class EntitySpawnListener
implements Listener {
    private static final String KEY = "P2";
    private static boolean ignoreTP = false;
    private static boolean hasPlotArea = false;
    private static String areaName = null;

    public static void testNether(Entity entity) {
        @NonNull World world = entity.getWorld();
        if (world.getEnvironment() != World.Environment.NETHER && world.getEnvironment() != World.Environment.THE_END) {
            return;
        }
        EntitySpawnListener.test(entity);
    }

    public static void testCreate(Entity entity) {
        @NonNull World world = entity.getWorld();
        if (!world.getName().equals(areaName)) {
            areaName = world.getName();
            hasPlotArea = PlotSquared.get().getPlotAreaManager().hasPlotArea(areaName);
        }
        if (!hasPlotArea) {
            return;
        }
        EntitySpawnListener.test(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(Entity entity) {
        @NonNull World world = entity.getWorld();
        List list = entity.getMetadata(KEY);
        if (list.isEmpty()) {
            if (PlotSquared.get().getPlotAreaManager().hasPlotArea(world.getName())) {
                entity.setMetadata(KEY, (MetadataValue)new FixedMetadataValue((Plugin)PlotSquared.platform(), (Object)entity.getLocation()));
            }
        } else {
            org.bukkit.Location location = (org.bukkit.Location)((MetadataValue)list.get(0)).value();
            World world2 = location.getWorld();
            if (!world2.equals(world)) {
                if (!ignoreTP) {
                    if (!world.getName().equalsIgnoreCase(world2 + "_the_end")) {
                        if (entity.getType() == EntityType.PLAYER) {
                            return;
                        }
                        try {
                            ignoreTP = true;
                            PaperLib.teleportAsync(entity, location);
                        }
                        finally {
                            ignoreTP = false;
                        }
                        if (entity.getLocation().getWorld().equals(world)) {
                            entity.remove();
                        }
                    }
                } else {
                    if (entity.getType() == EntityType.PLAYER) {
                        return;
                    }
                    entity.remove();
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void creatureSpawnEvent(EntitySpawnEvent entitySpawnEvent) {
        Entity entity = entitySpawnEvent.getEntity();
        Location location = BukkitUtil.adapt(entity.getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (!location.isPlotArea()) {
            return;
        }
        Plot plot = location.getOwnedPlotAbs();
        EntityType entityType = entity.getType();
        if (plot == null) {
            if (entityType == EntityType.DROPPED_ITEM) {
                if (Settings.Enabled_Components.KILL_ROAD_ITEMS) {
                    entitySpawnEvent.setCancelled(true);
                }
                return;
            }
            if (!plotArea.isMobSpawning()) {
                if (entityType == EntityType.PLAYER) {
                    return;
                }
                if (entityType.isAlive()) {
                    entitySpawnEvent.setCancelled(true);
                }
            }
            if (!plotArea.isMiscSpawnUnowned() && !entityType.isAlive()) {
                entitySpawnEvent.setCancelled(true);
            }
            return;
        }
        if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone(plot)) {
            entitySpawnEvent.setCancelled(true);
        }
        if (entityType == EntityType.ENDER_CRYSTAL) {
            if (BukkitEntityUtil.checkEntity(entity, plot)) {
                entitySpawnEvent.setCancelled(true);
            }
            return;
        }
        if (entityType == EntityType.SHULKER && !entity.hasMetadata("shulkerPlot")) {
            entity.setMetadata("shulkerPlot", (MetadataValue)new FixedMetadataValue((Plugin)PlotSquared.platform(), (Object)plot.getId()));
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent chunkLoadEvent) {
        @NonNull Chunk chunk = chunkLoadEvent.getChunk();
        for (Entity entity : chunk.getEntities()) {
            EntitySpawnListener.testCreate(entity);
        }
    }

    @EventHandler
    public void onVehicle(VehicleUpdateEvent vehicleUpdateEvent) {
        EntitySpawnListener.testNether((Entity)vehicleUpdateEvent.getVehicle());
    }

    @EventHandler
    public void onVehicle(VehicleCreateEvent vehicleCreateEvent) {
        EntitySpawnListener.testCreate((Entity)vehicleCreateEvent.getVehicle());
    }

    @EventHandler
    public void onVehicle(VehicleBlockCollisionEvent vehicleBlockCollisionEvent) {
        EntitySpawnListener.testNether((Entity)vehicleBlockCollisionEvent.getVehicle());
    }

    @EventHandler
    public void onTeleport(EntityTeleportEvent entityTeleportEvent) {
        Plot plot;
        Entity entity = entityTeleportEvent.getEntity();
        Entity entity2 = entityTeleportEvent.getEntity();
        Block block = entityTeleportEvent.getTo().getBlock();
        Location location = BukkitUtil.adapt(entity2.getLocation());
        PlotArea plotArea = location.getPlotArea();
        Location location2 = BukkitUtil.adapt(block.getLocation());
        PlotArea plotArea2 = location2.getPlotArea();
        if (plotArea2 == null) {
            if (entity2.getType() == EntityType.SHULKER && plotArea != null) {
                entityTeleportEvent.setCancelled(true);
            }
            return;
        }
        Plot plot2 = plotArea2.getOwnedPlot(location2);
        if (!(entity2.getType() != EntityType.SHULKER || plotArea == null || (plot = plotArea.getOwnedPlot(location)) == null && plot2 == null || plot != null && plot.equals(plot2) || plot2 != null && plot2.equals(plot))) {
            entityTeleportEvent.setCancelled(true);
            return;
        }
        if (entity instanceof Vehicle || entity instanceof ArmorStand) {
            EntitySpawnListener.testNether(entityTeleportEvent.getEntity());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void vehicleMove(VehicleMoveEvent vehicleMoveEvent) {
        EntitySpawnListener.testNether((Entity)vehicleMoveEvent.getVehicle());
    }

    @EventHandler
    public void spawn(CreatureSpawnEvent creatureSpawnEvent) {
        if (creatureSpawnEvent.getEntityType() == EntityType.ARMOR_STAND) {
            EntitySpawnListener.testCreate((Entity)creatureSpawnEvent.getEntity());
        }
    }
}

