/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.implementations.ForcefieldFlag;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class ForceFieldListener {
    private static Set<PlotPlayer<?>> getNearbyPlayers(Player player, Plot plot) {
        HashSet hashSet = new HashSet();
        for (Player player2 : player.getNearbyEntities(5.0, 5.0, 5.0).stream().filter(entity -> entity instanceof Player).map(entity -> (Player)entity).toList()) {
            BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player2);
            if (bukkitPlayer == null || !plot.equals(bukkitPlayer.getCurrentPlot()) || plot.isAdded(((PlotPlayer)bukkitPlayer).getUUID())) continue;
            hashSet.add(bukkitPlayer);
        }
        return hashSet;
    }

    private static PlotPlayer<?> hasNearbyPermitted(Player player, Plot plot) {
        for (Player player2 : player.getNearbyEntities(5.0, 5.0, 5.0).stream().filter(entity -> entity instanceof Player).map(entity -> (Player)entity).toList()) {
            BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player2);
            if (bukkitPlayer == null || !plot.equals(bukkitPlayer.getCurrentPlot()) || !plot.isAdded(((PlotPlayer)bukkitPlayer).getUUID())) continue;
            return bukkitPlayer;
        }
        return null;
    }

    private static Vector calculateVelocity(PlotPlayer<?> plotPlayer, PlotPlayer<?> plotPlayer2) {
        Location location = plotPlayer.getLocationFull();
        Location location2 = plotPlayer2.getLocation();
        double d = location.getX();
        double d2 = location.getY();
        double d3 = location.getZ();
        double d4 = location2.getX();
        double d5 = location2.getY();
        double d6 = location2.getZ();
        double d7 = 0.0;
        if (d < d4) {
            d7 = 1.0;
        } else if (d > d4) {
            d7 = -1.0;
        }
        double d8 = 0.0;
        if (d2 < d5) {
            d8 = 0.5;
        } else if (d2 > d5) {
            d8 = -0.5;
        }
        double d9 = 0.0;
        if (d3 < d6) {
            d9 = 1.0;
        } else if (d3 > d6) {
            d9 = -1.0;
        }
        return new Vector(d7, d8, d9);
    }

    public static void handleForcefield(Player player, PlotPlayer<?> plotPlayer, Plot plot) {
        if (((Boolean)plot.getFlag(ForcefieldFlag.class)).booleanValue()) {
            UUID uUID = plotPlayer.getUUID();
            if (plot.isAdded(uUID)) {
                Set<PlotPlayer<?>> set = ForceFieldListener.getNearbyPlayers(player, plot);
                for (PlotPlayer<?> plotPlayer2 : set) {
                    if (plotPlayer2.hasPermission(Permission.PERMISSION_ADMIN_ENTRY_FORCEFIELD)) continue;
                    ((BukkitPlayer)plotPlayer2).player.setVelocity(ForceFieldListener.calculateVelocity(plotPlayer, plotPlayer2));
                }
            } else {
                PlotPlayer<?> plotPlayer3 = ForceFieldListener.hasNearbyPermitted(player, plot);
                if (plotPlayer3 == null) {
                    return;
                }
                if (!plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_ENTRY_FORCEFIELD)) {
                    player.setVelocity(ForceFieldListener.calculateVelocity(plotPlayer3, plotPlayer));
                }
            }
        }
    }
}

