/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitEntityUtil;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotHandler;
import com.plotsquared.core.plot.flag.implementations.ProjectilesFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.PlotFlagUtil;
import com.plotsquared.google.Inject;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ProjectileEventListener
implements Listener {
    private final PlotAreaManager plotAreaManager;

    @Inject
    public ProjectileEventListener(@NonNull PlotAreaManager plotAreaManager) {
        this.plotAreaManager = plotAreaManager;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onLingeringPotionSplash(LingeringPotionSplashEvent lingeringPotionSplashEvent) {
        this.onProjectileHit((ProjectileHitEvent)lingeringPotionSplashEvent);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPotionSplash(PotionSplashEvent potionSplashEvent) {
        ThrownPotion thrownPotion = potionSplashEvent.getPotion();
        Location location = BukkitUtil.adapt(thrownPotion.getLocation());
        if (!this.plotAreaManager.hasPlotArea(location.getWorldName())) {
            return;
        }
        int n = 0;
        for (LivingEntity livingEntity : potionSplashEvent.getAffectedEntities()) {
            if (BukkitEntityUtil.entityDamage((Entity)thrownPotion, (Entity)livingEntity)) continue;
            potionSplashEvent.setIntensity(livingEntity, 0.0);
            ++n;
        }
        if (n > 0 && n == potionSplashEvent.getAffectedEntities().size()) {
            potionSplashEvent.setCancelled(true);
        } else {
            this.onProjectileHit((ProjectileHitEvent)potionSplashEvent);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onProjectileLaunch(ProjectileLaunchEvent projectileLaunchEvent) {
        Projectile projectile = projectileLaunchEvent.getEntity();
        ProjectileSource projectileSource = projectile.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Location location = BukkitUtil.adapt(projectile.getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt((Player)projectileSource);
        Plot plot = location.getOwnedPlot();
        if (plot == null) {
            if (!PlotFlagUtil.isAreaRoadFlagsAndFlagEquals(plotArea, ProjectilesFlag.class, true) && !bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_PROJECTILE_ROAD)) {
                bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_ADMIN_PROJECTILE_ROAD)));
                projectile.remove();
                projectileLaunchEvent.setCancelled(true);
            }
        } else if (!plot.hasOwner()) {
            if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_PROJECTILE_UNOWNED)) {
                bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_ADMIN_PROJECTILE_UNOWNED)));
                projectile.remove();
                projectileLaunchEvent.setCancelled(true);
            }
        } else if (!(plot.isAdded(((PlotPlayer)bukkitPlayer).getUUID()) || ((Boolean)plot.getFlag(ProjectilesFlag.class)).booleanValue() || bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_PROJECTILE_OTHER))) {
            bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_ADMIN_PROJECTILE_OTHER)));
            projectile.remove();
            projectileLaunchEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent projectileHitEvent) {
        Projectile projectile = projectileHitEvent.getEntity();
        Location location = BukkitUtil.adapt(projectile.getLocation());
        if (!this.plotAreaManager.hasPlotArea(location.getWorldName())) {
            return;
        }
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = plotArea.getPlot(location);
        ProjectileSource projectileSource = projectile.getShooter();
        if (projectileSource instanceof Player) {
            if (!((Player)projectileSource).isOnline()) {
                if (plot != null ? plot.isAdded(((Player)projectileSource).getUniqueId()) || (Boolean)plot.getFlag(ProjectilesFlag.class) != false : PlotFlagUtil.isAreaRoadFlagsAndFlagEquals(plotArea, ProjectilesFlag.class, true)) {
                    return;
                }
                projectile.remove();
                projectileHitEvent.setCancelled(true);
                return;
            }
            BukkitPlayer bukkitPlayer = BukkitUtil.adapt((Player)projectileSource);
            if (plot == null) {
                if (!PlotFlagUtil.isAreaRoadFlagsAndFlagEquals(plotArea, ProjectilesFlag.class, true) && !bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_PROJECTILE_UNOWNED)) {
                    projectile.remove();
                    projectileHitEvent.setCancelled(true);
                }
                return;
            }
            if (plot.isAdded(((PlotPlayer)bukkitPlayer).getUUID()) || bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_PROJECTILE_OTHER) || ((Boolean)plot.getFlag(ProjectilesFlag.class)).booleanValue()) {
                return;
            }
            projectile.remove();
            projectileHitEvent.setCancelled(true);
            return;
        }
        if (!(projectileSource instanceof Entity) && projectileSource != null) {
            if (plot == null) {
                projectile.remove();
                projectileHitEvent.setCancelled(true);
                return;
            }
            Location location2 = BukkitUtil.adapt(((BlockProjectileSource)projectileSource).getBlock().getLocation());
            if (!plotArea.contains(location2.getX(), location2.getZ())) {
                projectile.remove();
                projectileHitEvent.setCancelled(true);
                return;
            }
            Plot plot2 = plotArea.getOwnedPlotAbs(location2);
            if (plot2 == null || !PlotHandler.sameOwners(plot, plot2)) {
                projectile.remove();
                projectileHitEvent.setCancelled(true);
            }
        }
    }
}

