/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.managers;

import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.util.PlatformWorldManager;
import com.plotsquared.google.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public class BukkitWorldManager
implements PlatformWorldManager<World> {
    @Override
    public void initialize() {
    }

    @Override
    public @Nullable World handleWorldCreation(@NonNull String string, @Nullable String string2) {
        this.setGenerator(string, string2);
        WorldCreator worldCreator = new WorldCreator(string);
        worldCreator.environment(World.Environment.NORMAL);
        if (string2 != null) {
            worldCreator.generator(string2);
            worldCreator.type(WorldType.FLAT);
        }
        return Bukkit.createWorld((WorldCreator)worldCreator);
    }

    protected void setGenerator(@Nullable String string, @Nullable String string2) {
        if (string2 == null) {
            return;
        }
        File file = new File("bukkit.yml").getAbsoluteFile();
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration(file);
        yamlConfiguration.set(String.format("worlds.%s.generator", string), string2);
        try {
            yamlConfiguration.save(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "bukkit";
    }

    @Override
    public Collection<String> getWorlds() {
        List list = Bukkit.getWorlds();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (World world : list) {
            arrayList.add(world.getName());
        }
        return arrayList;
    }
}

