/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.permissions;

import com.plotsquared.bukkit.player.BukkitOfflinePlayer;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.core.permissions.ConsolePermissionProfile;
import com.plotsquared.core.permissions.PermissionHandler;
import com.plotsquared.core.permissions.PermissionProfile;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.OfflinePlotPlayer;
import com.plotsquared.core.player.PlotPlayer;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VaultPermissionHandler
implements PermissionHandler {
    private Permission permissions;

    @Override
    public void initialize() {
        if (Bukkit.getServer().getPluginManager().getPlugin("Vault") == null) {
            throw new IllegalStateException("Vault is not present on the server");
        }
        RegisteredServiceProvider registeredServiceProvider = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
        if (registeredServiceProvider != null) {
            this.permissions = (Permission)registeredServiceProvider.getProvider();
        }
    }

    @Override
    public @NonNull Optional<PermissionProfile> getPermissionProfile(@NonNull PlotPlayer<?> plotPlayer) {
        if (plotPlayer instanceof BukkitPlayer) {
            BukkitPlayer bukkitPlayer = (BukkitPlayer)plotPlayer;
            return Optional.of(new VaultPermissionProfile((OfflinePlayer)bukkitPlayer.getPlatformPlayer()));
        }
        if (plotPlayer instanceof ConsolePlayer) {
            return Optional.of(ConsolePermissionProfile.INSTANCE);
        }
        return Optional.empty();
    }

    @Override
    public @NonNull Optional<PermissionProfile> getPermissionProfile(@NonNull OfflinePlotPlayer offlinePlotPlayer) {
        if (offlinePlotPlayer instanceof BukkitOfflinePlayer) {
            return Optional.of(new VaultPermissionProfile(((BukkitOfflinePlayer)offlinePlotPlayer).player));
        }
        return Optional.empty();
    }

    @Override
    public @NonNull Set<PermissionHandler.PermissionHandlerCapability> getCapabilities() {
        return EnumSet.of(PermissionHandler.PermissionHandlerCapability.PER_WORLD_PERMISSIONS, PermissionHandler.PermissionHandlerCapability.ONLINE_PERMISSIONS, PermissionHandler.PermissionHandlerCapability.OFFLINE_PERMISSIONS);
    }

    private final class VaultPermissionProfile
    implements PermissionProfile {
        private final OfflinePlayer offlinePlayer;

        private VaultPermissionProfile(OfflinePlayer offlinePlayer) {
            this.offlinePlayer = offlinePlayer;
        }

        @Override
        public boolean hasPermission(@Nullable String string, @NonNull String string2) {
            if (VaultPermissionHandler.this.permissions == null) {
                return false;
            }
            if (string == null && this.offlinePlayer instanceof BukkitPlayer) {
                return VaultPermissionHandler.this.permissions.playerHas(((BukkitPlayer)this.offlinePlayer).getPlatformPlayer(), string2);
            }
            return VaultPermissionHandler.this.permissions.playerHas(string, this.offlinePlayer, string2);
        }

        @Override
        public boolean hasKeyedPermission(@Nullable String string, @NonNull String string2, @NonNull String string3) {
            if (VaultPermissionHandler.this.permissions == null) {
                return false;
            }
            if (string == null && this.offlinePlayer instanceof BukkitPlayer) {
                return VaultPermissionHandler.this.permissions.playerHas(((BukkitPlayer)this.offlinePlayer).getPlatformPlayer(), string2 + ".*") || VaultPermissionHandler.this.permissions.playerHas(((BukkitPlayer)this.offlinePlayer).getPlatformPlayer(), string2 + "." + string3);
            }
            return VaultPermissionHandler.this.permissions.playerHas(string, this.offlinePlayer, string2 + ".*") || VaultPermissionHandler.this.permissions.playerHas(string, this.offlinePlayer, string2 + "." + string3);
        }
    }
}

