/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.player;

import com.plotsquared.core.permissions.NullPermissionProfile;
import com.plotsquared.core.permissions.PermissionHandler;
import com.plotsquared.core.permissions.PermissionProfile;
import com.plotsquared.core.player.OfflinePlotPlayer;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BukkitOfflinePlayer
implements OfflinePlotPlayer {
    public final OfflinePlayer player;
    private final PermissionProfile permissionProfile;

    public BukkitOfflinePlayer(@NonNull OfflinePlayer offlinePlayer, @NonNull PermissionHandler permissionHandler) {
        this.player = offlinePlayer;
        this.permissionProfile = permissionHandler.getPermissionProfile(this).orElse(NullPermissionProfile.INSTANCE);
    }

    @Override
    public @NonNull UUID getUUID() {
        return this.player.getUniqueId();
    }

    @Override
    public @NonNegative long getLastPlayed() {
        return this.player.getLastSeen();
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public boolean hasPermission(@Nullable String string, @NonNull String string2) {
        return this.permissionProfile.hasPermission(string, string2);
    }

    @Override
    public boolean hasKeyedPermission(@Nullable String string, @NonNull String string2, @NonNull String string3) {
        return this.permissionProfile.hasPermission(string, string2 + "." + string3) || this.permissionProfile.hasPermission(string, string2 + ".*");
    }

    @Override
    public boolean hasPermission(@NonNull String string, boolean bl) {
        return this.hasPermission(string);
    }
}

