/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.queue;

import com.plotsquared.bukkit.BukkitPlatform;
import com.plotsquared.bukkit.paperlib.PaperLib;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.queue.ChunkCoordinator;
import com.plotsquared.core.queue.subscriber.ProgressSubscriber;
import com.plotsquared.core.util.task.PlotSquaredTask;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.plotsquared.google.Inject;
import com.plotsquared.google.assistedinject.Assisted;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.world.World;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class BukkitChunkCoordinator
extends ChunkCoordinator {
    private final List<ProgressSubscriber> progressSubscribers = new LinkedList<ProgressSubscriber>();
    private final Queue<BlockVector2> requestedChunks;
    private final Queue<Chunk> availableChunks;
    private final long maxIterationTime;
    private final Plugin plugin;
    private final Consumer<BlockVector2> chunkConsumer;
    private final org.bukkit.World bukkitWorld;
    private final Runnable whenDone;
    private final Consumer<Throwable> throwableConsumer;
    private final boolean unloadAfter;
    private final int totalSize;
    private final AtomicInteger expectedSize;
    private final AtomicInteger loadingChunks = new AtomicInteger();
    private final boolean forceSync;
    private int batchSize;
    private PlotSquaredTask task;
    private volatile boolean shouldCancel;
    private boolean finished;

    @Inject
    private BukkitChunkCoordinator(@Assisted long l, @Assisted int n, @Assisted @NonNull Consumer<BlockVector2> consumer, @Assisted @NonNull World world, @Assisted @NonNull Collection<BlockVector2> collection, @Assisted @NonNull Runnable runnable, @Assisted @NonNull Consumer<Throwable> consumer2, @Assisted(value="unloadAfter") boolean bl, @Assisted @NonNull Collection<ProgressSubscriber> collection2, @Assisted(value="forceSync") boolean bl2) {
        this.requestedChunks = new LinkedBlockingQueue<BlockVector2>(collection);
        this.availableChunks = new LinkedBlockingQueue<Chunk>();
        this.totalSize = collection.size();
        this.expectedSize = new AtomicInteger(this.totalSize);
        this.batchSize = n;
        this.chunkConsumer = consumer;
        this.maxIterationTime = l;
        this.whenDone = runnable;
        this.throwableConsumer = consumer2;
        this.unloadAfter = bl;
        this.plugin = JavaPlugin.getPlugin(BukkitPlatform.class);
        this.bukkitWorld = Bukkit.getWorld((String)world.getName());
        this.progressSubscribers.addAll(collection2);
        this.forceSync = bl2;
    }

    @Override
    public void start() {
        if (!this.forceSync) {
            this.requestBatch();
            TaskManager.runTaskLater(() -> {
                this.task = TaskManager.runTaskRepeat(this, TaskTime.ticks(1L));
            }, TaskTime.ticks(1L));
        } else {
            try {
                while (!this.shouldCancel && !this.requestedChunks.isEmpty()) {
                    this.chunkConsumer.accept(this.requestedChunks.poll());
                }
            }
            catch (Throwable throwable) {
                this.throwableConsumer.accept(throwable);
            }
            finally {
                this.finish();
            }
        }
    }

    @Override
    public void cancel() {
        this.shouldCancel = true;
    }

    private void finish() {
        try {
            this.whenDone.run();
        }
        catch (Throwable throwable) {
            this.throwableConsumer.accept(throwable);
        }
        finally {
            for (ProgressSubscriber progressSubscriber : this.progressSubscribers) {
                progressSubscriber.notifyEnd();
            }
            if (this.task != null) {
                this.task.cancel();
            }
            this.finished = true;
        }
    }

    @Override
    public void run() {
        int n;
        if (this.shouldCancel) {
            if (this.unloadAfter) {
                Chunk chunk;
                while ((chunk = this.availableChunks.poll()) != null) {
                    this.freeChunk(chunk);
                }
            }
            this.finish();
            return;
        }
        Chunk chunk = this.availableChunks.poll();
        if (chunk == null) {
            if (this.availableChunks.isEmpty()) {
                if (this.requestedChunks.isEmpty() && this.loadingChunks.get() == 0) {
                    this.finish();
                } else {
                    this.requestBatch();
                }
            }
            return;
        }
        long[] lArray = new long[2];
        int n2 = 0;
        do {
            long l = System.currentTimeMillis();
            try {
                this.chunkConsumer.accept(BlockVector2.at((int)chunk.getX(), (int)chunk.getZ()));
            }
            catch (Throwable throwable) {
                this.throwableConsumer.accept(throwable);
            }
            if (this.unloadAfter) {
                this.freeChunk(chunk);
            }
            ++n2;
            long l2 = System.currentTimeMillis();
            lArray[0] = lArray[1];
            lArray[1] = l2 - l;
        } while (lArray[0] + lArray[1] < this.maxIterationTime * 2L && (chunk = this.availableChunks.poll()) != null);
        if (n2 < this.batchSize) {
            this.batchSize = n2;
        }
        if ((n = this.expectedSize.addAndGet(-n2)) <= 0) {
            this.finish();
        } else if (this.availableChunks.size() < n2) {
            double d = ((double)this.totalSize - (double)n) / (double)this.totalSize;
            for (ProgressSubscriber progressSubscriber : this.progressSubscribers) {
                progressSubscriber.notifyProgress(this, d);
            }
            this.requestBatch();
        }
    }

    private void requestBatch() {
        BlockVector2 blockVector2;
        for (int i = 0; i < this.batchSize && (blockVector2 = this.requestedChunks.poll()) != null; ++i) {
            this.loadingChunks.incrementAndGet();
            PaperLib.getChunkAtAsync(this.bukkitWorld, blockVector2.getX(), blockVector2.getZ(), true, true).whenComplete((chunk, throwable) -> {
                this.loadingChunks.decrementAndGet();
                if (throwable != null) {
                    throwable.printStackTrace();
                    this.expectedSize.decrementAndGet();
                } else if (PlotSquared.get().isMainThread(Thread.currentThread())) {
                    this.processChunk((Chunk)chunk);
                } else {
                    TaskManager.runTask(() -> this.processChunk((Chunk)chunk));
                }
            });
        }
    }

    private void processChunk(@NonNull Chunk chunk) {
        if (this.finished) {
            return;
        }
        chunk.addPluginChunkTicket(this.plugin);
        this.availableChunks.add(chunk);
    }

    private void freeChunk(@NonNull Chunk chunk) {
        if (!chunk.isLoaded()) {
            throw new IllegalArgumentException(String.format("Chunk %d;%d is is not loaded", chunk.getX(), chunk.getZ()));
        }
        chunk.removePluginChunkTicket(this.plugin);
    }

    @Override
    public int getRemainingChunks() {
        return this.expectedSize.get();
    }

    @Override
    public int getTotalChunks() {
        return this.totalSize;
    }

    public void subscribeToProgress(@NonNull ProgressSubscriber progressSubscriber) {
        this.progressSubscribers.add(progressSubscriber);
    }
}

