/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.queue;

import com.google.common.base.Preconditions;
import com.plotsquared.bukkit.util.BukkitBlockUtil;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.annotations.informative.DoNotUse;
import com.plotsquared.core.location.ChunkWrapper;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import com.plotsquared.core.util.ChunkUtil;
import com.plotsquared.core.util.PatternUtil;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.block.Biome;
import org.bukkit.generator.ChunkGenerator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@DoNotUse
public class GenChunk
extends ZeroedDelegateScopedQueueCoordinator {
    public final Biome[] biomes = Biome.values();
    public BlockState[][] result;
    public ChunkGenerator.BiomeGrid biomeGrid;
    public Chunk chunk;
    public String world;
    public int chunkX;
    public int chunkZ;
    private ChunkGenerator.ChunkData chunkData = null;

    public GenChunk(int n, int n2) {
        super(null, Location.at("", 0, n, 0), Location.at("", 15, n2, 15));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ChunkGenerator.ChunkData getChunkData() {
        return this.chunkData;
    }

    public void setChunkData(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ChunkGenerator.ChunkData chunkData) {
        this.chunkData = chunkData;
    }

    public @NonNull Chunk getChunk() {
        org.bukkit.World world;
        if (this.chunk == null && (world = BukkitUtil.getWorld(this.world)) != null) {
            this.chunk = world.getChunkAt(this.chunkX, this.chunkZ);
        }
        return this.chunk;
    }

    public void setChunk(@NonNull Chunk chunk) {
        this.chunk = chunk;
    }

    public void setChunk(@NonNull ChunkWrapper chunkWrapper) {
        this.chunk = null;
        this.world = chunkWrapper.world();
        this.chunkX = chunkWrapper.x();
        this.chunkZ = chunkWrapper.z();
    }

    @Override
    public void fillBiome(@NonNull BiomeType biomeType) {
        if (this.biomeGrid == null) {
            return;
        }
        Biome biome = BukkitAdapter.adapt((BiomeType)biomeType);
        for (int i = this.getMin().getY(); i <= this.getMax().getY(); ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    this.biomeGrid.setBiome(j, i, k, biome);
                }
            }
        }
    }

    @Override
    public void setCuboid(@NonNull Location location, @NonNull Location location2, @NonNull BlockState blockState) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.result != null && location.getX() == 0 && location.getZ() == 0 && location2.getX() == 15 && location2.getZ() == 15) {
            for (n4 = location.getY(); n4 <= location2.getY(); ++n4) {
                n3 = this.getLayerIndex(n4);
                Object[] objectArray = this.result[n3];
                if (objectArray == null) {
                    objectArray = new BlockState[4096];
                    this.result[n3] = objectArray;
                }
                n2 = n4 << 8;
                n = n2 + 256;
                Arrays.fill(objectArray, n2, n, blockState);
            }
        }
        n4 = Math.min(location.getX(), location2.getX());
        n3 = Math.min(location.getY(), location2.getY());
        int n5 = Math.min(location.getZ(), location2.getZ());
        n2 = Math.max(location.getX(), location2.getX());
        n = Math.max(location.getY(), location2.getY());
        int n6 = Math.max(location.getZ(), location2.getZ());
        this.chunkData.setRegion(n4, n3, n5, n2 + 1, n + 1, n6 + 1, BukkitAdapter.adapt((BlockStateHolder)blockState));
    }

    @Override
    public boolean setBiome(int n, int n2, @NonNull BiomeType biomeType) {
        return this.setBiome(n, n2, BukkitAdapter.adapt((BiomeType)biomeType));
    }

    public boolean setBiome(int n, int n2, @NonNull Biome biome) {
        if (this.biomeGrid != null) {
            for (int i = this.getMin().getY(); i <= this.getMax().getY(); ++i) {
                this.setBiome(n, i, n2, biome);
            }
            return true;
        }
        return false;
    }

    public boolean setBiome(int n, int n2, int n3, @NonNull Biome biome) {
        if (this.biomeGrid != null) {
            this.biomeGrid.setBiome(n, n2, n3, biome);
            return true;
        }
        return false;
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull Pattern pattern) {
        BaseBlock baseBlock = PatternUtil.apply((Pattern)Preconditions.checkNotNull((Object)pattern, (Object)"Pattern may not be null"), n + (this.chunkX << 4), n2, n3 + (this.chunkZ << 4));
        return this.setBlock(n, n2, n3, baseBlock);
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull BlockState blockState) {
        if (this.result == null) {
            this.chunkData.setBlock(n, n2, n3, BukkitAdapter.adapt((BlockStateHolder)blockState));
            return true;
        }
        this.chunkData.setBlock(n, n2, n3, BukkitAdapter.adapt((BlockStateHolder)blockState));
        this.storeCache(n, n2, n3, blockState);
        return true;
    }

    private void storeCache(int n, int n2, int n3, @NonNull BlockState blockState) {
        int n4 = this.getLayerIndex(n2);
        BlockState[] blockStateArray = this.result[n4];
        if (blockStateArray == null) {
            blockStateArray = new BlockState[4096];
            this.result[n4] = blockStateArray;
        }
        int n5 = ChunkUtil.getJ(n, n2, n3);
        blockStateArray[n5] = blockState;
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull BaseBlock baseBlock) {
        if (this.result == null) {
            this.chunkData.setBlock(n, n2, n3, BukkitAdapter.adapt((BlockStateHolder)baseBlock));
            return true;
        }
        this.chunkData.setBlock(n, n2, n3, BukkitAdapter.adapt((BlockStateHolder)baseBlock));
        this.storeCache(n, n2, n3, baseBlock.toImmutableState());
        return true;
    }

    @Override
    public @Nullable BlockState getBlock(int n, int n2, int n3) {
        int n4 = this.getLayerIndex(n2);
        if (this.result == null) {
            return BukkitBlockUtil.get(this.chunkData.getType(n, n2, n3));
        }
        BlockState[] blockStateArray = this.result[n4];
        if (blockStateArray == null) {
            return BlockTypes.AIR.getDefaultState();
        }
        int n5 = ChunkUtil.getJ(n, n2, n3);
        return blockStateArray[n5];
    }

    public int getX() {
        return this.chunk == null ? this.chunkX : this.chunk.getX();
    }

    public int getZ() {
        return this.chunk == null ? this.chunkZ : this.chunk.getZ();
    }

    @Override
    public @NonNull World getWorld() {
        return this.chunk == null ? BukkitAdapter.adapt((org.bukkit.World)Bukkit.getWorld((String)this.world)) : BukkitAdapter.adapt((org.bukkit.World)this.chunk.getWorld());
    }

    @Override
    public @NonNull Location getMax() {
        return Location.at(this.getWorld().getName(), 15 + (this.getX() << 4), super.getMax().getY(), 15 + (this.getZ() << 4));
    }

    @Override
    public @NonNull Location getMin() {
        return Location.at(this.getWorld().getName(), this.getX() << 4, super.getMin().getY(), this.getZ() << 4);
    }

    public @NonNull GenChunk clone() {
        GenChunk genChunk = new GenChunk(this.getMin().getY(), this.getMax().getY());
        if (this.result != null) {
            for (int i = 0; i < this.result.length; ++i) {
                BlockState[] blockStateArray = this.result[i];
                if (blockStateArray == null) continue;
                genChunk.result[i] = new BlockState[blockStateArray.length];
                System.arraycopy(blockStateArray, 0, genChunk.result[i], 0, blockStateArray.length);
            }
        }
        genChunk.chunkData = this.chunkData;
        return genChunk;
    }

    private int getLayerIndex(int n) {
        return n - this.getMin().getY() >> 4;
    }
}

