/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util;

import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotInventory;
import com.plotsquared.core.plot.PlotItemStack;
import com.plotsquared.core.util.InventoryUtil;
import com.plotsquared.google.Singleton;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.item.ItemType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public class BukkitInventoryUtil
extends InventoryUtil {
    private static @Nullable ItemStack getItem(PlotItemStack plotItemStack) {
        Object object;
        if (plotItemStack == null) {
            return null;
        }
        Material material = BukkitAdapter.adapt((ItemType)plotItemStack.getType());
        if (material == null) {
            return null;
        }
        ItemStack itemStack = new ItemStack(material, plotItemStack.getAmount());
        ItemMeta itemMeta = null;
        if (plotItemStack.getName() != null) {
            itemMeta = itemStack.getItemMeta();
            object = BukkitUtil.MINI_MESSAGE.deserialize(plotItemStack.getName());
            itemMeta.setDisplayName(BukkitUtil.LEGACY_COMPONENT_SERIALIZER.serialize((Component)object));
        }
        if (plotItemStack.getLore() != null) {
            if (itemMeta == null) {
                itemMeta = itemStack.getItemMeta();
            }
            object = new ArrayList();
            for (String string : plotItemStack.getLore()) {
                object.add((String)BukkitUtil.LEGACY_COMPONENT_SERIALIZER.serialize((Component)BukkitUtil.MINI_MESSAGE.deserialize(string)));
            }
            itemMeta.setLore(object);
        }
        if (itemMeta != null) {
            itemStack.setItemMeta(itemMeta);
        }
        return itemStack;
    }

    @Override
    public void open(PlotInventory plotInventory) {
        BukkitPlayer bukkitPlayer = (BukkitPlayer)plotInventory.getPlayer();
        Inventory inventory = Bukkit.createInventory(null, (int)(plotInventory.getLines() * 9), (String)ChatColor.translateAlternateColorCodes((char)'&', (String)plotInventory.getTitle()));
        PlotItemStack[] plotItemStackArray = plotInventory.getItems();
        for (int i = 0; i < plotInventory.getLines() * 9; ++i) {
            PlotItemStack plotItemStack = plotItemStackArray[i];
            if (plotItemStack == null) continue;
            inventory.setItem(i, BukkitInventoryUtil.getItem(plotItemStack));
        }
        bukkitPlayer.player.openInventory(inventory);
    }

    @Override
    public void close(PlotInventory plotInventory) {
        if (!plotInventory.isOpen()) {
            return;
        }
        BukkitPlayer bukkitPlayer = (BukkitPlayer)plotInventory.getPlayer();
        bukkitPlayer.player.closeInventory();
    }

    @Override
    public boolean setItemChecked(PlotInventory plotInventory, int n, PlotItemStack plotItemStack) {
        BukkitPlayer bukkitPlayer = (BukkitPlayer)plotInventory.getPlayer();
        InventoryView inventoryView = bukkitPlayer.player.getOpenInventory();
        ItemStack itemStack = BukkitInventoryUtil.getItem(plotItemStack);
        if (itemStack == null) {
            return false;
        }
        if (!plotInventory.isOpen()) {
            return true;
        }
        inventoryView.setItem(n, itemStack);
        bukkitPlayer.player.updateInventory();
        return true;
    }

    public PlotItemStack getItem(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        Material material = itemStack.getType();
        ItemMeta itemMeta = itemStack.getItemMeta();
        int n = itemStack.getAmount();
        String string = null;
        String[] stringArray = null;
        if (itemStack.hasItemMeta()) {
            assert (itemMeta != null);
            if (itemMeta.hasDisplayName()) {
                string = itemMeta.getDisplayName();
            }
            if (itemMeta.hasLore()) {
                List list = itemMeta.getLore();
                assert (list != null);
                stringArray = list.toArray(new String[0]);
            }
        }
        return new PlotItemStack(material.name(), n, string, stringArray);
    }

    @Override
    public PlotItemStack[] getItems(PlotPlayer<?> plotPlayer) {
        BukkitPlayer bukkitPlayer = (BukkitPlayer)plotPlayer;
        PlayerInventory playerInventory = bukkitPlayer.player.getInventory();
        return (PlotItemStack[])IntStream.range(0, 36).mapToObj(n -> this.getItem(playerInventory.getItem(n))).toArray(PlotItemStack[]::new);
    }

    @Override
    public boolean isOpen(PlotInventory plotInventory) {
        if (!plotInventory.isOpen()) {
            return false;
        }
        BukkitPlayer bukkitPlayer = (BukkitPlayer)plotInventory.getPlayer();
        InventoryView inventoryView = bukkitPlayer.player.getOpenInventory();
        if (plotInventory.isOpen() && inventoryView.getType() == InventoryType.CRAFTING) {
            inventoryView.getTitle();
        }
        return false;
    }
}

