/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util;

import com.plotsquared.bukkit.generator.BukkitPlotGenerator;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.ConfigurationNode;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.generator.GeneratorWrapper;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.inject.annotations.WorldFile;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.setup.PlotAreaBuilder;
import com.plotsquared.core.util.SetupUtils;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.google.Inject;
import com.plotsquared.google.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;

@Singleton
public class BukkitSetupUtils
extends SetupUtils {
    private final PlotAreaManager plotAreaManager;
    private final YamlConfiguration worldConfiguration;
    private final File worldFile;

    @Inject
    public BukkitSetupUtils(@NonNull PlotAreaManager plotAreaManager, @WorldConfig @NonNull YamlConfiguration yamlConfiguration, @WorldFile @NonNull File file) {
        this.plotAreaManager = plotAreaManager;
        this.worldConfiguration = yamlConfiguration;
        this.worldFile = file;
    }

    @Override
    public void updateGenerators(boolean bl) {
        if (this.loaded && !SetupUtils.generators.isEmpty() && !bl) {
            return;
        }
        String string = "CheckingPlotSquaredGenerator";
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            try {
                ChunkGenerator chunkGenerator;
                if (!plugin.isEnabled() || (chunkGenerator = plugin.getDefaultWorldGenerator(string, "")) == null) continue;
                PlotSquared.get().removePlotAreas(string);
                String string2 = plugin.getDescription().getName();
                GeneratorWrapper generatorWrapper = chunkGenerator instanceof GeneratorWrapper ? (GeneratorWrapper)chunkGenerator : new BukkitPlotGenerator(string, chunkGenerator, this.plotAreaManager);
                SetupUtils.generators.put(string2, generatorWrapper);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.loaded = true;
    }

    @Override
    public void unload(String string, boolean bl) {
        TaskManager.runTask(() -> {
            World world = Bukkit.getWorld((String)string);
            if (world == null) {
                return;
            }
            Location location = ((World)Bukkit.getWorlds().get(0)).getSpawnLocation();
            for (Player player : world.getPlayers()) {
                player.teleport(location);
            }
            if (bl) {
                for (Chunk chunk : world.getLoadedChunks()) {
                    chunk.unload(true);
                }
            } else {
                for (Chunk chunk : world.getLoadedChunks()) {
                    chunk.unload(false);
                }
            }
            Bukkit.unloadWorld((World)world, (boolean)false);
        });
    }

    @Override
    public String setupWorld(PlotAreaBuilder plotAreaBuilder) {
        this.updateGenerators(false);
        ConfigurationNode[] configurationNodeArray = plotAreaBuilder.settingsNodesWrapper() == null ? new ConfigurationNode[]{} : plotAreaBuilder.settingsNodesWrapper().settingsNodes();
        String string = plotAreaBuilder.worldName();
        PlotAreaType plotAreaType = plotAreaBuilder.plotAreaType();
        String string2 = "worlds." + plotAreaBuilder.worldName();
        switch (plotAreaType) {
            case PARTIAL: {
                Object object;
                if (plotAreaBuilder.areaName() != null) {
                    String string3;
                    String string4;
                    if (!this.worldConfiguration.contains(string2)) {
                        this.worldConfiguration.createSection(string2);
                    }
                    if (!(object = this.worldConfiguration.getConfigurationSection(string2)).contains(string4 = "areas." + (string3 = plotAreaBuilder.areaName() + "-" + plotAreaBuilder.minimumId() + "-" + plotAreaBuilder.maximumId()))) {
                        object.createSection(string4);
                    }
                    ConfigurationSection configurationSection = object.getConfigurationSection(string4);
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    for (ConfigurationNode configurationNode : configurationNodeArray) {
                        hashMap.put(configurationNode.getConstant(), configurationNode.getValue());
                    }
                    hashMap.put("generator.type", plotAreaBuilder.plotAreaType().toString());
                    hashMap.put("generator.terrain", plotAreaBuilder.terrainType().toString());
                    hashMap.put("generator.plugin", plotAreaBuilder.plotManager());
                    if (plotAreaBuilder.generatorName() != null && !plotAreaBuilder.generatorName().equals(plotAreaBuilder.plotManager())) {
                        hashMap.put("generator.init", plotAreaBuilder.generatorName());
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        ConfigurationNode configurationNode;
                        String string5 = (String)entry.getKey();
                        configurationNode = entry.getValue();
                        if (object.contains(string5)) {
                            Object object2 = object.get(string5);
                            if (Objects.equals(configurationNode, object2)) continue;
                            configurationSection.set(string5, configurationNode);
                            continue;
                        }
                        object.set(string5, configurationNode);
                    }
                }
                if ((object = SetupUtils.generators.get(plotAreaBuilder.generatorName())) == null || !object.isFull()) break;
                plotAreaBuilder.generatorName(null);
                break;
            }
            case AUGMENTED: {
                Object object;
                if (!plotAreaBuilder.plotManager().endsWith(":single")) {
                    if (!this.worldConfiguration.contains(string2)) {
                        this.worldConfiguration.createSection(string2);
                    }
                    if (configurationNodeArray.length != 0) {
                        object = this.worldConfiguration.getConfigurationSection(string2);
                        for (ConfigurationNode configurationNode : configurationNodeArray) {
                            object.set(configurationNode.getConstant(), configurationNode.getValue());
                        }
                    }
                    this.worldConfiguration.set("worlds." + string + ".generator.type", plotAreaBuilder.plotAreaType().toString());
                    this.worldConfiguration.set("worlds." + string + ".generator.terrain", plotAreaBuilder.terrainType().toString());
                    this.worldConfiguration.set("worlds." + string + ".generator.plugin", plotAreaBuilder.plotManager());
                    if (plotAreaBuilder.generatorName() != null && !plotAreaBuilder.generatorName().equals(plotAreaBuilder.plotManager())) {
                        this.worldConfiguration.set("worlds." + string + ".generator.init", plotAreaBuilder.generatorName());
                    }
                }
                if ((object = SetupUtils.generators.get(plotAreaBuilder.generatorName())) == null || !object.isFull()) break;
                plotAreaBuilder.generatorName(null);
                break;
            }
            case NORMAL: {
                if (configurationNodeArray.length == 0) break;
                if (!this.worldConfiguration.contains(string2)) {
                    this.worldConfiguration.createSection(string2);
                }
                Object object = this.worldConfiguration.getConfigurationSection(string2);
                for (ConfigurationNode configurationNode : configurationNodeArray) {
                    object.set(configurationNode.getConstant(), configurationNode.getValue());
                }
                break;
            }
        }
        try {
            this.worldConfiguration.save(this.worldFile);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Objects.requireNonNull(PlotSquared.platform()).worldManager().handleWorldCreation(plotAreaBuilder.worldName(), plotAreaBuilder.generatorName());
        if (Bukkit.getWorld((String)string) != null) {
            return string;
        }
        return plotAreaBuilder.worldName();
    }

    @Override
    public String getGenerator(PlotArea plotArea) {
        World world;
        if (SetupUtils.generators.isEmpty()) {
            this.updateGenerators(false);
        }
        if ((world = Bukkit.getWorld((String)plotArea.getWorldName())) == null) {
            return null;
        }
        ChunkGenerator chunkGenerator = world.getGenerator();
        if (!(chunkGenerator instanceof BukkitPlotGenerator)) {
            return null;
        }
        for (Map.Entry<String, GeneratorWrapper<?>> entry : SetupUtils.generators.entrySet()) {
            GeneratorWrapper<?> generatorWrapper = entry.getValue();
            if (!generatorWrapper.equals(chunkGenerator)) continue;
            return entry.getKey();
        }
        return null;
    }
}

