/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.PlotVersion;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.google.Inject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class UpdateUtility
implements Listener {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + UpdateUtility.class.getSimpleName()));
    public static PlotVersion internalVersion;
    public static String spigotVersion;
    public static boolean hasUpdate;
    private static BukkitTask task;
    public final JavaPlugin javaPlugin;
    private boolean notify = true;

    @Inject
    public UpdateUtility(JavaPlugin javaPlugin) {
        this.javaPlugin = javaPlugin;
        internalVersion = PlotSquared.get().getVersion();
    }

    public void updateChecker() {
        task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.javaPlugin, () -> {
            try {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)URI.create("https://api.spigotmc.org/simple/0.2/index.php?action=getResource&id=77506").toURL().openConnection();
                httpsURLConnection.setRequestMethod("GET");
                JsonObject jsonObject = new JsonParser().parse(new JsonReader((Reader)new InputStreamReader(httpsURLConnection.getInputStream()))).getAsJsonObject();
                spigotVersion = jsonObject.get("current_version").getAsString();
            }
            catch (IOException iOException) {
                LOGGER.error("Unable to check for updates. Error: {}", (Object)iOException.getMessage());
                return;
            }
            if (internalVersion.isLaterVersion(spigotVersion)) {
                LOGGER.info("There appears to be a PlotSquared update available!");
                LOGGER.info("You are running version {}, the latest version is {}", (Object)internalVersion.versionString(), (Object)spigotVersion);
                LOGGER.info("https://www.spigotmc.org/resources/77506/updates");
                hasUpdate = true;
                if (Settings.UpdateChecker.NOTIFY_ONCE) {
                    this.cancelTask();
                }
            } else if (this.notify) {
                this.notify = false;
                LOGGER.info("Congratulations! You are running the latest PlotSquared version");
            }
        }, 0L, (long)Settings.UpdateChecker.POLL_RATE * 60L * 20L);
    }

    private void cancelTask() {
        Bukkit.getScheduler().runTaskLater((Plugin)this.javaPlugin, () -> task.cancel(), 20L);
    }
}

