/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core;

import com.plotsquared.core.PlotPlatform;
import com.plotsquared.core.PlotVersion;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.ConfigurationUtil;
import com.plotsquared.core.configuration.MemorySection;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.Storage;
import com.plotsquared.core.configuration.caption.CaptionMap;
import com.plotsquared.core.configuration.caption.DummyCaptionMap;
import com.plotsquared.core.configuration.caption.load.CaptionLoader;
import com.plotsquared.core.configuration.caption.load.DefaultCaptionProvider;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.configuration.serialization.ConfigurationSerialization;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.database.Database;
import com.plotsquared.core.database.MySQL;
import com.plotsquared.core.database.SQLManager;
import com.plotsquared.core.database.SQLite;
import com.plotsquared.core.generator.GeneratorWrapper;
import com.plotsquared.core.generator.HybridPlotWorld;
import com.plotsquared.core.generator.HybridUtils;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.inject.factory.HybridPlotWorldFactory;
import com.plotsquared.core.listener.PlotListener;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.plot.BlockBucket;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotCluster;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.expiration.ExpireManager;
import com.plotsquared.core.plot.expiration.ExpiryTask;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.plot.world.SinglePlotAreaManager;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.FileUtils;
import com.plotsquared.core.util.LegacyConverter;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.ReflectionUtils;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.uuid.UUIDPipeline;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.event.platform.PlatformReadyEvent;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.util.eventbus.EventHandler;
import com.sk89q.worldedit.util.eventbus.Subscribe;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PlotSquared {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + PlotSquared.class.getSimpleName()));
    private static @MonotonicNonNull PlotSquared instance;
    private final PlotPlatform<?> platform;
    private final Thread thread;
    private final UUIDPipeline impromptuUUIDPipeline = new UUIDPipeline(Executors.newCachedThreadPool());
    private final UUIDPipeline backgroundUUIDPipeline = new UUIDPipeline(Executors.newSingleThreadExecutor());
    private final Map<String, CaptionMap> captionMaps = new HashMap<String, CaptionMap>();
    public HashMap<String, HashMap<PlotId, Plot>> plots_tmp;
    private CaptionLoader captionLoader;
    private WorldEdit worldedit;
    private File configFile;
    private File worldsFile;
    private YamlConfiguration worldConfiguration;
    private HashMap<String, Set<PlotCluster>> clustersTmp;
    private YamlConfiguration config;
    private PlotVersion version;
    private File jarFile = null;
    private File storageFile;
    private EventDispatcher eventDispatcher;
    private PlotListener plotListener;
    private boolean weInitialised;

    public PlotSquared(@NonNull PlotPlatform<?> plotPlatform, @NonNull String string) {
        if (instance != null) {
            throw new IllegalStateException("Cannot re-initialize the PlotSquared singleton");
        }
        instance = this;
        this.thread = Thread.currentThread();
        this.platform = plotPlatform;
        Settings.PLATFORM = string;
        PlayerMetaDataKeys.load();
        ConfigurationSerialization.registerClass(BlockBucket.class, "BlockBucket");
        if (!this.setupConfigs()) {
            return;
        }
        this.captionLoader = CaptionLoader.of(Locale.ENGLISH, CaptionLoader.patternExtractor(Pattern.compile("messages_(.*)\\.json")), DefaultCaptionProvider.forClassLoaderFormatString(this.getClass().getClassLoader(), "lang/messages_%s.json"), "plotsquared");
        try {
            this.loadCaptionMap();
        }
        catch (Exception exception) {
            LOGGER.error("Failed to load caption map", (Throwable)exception);
            LOGGER.error("Shutting down server to prevent further issues");
            this.platform.shutdownServer();
            throw new RuntimeException("Abort loading PlotSquared");
        }
        GlobalFlagContainer.setup();
        try {
            block8: {
                new ReflectionUtils(this.platform.serverNativePackage());
                try {
                    URL uRL = PlotSquared.class.getProtectionDomain().getCodeSource().getLocation();
                    this.jarFile = new File(URI.create(uRL.toURI().toString().split("\\!")[0].replaceAll("jar:file", "file")).getPath());
                }
                catch (SecurityException | URISyntaxException exception) {
                    exception.printStackTrace();
                    this.jarFile = new File(this.platform.getDirectory().getParentFile(), "PlotSquared.jar");
                    if (this.jarFile.exists()) break block8;
                    this.jarFile = new File(this.platform.getDirectory().getParentFile(), "PlotSquared-" + string + ".jar");
                }
            }
            this.worldedit = WorldEdit.getInstance();
            WorldEdit.getInstance().getEventBus().register((Object)new WEPlatformReadyListener());
            this.eventDispatcher = new EventDispatcher(this.worldedit);
            this.plotListener = new PlotListener(this.eventDispatcher);
            this.copyFile("town.template", Settings.Paths.TEMPLATES);
            this.copyFile("bridge.template", Settings.Paths.TEMPLATES);
            this.copyFile("skyblock.template", Settings.Paths.TEMPLATES);
            this.showDebug();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static @NonNull PlotSquared get() {
        return instance;
    }

    public static @NonNull PlotPlatform<?> platform() {
        if (instance != null && PlotSquared.instance.platform != null) {
            return PlotSquared.instance.platform;
        }
        throw new IllegalStateException("Plot platform implementation is missing");
    }

    public void loadCaptionMap() {
        CaptionMap captionMap;
        this.platform.copyCaptionMaps();
        if (Settings.Enabled_Components.PER_USER_LOCALE) {
            captionMap = this.captionLoader.loadAll(this.platform.getDirectory().toPath().resolve("lang"));
        } else {
            String string = "messages_" + Settings.Enabled_Components.DEFAULT_LOCALE + ".json";
            captionMap = this.captionLoader.loadOrCreateSingle(this.platform.getDirectory().toPath().resolve("lang").resolve(string));
        }
        this.captionMaps.put("plotsquared", captionMap);
        LOGGER.info("Loaded caption map for namespace 'plotsquared': {}", (Object)this.captionMaps.get("plotsquared").getClass().getCanonicalName());
    }

    public @NonNull PlotAreaManager getPlotAreaManager() {
        return this.platform.plotAreaManager();
    }

    public void startExpiryTasks() {
        if (Settings.Enabled_Components.PLOT_EXPIRY) {
            ExpireManager expireManager = PlotSquared.platform().expireManager();
            expireManager.runAutomatedTask();
            for (Settings.Auto_Clear auto_Clear : Settings.AUTO_CLEAR.getInstances()) {
                ExpiryTask expiryTask = new ExpiryTask(auto_Clear, this.getPlotAreaManager());
                expireManager.addTask(expiryTask);
            }
        }
    }

    public boolean isMainThread(@NonNull Thread thread) {
        return this.thread == thread;
    }

    public boolean checkVersion(int[] nArray, int ... nArray2) {
        return nArray[0] > nArray2[0] || nArray[0] == nArray2[0] && nArray[1] > nArray2[1] || nArray[0] == nArray2[0] && nArray[1] == nArray2[1] && nArray[2] >= nArray2[2];
    }

    public @NonNull PlotVersion getVersion() {
        return this.version;
    }

    public @NonNull String getPlatform() {
        return Settings.PLATFORM;
    }

    public void addPlotArea(@NonNull PlotArea plotArea) {
        Object object;
        Object object2;
        Object object3;
        HashMap<PlotId, Plot> hashMap;
        if (this.plots_tmp == null || (hashMap = this.plots_tmp.remove(plotArea.toString())) == null) {
            if (plotArea.getType() == PlotAreaType.PARTIAL) {
                HashMap<PlotId, Plot> hashMap2 = hashMap = this.plots_tmp != null ? this.plots_tmp.get(plotArea.getWorldName()) : null;
                if (hashMap != null) {
                    object3 = hashMap.entrySet().iterator();
                    while (object3.hasNext()) {
                        object2 = (Map.Entry)object3.next();
                        object = (PlotId)object2.getKey();
                        if (!plotArea.contains((PlotId)object)) continue;
                        ((Plot)object2.getValue()).setArea(plotArea);
                        object3.remove();
                    }
                }
            }
        } else {
            object3 = hashMap.values().iterator();
            while (object3.hasNext()) {
                object2 = (Plot)object3.next();
                ((Plot)object2).setArea(plotArea);
            }
        }
        if (this.clustersTmp == null || (object3 = this.clustersTmp.remove(plotArea.toString())) == null) {
            if (plotArea.getType() == PlotAreaType.PARTIAL) {
                Object object4 = object3 = this.clustersTmp != null ? this.clustersTmp.get(plotArea.getWorldName()) : null;
                if (object3 != null) {
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = (PlotCluster)object2.next();
                        if (!((PlotCluster)object).intersects(plotArea.getMin(), plotArea.getMax())) continue;
                        ((PlotCluster)object).setArea(plotArea);
                        object2.remove();
                    }
                }
            }
        } else {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (PlotCluster)object2.next();
                ((PlotCluster)object).setArea(plotArea);
            }
        }
        this.getPlotAreaManager().addPlotArea(plotArea);
        plotArea.setupBorder();
        if (!Settings.Enabled_Components.PERSISTENT_ROAD_REGEN) {
            return;
        }
        object2 = new File(this.platform.getDirectory() + File.separator + "persistent_regen_data_" + plotArea.getId() + "_" + plotArea.getWorldName());
        if (!((File)object2).exists()) {
            return;
        }
        TaskManager.runTaskAsync(() -> PlotSquared.lambda$addPlotArea$2((File)object2, plotArea));
    }

    public void removePlotArea(@NonNull PlotArea plotArea) {
        this.getPlotAreaManager().removePlotArea(plotArea);
        this.setPlotsTmp(plotArea);
    }

    public void removePlotAreas(@NonNull String string) {
        for (PlotArea plotArea : this.getPlotAreaManager().getPlotAreasSet(string)) {
            if (!plotArea.getWorldName().equals(string)) continue;
            this.removePlotArea(plotArea);
        }
    }

    private void setPlotsTmp(@NonNull PlotArea plotArea) {
        if (this.plots_tmp == null) {
            this.plots_tmp = new HashMap();
        }
        HashMap hashMap = this.plots_tmp.computeIfAbsent(plotArea.toString(), string -> new HashMap());
        for (Plot plot : plotArea.getPlots()) {
            hashMap.put(plot.getId(), plot);
        }
        if (this.clustersTmp == null) {
            this.clustersTmp = new HashMap();
        }
        this.clustersTmp.put(plotArea.toString(), plotArea.getClusters());
    }

    public Set<PlotCluster> getClusters(@NonNull String string) {
        HashSet<PlotCluster> hashSet = new HashSet<PlotCluster>();
        for (PlotArea plotArea : this.getPlotAreaManager().getPlotAreasSet(string)) {
            hashSet.addAll(plotArea.getClusters());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public List<Plot> sortPlotsByTemp(Collection<Plot> collection) {
        int n = 0;
        int n2 = 0;
        for (Plot object2 : collection) {
            if (object2.temp > 0) {
                if (object2.temp <= n) continue;
                n = object2.temp;
                continue;
            }
            ++n2;
        }
        Plot[] plotArray = new Plot[n + 1];
        ArrayList<Plot> arrayList = new ArrayList<Plot>(n2);
        for (Plot plot : collection) {
            if (plot.temp <= 0) {
                arrayList.add(plot);
                continue;
            }
            plotArray[plot.temp] = plot;
        }
        ArrayList arrayList2 = new ArrayList(collection.size());
        for (Plot plot : plotArray) {
            if (plot == null) continue;
            arrayList2.add(plot);
        }
        arrayList.sort(Comparator.comparingInt(Plot::hashCode));
        arrayList2.addAll(arrayList);
        return arrayList2;
    }

    private ArrayList<Plot> sortPlotsByHash(Collection<Plot> collection) {
        int n = 256000;
        int n2 = 0;
        int n3 = 0;
        for (Plot object22 : collection) {
            int arrayList = MathMan.getPositiveId(object22.hashCode());
            if (arrayList <= n2) continue;
            if (arrayList >= n) {
                ++n3;
                continue;
            }
            n2 = arrayList;
        }
        n = Math.min(n, n2);
        Plot[] plotArray = new Plot[n + 1];
        ArrayList<Plot> arrayList = new ArrayList<Plot>(n3);
        ArrayList<Plot> arrayList2 = new ArrayList<Plot>();
        for (Plot plot : collection) {
            int n4 = MathMan.getPositiveId(plot.hashCode());
            if (n4 < n) {
                if (n4 >= 0) {
                    plotArray[n4] = plot;
                    continue;
                }
                arrayList2.add(plot);
                continue;
            }
            if (Math.abs(plot.getId().getX()) > 15446 || Math.abs(plot.getId().getY()) > 15446) {
                arrayList2.add(plot);
                continue;
            }
            arrayList.add(plot);
        }
        Plot[] plotArray2 = arrayList.toArray(new Plot[0]);
        this.sortPlotsByHash(plotArray2);
        ArrayList<Plot> arrayList3 = new ArrayList<Plot>(plotArray.length + plotArray2.length);
        for (Plot plot : plotArray) {
            if (plot == null) continue;
            arrayList3.add(plot);
        }
        Collections.addAll(arrayList3, plotArray2);
        arrayList3.addAll(arrayList2);
        return arrayList3;
    }

    private void sortPlotsByHash(@NonNull Plot @NonNull [] plotArray) {
        Object[] objectArray = new ArrayList[32];
        Arrays.fill(objectArray, new ArrayList());
        boolean bl = false;
        int n = 1;
        while (!bl) {
            Plot plot;
            bl = true;
            Plot[] plotArray2 = plotArray;
            int n2 = plotArray2.length;
            for (int i = 0; i < n2; ++i) {
                plot = plotArray2[i];
                int n3 = MathMan.getPositiveId(plot.hashCode()) / n;
                objectArray[n3 & 0x1F].add(plot);
                if (!bl || n3 <= 0) continue;
                bl = false;
            }
            int n4 = 0;
            for (n2 = 0; n2 < 32; ++n2) {
                Iterator iterator = objectArray[n2].iterator();
                while (iterator.hasNext()) {
                    plot = (Plot)iterator.next();
                    plotArray[n4++] = plot;
                }
                objectArray[n2].clear();
            }
            n *= 32;
        }
    }

    private @NonNull List<Plot> sortPlotsByTimestamp(@NonNull Collection<Plot> collection) {
        int n = 256000;
        int n2 = 0;
        int n3 = 0;
        for (Plot object22 : collection) {
            int arrayList = MathMan.getPositiveId(object22.hashCode());
            if (arrayList <= n2) continue;
            if (arrayList >= n) {
                ++n3;
                continue;
            }
            n2 = arrayList;
        }
        n = Math.min(n, n2);
        Plot[] plotArray = new Plot[n + 1];
        ArrayList<Plot> arrayList = new ArrayList<Plot>(n3);
        ArrayList<Plot> arrayList2 = new ArrayList<Plot>();
        for (Plot plot : collection) {
            int n4 = MathMan.getPositiveId(plot.hashCode());
            if (n4 < n) {
                if (n4 >= 0) {
                    plotArray[n4] = plot;
                    continue;
                }
                arrayList2.add(plot);
                continue;
            }
            if (Math.abs(plot.getId().getX()) > 15446 || Math.abs(plot.getId().getY()) > 15446) {
                arrayList2.add(plot);
                continue;
            }
            arrayList.add(plot);
        }
        Plot[] plotArray2 = arrayList.toArray(new Plot[0]);
        this.sortPlotsByHash(plotArray2);
        ArrayList<Plot> arrayList3 = new ArrayList<Plot>(plotArray.length + plotArray2.length);
        for (Plot plot : plotArray) {
            if (plot == null) continue;
            arrayList3.add(plot);
        }
        Collections.addAll(arrayList3, plotArray2);
        arrayList3.addAll(arrayList2);
        return arrayList3;
    }

    private @NonNull List<Plot> sortPlotsByModified(@NonNull Collection<Plot> collection) {
        ArrayList<Plot> arrayList = collection instanceof List ? (ArrayList<Plot>)collection : new ArrayList<Plot>(collection);
        ExpireManager expireManager = PlotSquared.platform().expireManager();
        arrayList.sort(Comparator.comparingLong(plot -> expireManager.getTimestamp(plot.getOwnerAbs())));
        return arrayList;
    }

    public @NonNull List<Plot> sortPlots(@NonNull Collection<Plot> collection, @NonNull SortType sortType, @Nullable PlotArea plotArea) {
        Object object;
        HashMap<PlotArea, Collection<Plot>> hashMap = new HashMap<PlotArea, Collection<Plot>>();
        int n = Arrays.stream(this.getPlotAreaManager().getAllPlotAreas()).mapToInt(PlotArea::getPlotCount).sum();
        if (collection.size() == n) {
            for (PlotArea object2 : this.getPlotAreaManager().getAllPlotAreas()) {
                hashMap.put(object2, object2.getPlots());
            }
        } else {
            for (PlotArea plotArea4 : this.getPlotAreaManager().getAllPlotAreas()) {
                hashMap.put(plotArea4, new ArrayList(0));
            }
            object = null;
            PlotArea plotArea4 = null;
            for (Plot plot : collection) {
                if (plotArea4 == plot.getArea()) {
                    object.add(plot);
                    continue;
                }
                plotArea4 = plot.getArea();
                object = (Collection)hashMap.get(plotArea4);
                object.add(plot);
            }
        }
        object = Arrays.asList(this.getPlotAreaManager().getAllPlotAreas());
        object.sort((plotArea2, plotArea3) -> {
            if (plotArea != null) {
                if (plotArea2.equals(plotArea)) {
                    return -1;
                }
                if (plotArea3.equals(plotArea)) {
                    return 1;
                }
            }
            return plotArea2.hashCode() - plotArea3.hashCode();
        });
        ArrayList<Plot> arrayList = new ArrayList<Plot>(collection.size());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            PlotArea plotArea5 = (PlotArea)iterator.next();
            switch (sortType) {
                case CREATION_DATE: {
                    arrayList.addAll(this.sortPlotsByTemp((Collection)hashMap.get(plotArea5)));
                    break;
                }
                case CREATION_DATE_TIMESTAMP: {
                    arrayList.addAll(this.sortPlotsByTimestamp((Collection)hashMap.get(plotArea5)));
                    break;
                }
                case DISTANCE_FROM_ORIGIN: {
                    arrayList.addAll(this.sortPlotsByHash((Collection)hashMap.get(plotArea5)));
                    break;
                }
                case LAST_MODIFIED: {
                    arrayList.addAll(this.sortPlotsByModified((Collection)hashMap.get(plotArea5)));
                    break;
                }
            }
        }
        return arrayList;
    }

    public void setPlots(@NonNull Map<String, HashMap<PlotId, Plot>> map) {
        if (this.plots_tmp == null) {
            this.plots_tmp = new HashMap();
        }
        for (Map.Entry<String, HashMap<PlotId, Plot>> entry : map.entrySet()) {
            String string2 = entry.getKey();
            PlotArea plotArea = this.getPlotAreaManager().getPlotArea(string2, null);
            if (plotArea == null) {
                Map map2 = this.plots_tmp.computeIfAbsent(string2, string -> new HashMap());
                map2.putAll((Map)entry.getValue());
                continue;
            }
            for (Plot plot : entry.getValue().values()) {
                plot.setArea(plotArea);
                plotArea.addPlot(plot);
            }
        }
    }

    public boolean removePlot(@NonNull Plot plot, boolean bl) {
        if (plot == null) {
            return false;
        }
        if (bl) {
            this.eventDispatcher.callDelete(plot);
        }
        if (plot.getArea().removePlot(plot.getId())) {
            PlotId plotId = (PlotId)plot.getArea().getMeta("lastPlot");
            int n = Math.max(Math.abs(plotId.getX()), Math.abs(plotId.getY()));
            int n2 = Math.max(Math.abs(plot.getId().getX()), Math.abs(plot.getId().getY()));
            if (n2 < n) {
                plot.getArea().setMeta("lastPlot", plot.getId());
            }
            if (bl) {
                this.eventDispatcher.callPostDelete(plot);
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadWorld(@NonNull String string, @Nullable GeneratorWrapper<?> generatorWrapper) {
        if (string.equals("CheckingPlotSquaredGenerator")) {
            return;
        }
        if (!this.getPlotAreaManager().addWorld(string)) {
            return;
        }
        Set<Object> set = this.worldConfiguration.contains("worlds") ? this.worldConfiguration.getConfigurationSection("worlds").getKeys(false) : new HashSet();
        String string2 = "worlds." + string;
        ConfigurationSection configurationSection = this.worldConfiguration.getConfigurationSection(string2);
        PlotAreaType plotAreaType = configurationSection != null ? ConfigurationUtil.getType(configurationSection) : PlotAreaType.NORMAL;
        if (plotAreaType == PlotAreaType.NORMAL) {
            GeneratorWrapper<?> generatorWrapper2;
            Object object;
            IndependentPlotGenerator independentPlotGenerator;
            if (this.getPlotAreaManager().getPlotAreas(string, null).length != 0) {
                return;
            }
            if (generatorWrapper != null && generatorWrapper.isFull()) {
                independentPlotGenerator = generatorWrapper.getPlotGenerator();
            } else {
                if (configurationSection == null) return;
                object = configurationSection.getString("generator.plugin");
                generatorWrapper2 = this.platform.getGenerator(string, (String)object);
                if (generatorWrapper2 != null && generatorWrapper2.isFull()) {
                    independentPlotGenerator = generatorWrapper2.getPlotGenerator();
                } else {
                    String string3 = configurationSection.getString("generator.init");
                    GeneratorWrapper<?> generatorWrapper3 = this.platform.getGenerator(string, string3);
                    if (generatorWrapper3 == null || !generatorWrapper3.isFull()) return;
                    independentPlotGenerator = generatorWrapper3.getPlotGenerator();
                }
            }
            object = independentPlotGenerator.getNewPlotArea(string, null, null, null);
            generatorWrapper2 = ((PlotArea)object).getPlotManager();
            LOGGER.info("Detected world load for '{}'", (Object)string);
            LOGGER.info("- generator: {}>{}", generatorWrapper, (Object)independentPlotGenerator);
            LOGGER.info("- plot world: {}", (Object)object.getClass().getCanonicalName());
            LOGGER.info("- plot area manager: {}", (Object)generatorWrapper2.getClass().getCanonicalName());
            if (!this.worldConfiguration.contains(string2)) {
                this.worldConfiguration.createSection(string2);
                configurationSection = this.worldConfiguration.getConfigurationSection(string2);
            }
            ((PlotArea)object).saveConfiguration(configurationSection);
            ((PlotArea)object).loadDefaultConfiguration(configurationSection);
            try {
                this.worldConfiguration.save(this.worldsFile);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.addPlotArea((PlotArea)object);
            independentPlotGenerator.initialize((PlotArea)object);
            return;
        }
        if (!set.contains(string)) {
            return;
        }
        ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection("areas");
        if (configurationSection2 == null) {
            if (this.getPlotAreaManager().getPlotAreas(string, null).length != 0) {
                return;
            }
            LOGGER.info("Detected world load for '{}'", (Object)string);
            String string4 = configurationSection.getString("generator.plugin", this.platform.pluginName());
            if (plotAreaType == PlotAreaType.PARTIAL) {
                HashSet hashSet;
                Set<Object> set2 = hashSet = this.clustersTmp != null ? this.clustersTmp.get(string) : new HashSet();
                if (hashSet == null) {
                    throw new IllegalArgumentException("No cluster exists for world: " + string);
                }
                ArrayDeque<PlotArea> arrayDeque = new ArrayDeque<PlotArea>();
                for (PlotCluster plotCluster : hashSet) {
                    PlotId plotId = plotCluster.getP1();
                    PlotId plotId2 = plotCluster.getP2();
                    String string5 = plotCluster.getName();
                    String string6 = string5 + "-" + plotId + "-" + plotId2;
                    configurationSection.createSection("areas." + string6);
                    DBFunc.replaceWorld(string, string + ";" + string5, plotId, plotId2);
                    LOGGER.info("- {}-{}-{}", (Object)string5, (Object)plotId, (Object)plotId2);
                    GeneratorWrapper<?> generatorWrapper4 = this.platform.getGenerator(string, string4);
                    if (generatorWrapper4 == null) {
                        throw new IllegalArgumentException("Invalid Generator: " + string4);
                    }
                    PlotArea plotArea = generatorWrapper4.getPlotGenerator().getNewPlotArea(string, string5, plotId, plotId2);
                    plotArea.saveConfiguration(configurationSection);
                    plotArea.loadDefaultConfiguration(configurationSection);
                    try {
                        this.worldConfiguration.save(this.worldsFile);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    LOGGER.info("| generator: {}>{}", generatorWrapper, generatorWrapper4);
                    LOGGER.info("| plot world: {}", (Object)plotArea.getClass().getCanonicalName());
                    LOGGER.info("| manager: {}", (Object)plotArea.getPlotManager().getClass().getCanonicalName());
                    LOGGER.info("Note: Area created for cluster '{}' (invalid or old configuration?)", (Object)string5);
                    generatorWrapper4.getPlotGenerator().initialize(plotArea);
                    generatorWrapper4.augment(plotArea);
                    arrayDeque.add(plotArea);
                }
                for (PlotArea plotArea : arrayDeque) {
                    this.addPlotArea(plotArea);
                }
                return;
            }
            GeneratorWrapper<?> generatorWrapper5 = this.platform.getGenerator(string, string4);
            if (generatorWrapper5 == null) {
                throw new IllegalArgumentException("Invalid Generator: " + string4);
            }
            PlotArea plotArea = generatorWrapper5.getPlotGenerator().getNewPlotArea(string, null, null, null);
            LOGGER.info("- generator: {}>{}", generatorWrapper, generatorWrapper5);
            LOGGER.info("- plot world: {}", (Object)plotArea.getClass().getCanonicalName());
            LOGGER.info("- plot area manager: {}", (Object)plotArea.getPlotManager().getClass().getCanonicalName());
            if (!this.worldConfiguration.contains(string2)) {
                this.worldConfiguration.createSection(string2);
                configurationSection = this.worldConfiguration.getConfigurationSection(string2);
            }
            plotArea.saveConfiguration(configurationSection);
            plotArea.loadDefaultConfiguration(configurationSection);
            try {
                this.worldConfiguration.save(this.worldsFile);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            generatorWrapper5.getPlotGenerator().initialize(plotArea);
            generatorWrapper5.augment(plotArea);
            this.addPlotArea(plotArea);
            return;
        }
        if (plotAreaType == PlotAreaType.AUGMENTED) {
            throw new IllegalArgumentException("Invalid type for multi-area world. Expected `PARTIAL`, got `" + PlotAreaType.AUGMENTED + "`");
        }
        for (String string7 : configurationSection2.getKeys(false)) {
            LOGGER.info("- {}", (Object)string7);
            String[] stringArray = string7.split("(?<=[^;-])-");
            if (stringArray.length != 3) {
                throw new IllegalArgumentException("Invalid Area identifier: " + string7 + ". Expected form `<name>-<pos1>-<pos2>`");
            }
            String string8 = stringArray[0];
            PlotId plotId = PlotId.fromString(stringArray[1]);
            PlotId plotId3 = PlotId.fromString(stringArray[2]);
            if (string8.isEmpty()) {
                throw new IllegalArgumentException("Invalid Area identifier: " + string7 + ". Expected form `<name>-<x1;z1>-<x2;z2>`");
            }
            PlotArea plotArea = this.getPlotAreaManager().getPlotArea(string, string8);
            if (plotArea != null && string8.equals(plotArea.getId())) continue;
            ConfigurationSection configurationSection3 = configurationSection2.getConfigurationSection(string7);
            YamlConfiguration yamlConfiguration = new YamlConfiguration();
            for (String string9 : configurationSection3.getKeys(true)) {
                if (configurationSection3.get(string9) instanceof MemorySection || yamlConfiguration.contains(string9)) continue;
                yamlConfiguration.set(string9, configurationSection3.get(string9));
            }
            for (String string10 : configurationSection.getKeys(true)) {
                if (configurationSection.get(string10) instanceof MemorySection || string10.startsWith("areas") || yamlConfiguration.contains(string10)) continue;
                yamlConfiguration.set(string10, configurationSection.get(string10));
            }
            String string11 = yamlConfiguration.getString("generator.plugin", this.platform.pluginName());
            GeneratorWrapper<?> generatorWrapper6 = this.platform.getGenerator(string, string11);
            if (generatorWrapper6 == null) {
                throw new IllegalArgumentException("Invalid Generator: " + (String)string11);
            }
            PlotArea plotArea2 = generatorWrapper6.getPlotGenerator().getNewPlotArea(string, string8, plotId, plotId3);
            plotArea2.saveConfiguration(yamlConfiguration);
            for (String string12 : yamlConfiguration.getKeys(true)) {
                if (yamlConfiguration.get(string12) instanceof MemorySection) continue;
                if (!configurationSection.contains(string12)) {
                    configurationSection.set(string12, yamlConfiguration.get(string12));
                    continue;
                }
                Object object = configurationSection.get(string12);
                if (Objects.equals(object, yamlConfiguration.get(string12))) continue;
                configurationSection3.set(string12, yamlConfiguration.get(string12));
            }
            plotArea2.loadDefaultConfiguration(yamlConfiguration);
            try {
                this.worldConfiguration.save(this.worldsFile);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            LOGGER.info("Detected area load for '{}'", (Object)string);
            LOGGER.info("| generator: {}>{}", generatorWrapper, generatorWrapper6);
            LOGGER.info("| plot world: {}", (Object)plotArea2);
            LOGGER.info("| manager: {}", (Object)plotArea2.getPlotManager());
            generatorWrapper6.getPlotGenerator().initialize(plotArea2);
            generatorWrapper6.augment(plotArea2);
            this.addPlotArea(plotArea2);
        }
    }

    public boolean setupPlotWorld(@NonNull String string, @Nullable String string3, @NonNull IndependentPlotGenerator independentPlotGenerator) {
        if (string3 != null && !string3.isEmpty()) {
            String[] stringArray;
            Object object;
            Object object2;
            List<String> list = Arrays.asList("s=", "size=", "g=", "gap=", "h=", "height=", "minh=", "minheight=", "maxh=", "maxheight=", "f=", "floor=", "m=", "main=", "w=", "wall=", "b=", "border=");
            int n = (int)list.stream().filter(string2 -> string3.toLowerCase(Locale.ENGLISH).contains((CharSequence)string2)).count();
            Object object3 = string3.toLowerCase(Locale.ENGLISH).split(",(?![^\\(\\[]*[\\]\\)])");
            if (((String[])object3).length > n) {
                object2 = new String[n];
                int n2 = 0;
                object = new StringBuilder();
                String[] stringArray2 = object3;
                int n3 = stringArray2.length;
                block35: for (int i = 0; i < n3; ++i) {
                    stringArray = stringArray2[i];
                    for (String string4 : list) {
                        if (!stringArray.contains(string4)) continue;
                        if (!((StringBuilder)object).toString().isEmpty()) {
                            object2[n2++] = ((StringBuilder)object).toString();
                            object = new StringBuilder();
                        }
                        ((StringBuilder)object).append((String)stringArray);
                        continue block35;
                    }
                    if (((StringBuilder)object).toString().charAt(((StringBuilder)object).length() - 1) != '=') {
                        ((StringBuilder)object).append(",");
                    }
                    ((StringBuilder)object).append((String)stringArray);
                }
                if (!((StringBuilder)object).toString().isEmpty()) {
                    object2[n2] = ((StringBuilder)object).toString();
                }
                object3 = object2;
            }
            object2 = this.platform.injector().getInstance(HybridPlotWorldFactory.class);
            HybridPlotWorld hybridPlotWorld = object2.create(string, null, independentPlotGenerator, null, null);
            for (String string5 : object3) {
                String string4;
                stringArray = string5.split("=");
                if (stringArray.length != 2) {
                    LOGGER.error("No value provided for '{}'", (Object)string5);
                    return false;
                }
                String string6 = stringArray[0].toLowerCase();
                string4 = stringArray[1];
                try {
                    String string7 = "worlds." + string + ".";
                    switch (string6) {
                        case "s": 
                        case "size": {
                            this.worldConfiguration.set(string7 + "plot.size", ConfigurationUtil.INTEGER.parseString(string4).shortValue());
                            break;
                        }
                        case "g": 
                        case "gap": {
                            this.worldConfiguration.set(string7 + "road.width", ConfigurationUtil.INTEGER.parseString(string4).shortValue());
                            break;
                        }
                        case "h": 
                        case "height": {
                            this.worldConfiguration.set(string7 + "road.height", ConfigurationUtil.INTEGER.parseString(string4).shortValue());
                            this.worldConfiguration.set(string7 + "plot.height", ConfigurationUtil.INTEGER.parseString(string4).shortValue());
                            this.worldConfiguration.set(string7 + "wall.height", ConfigurationUtil.INTEGER.parseString(string4).shortValue());
                            break;
                        }
                        case "minh": 
                        case "minheight": {
                            this.worldConfiguration.set(string7 + "world.min_gen_height", ConfigurationUtil.INTEGER.parseString(string4).shortValue());
                            break;
                        }
                        case "maxh": 
                        case "maxheight": {
                            this.worldConfiguration.set(string7 + "world.max_gen_height", ConfigurationUtil.INTEGER.parseString(string4).shortValue());
                            break;
                        }
                        case "f": 
                        case "floor": {
                            this.worldConfiguration.set(string7 + "plot.floor", ConfigurationUtil.BLOCK_BUCKET.parseString(string4).toString());
                            break;
                        }
                        case "m": 
                        case "main": {
                            this.worldConfiguration.set(string7 + "plot.filling", ConfigurationUtil.BLOCK_BUCKET.parseString(string4).toString());
                            break;
                        }
                        case "w": 
                        case "wall": {
                            this.worldConfiguration.set(string7 + "wall.filling", ConfigurationUtil.BLOCK_BUCKET.parseString(string4).toString());
                            break;
                        }
                        case "b": 
                        case "border": {
                            this.worldConfiguration.set(string7 + "wall.block", ConfigurationUtil.BLOCK_BUCKET.parseString(string4).toString());
                            break;
                        }
                        default: {
                            LOGGER.error("Key not found: {}", (Object)string5);
                            return false;
                        }
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Invalid value '{}' for arg '{}'", (Object)string4, (Object)string5);
                    exception.printStackTrace();
                    return false;
                }
            }
            try {
                object = this.worldConfiguration.getConfigurationSection("worlds." + string);
                hybridPlotWorld.saveConfiguration((ConfigurationSection)object);
                hybridPlotWorld.loadDefaultConfiguration((ConfigurationSection)object);
                this.worldConfiguration.save(this.worldsFile);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return true;
    }

    public void copyFile(@NonNull String string, @NonNull String string2) {
        try {
            File file;
            File file2 = this.platform.getDirectory();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            if ((file = FileUtils.getFile(file2, string2 + File.separator + string)).exists()) {
                return;
            }
            try (InputStream inputStream = this.platform.getClass().getResourceAsStream(string);){
                byte[] byArray = new byte[2048];
                if (inputStream == null) {
                    try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(this.jarFile));){
                        ZipEntry zipEntry = zipInputStream.getNextEntry();
                        while (zipEntry != null) {
                            String string3 = zipEntry.getName();
                            if (string3.equals(string)) {
                                new File(file.getParent()).mkdirs();
                                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                                    int n;
                                    while ((n = zipInputStream.read(byArray)) > 0) {
                                        fileOutputStream.write(byArray, 0, n);
                                    }
                                }
                                zipEntry = null;
                                continue;
                            }
                            zipEntry = zipInputStream.getNextEntry();
                        }
                        zipInputStream.closeEntry();
                    }
                    return;
                }
                file.createNewFile();
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    int n;
                    while ((n = inputStream.read(byArray)) > 0) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.error("Could not save {}", (Object)string);
            iOException.printStackTrace();
        }
    }

    public void disable() {
        try {
            this.eventDispatcher.unregisterAll();
            this.checkRoadRegenPersistence();
            HashSet<Plot> hashSet = new HashSet<Plot>();
            try {
                this.forEachPlotRaw(hashSet::add);
            }
            catch (Exception exception) {
                // empty catch block
            }
            DBFunc.validatePlots(hashSet);
            DBFunc.close();
        }
        catch (NullPointerException nullPointerException) {
            LOGGER.error("Could not close database connection", (Throwable)nullPointerException);
            nullPointerException.printStackTrace();
        }
    }

    private void checkRoadRegenPersistence() {
        if (!HybridUtils.UPDATE || !Settings.Enabled_Components.PERSISTENT_ROAD_REGEN || HybridUtils.regions.isEmpty() && HybridUtils.chunks.isEmpty()) {
            return;
        }
        LOGGER.info("Road regeneration incomplete. Saving incomplete regions to disk");
        LOGGER.info("- regions: {}", (Object)HybridUtils.regions.size());
        LOGGER.info("- chunks: {}", (Object)HybridUtils.chunks.size());
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
        for (BlockVector2 object2 : HybridUtils.regions) {
            arrayList.add(new int[]{object2.getBlockX(), object2.getBlockZ()});
        }
        for (BlockVector2 blockVector2 : HybridUtils.chunks) {
            arrayList2.add(new int[]{blockVector2.getBlockX(), blockVector2.getBlockZ()});
        }
        ArrayList arrayList3 = new ArrayList();
        arrayList3.add(arrayList);
        arrayList3.add(arrayList2);
        arrayList3.add(HybridUtils.height);
        File file = new File(this.platform.getDirectory() + File.separator + "persistent_regen_data_" + HybridUtils.area.getId() + "_" + HybridUtils.area.getWorldName());
        if (file.exists() && !file.delete()) {
            LOGGER.error("persistent_regene_data file already exists and could not be deleted");
            return;
        }
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(Files.newOutputStream(file.toPath(), StandardOpenOption.CREATE_NEW));){
            objectOutputStream.writeObject(arrayList3);
        }
        catch (IOException iOException) {
            LOGGER.error("Error creating persistent_region_data file", (Throwable)iOException);
        }
    }

    public void setupDatabase() {
        try {
            Object object;
            Database database;
            if (DBFunc.dbManager != null) {
                DBFunc.dbManager.close();
            }
            if (Storage.MySQL.USE) {
                database = new MySQL(Storage.MySQL.HOST, Storage.MySQL.PORT, Storage.MySQL.DATABASE, Storage.MySQL.USER, Storage.MySQL.PASSWORD);
            } else if (Storage.SQLite.USE) {
                object = FileUtils.getFile(this.platform.getDirectory(), Storage.SQLite.DB + ".db");
                database = new SQLite((File)object);
            } else {
                LOGGER.error("No storage type is set. Disabling PlotSquared");
                this.platform.shutdown();
                return;
            }
            DBFunc.dbManager = new SQLManager(database, Storage.PREFIX, this.eventDispatcher, this.plotListener, this.worldConfiguration);
            this.plots_tmp = DBFunc.getPlots();
            if (this.getPlotAreaManager() instanceof SinglePlotAreaManager) {
                object = ((SinglePlotAreaManager)this.getPlotAreaManager()).getArea();
                this.addPlotArea((PlotArea)object);
                ConfigurationSection configurationSection = this.worldConfiguration.getConfigurationSection("worlds.*");
                if (configurationSection == null) {
                    configurationSection = this.worldConfiguration.createSection("worlds.*");
                }
                ((SinglePlotArea)object).saveConfiguration(configurationSection);
                ((PlotArea)object).loadDefaultConfiguration(configurationSection);
            }
            this.clustersTmp = DBFunc.getClusters();
            LOGGER.info("Connection to database established. Type: {}", (Object)(Storage.MySQL.USE ? "MySQL" : "SQLite"));
        }
        catch (ClassNotFoundException | SQLException exception) {
            LOGGER.error("Failed to open database connection ({}). Disabling PlotSquared", (Object)(Storage.MySQL.USE ? "MySQL" : "SQLite"));
            LOGGER.error("==== Here is an ugly stacktrace, if you are interested in those things ===");
            exception.printStackTrace();
            LOGGER.error("==== End of stacktrace ====");
            LOGGER.error("Please go to the {} 'storage.yml' and configure the database correctly", (Object)this.platform.pluginName());
            this.platform.shutdown();
        }
    }

    public void setupConfig() {
        Object object;
        Object object2;
        Object object3;
        String string = this.getConfig().getString("version");
        if (string != null) {
            object3 = string.split("\\.");
            object2 = new int[]{Integer.parseInt(object3[0]), Integer.parseInt((String)object3[1]), Integer.parseInt((String)object3[2])};
            if (this.checkVersion(new int[]{3, 4, 0}, (int[])object2)) {
                Settings.convertLegacy(this.configFile);
                if (this.getConfig().contains("worlds")) {
                    object = this.getConfig().getConfigurationSection("worlds");
                    this.worldConfiguration.set("worlds", object);
                    try {
                        this.worldConfiguration.save(this.worldsFile);
                    }
                    catch (IOException iOException) {
                        LOGGER.error("Failed to save worlds.yml", (Throwable)iOException);
                        iOException.printStackTrace();
                    }
                }
                Settings.save(this.configFile);
            }
        }
        Settings.load(this.configFile);
        try {
            object3 = this.getClass().getResourceAsStream("/plugin.properties");
            try {
                object2 = new BufferedReader(new InputStreamReader((InputStream)object3));
                try {
                    object = ((BufferedReader)object2).readLine();
                    String string2 = ((BufferedReader)object2).readLine();
                    String string3 = ((BufferedReader)object2).readLine();
                    this.version = PlotVersion.tryParse((String)object, string2, string3);
                }
                finally {
                    ((BufferedReader)object2).close();
                }
            }
            finally {
                if (object3 != null) {
                    ((InputStream)object3).close();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Settings.save(this.configFile);
        this.config = YamlConfiguration.loadConfiguration(this.configFile);
    }

    public boolean setupConfigs() {
        File file;
        block13: {
            file = new File(this.platform.getDirectory(), "config");
            if (!file.exists() && !file.mkdirs()) {
                LOGGER.error("Failed to create the {} config folder. Please create it manually", (Object)this.platform.getDirectory());
            }
            try {
                this.worldsFile = new File(file, "worlds.yml");
                if (!this.worldsFile.exists() && !this.worldsFile.createNewFile()) {
                    LOGGER.error("Could not create the worlds file. Please create 'worlds.yml' manually");
                }
                this.worldConfiguration = YamlConfiguration.loadConfiguration(this.worldsFile);
                if (this.worldConfiguration.contains("worlds")) {
                    if (this.worldConfiguration.contains("configuration_version") && (this.worldConfiguration.getString("configuration_version").equalsIgnoreCase("post_flattening") || this.worldConfiguration.getString("configuration_version").equalsIgnoreCase("v5"))) break block13;
                    LOGGER.info("A legacy configuration file was detected. Conversion will be attempted.");
                    try {
                        com.google.common.io.Files.copy((File)this.worldsFile, (File)new File(file, "worlds.yml.old"));
                        LOGGER.info("A copy of worlds.yml has been saved in the file worlds.yml.old");
                        ConfigurationSection configurationSection = this.worldConfiguration.getConfigurationSection("worlds");
                        LegacyConverter legacyConverter = new LegacyConverter(configurationSection);
                        legacyConverter.convert();
                        this.worldConfiguration.set("worlds", configurationSection);
                        this.setConfigurationVersion("post_flattening");
                        LOGGER.info("The conversion has finished. PlotSquared will now be disabled and the new configuration file will be used at next startup. Please review the new worlds.yml file. Please note that schematics will not be converted, as we are now using WorldEdit to handle schematics. You need to re-generate the schematics.");
                    }
                    catch (Exception exception) {
                        LOGGER.error("Failed to convert the legacy configuration file. See stack trace for information.", (Throwable)exception);
                    }
                    this.platform.shutdown();
                    return false;
                }
                this.worldConfiguration.set("configuration_version", "post_flattening");
            }
            catch (IOException iOException) {
                LOGGER.error("Failed to save worlds.yml");
            }
        }
        try {
            this.configFile = new File(file, "settings.yml");
            if (!this.configFile.exists() && !this.configFile.createNewFile()) {
                LOGGER.error("Could not create the settings file. Please create 'settings.yml' manually");
            }
            this.config = YamlConfiguration.loadConfiguration(this.configFile);
            this.setupConfig();
        }
        catch (IOException iOException) {
            LOGGER.error("Failed to save settings.yml");
        }
        try {
            this.storageFile = new File(file, "storage.yml");
            if (!this.storageFile.exists() && !this.storageFile.createNewFile()) {
                LOGGER.error("Could not create the storage settings file. Please create 'storage.yml' manually");
            }
            YamlConfiguration.loadConfiguration(this.storageFile);
            this.setupStorage();
        }
        catch (IOException iOException) {
            LOGGER.error("Failed to save storage.yml");
        }
        return true;
    }

    public @NonNull String getConfigurationVersion() {
        return this.worldConfiguration.get("configuration_version", "post_flattening").toString();
    }

    public void setConfigurationVersion(@NonNull String string) {
        this.worldConfiguration.set("configuration_version", string);
        this.worldConfiguration.save(this.worldsFile);
    }

    private void setupStorage() {
        Storage.load(this.storageFile);
        Storage.save(this.storageFile);
        YamlConfiguration.loadConfiguration(this.storageFile);
    }

    private void showDebug() {
        if (Settings.DEBUG) {
            Map<String, Object> map = Settings.getFields(Settings.Enabled_Components.class);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                LOGGER.info("Key: {} | Value: {}", (Object)entry.getKey(), entry.getValue());
            }
        }
    }

    public void forEachPlotRaw(@NonNull Consumer<Plot> consumer) {
        for (PlotArea plotArea : this.getPlotAreaManager().getAllPlotAreas()) {
            plotArea.getPlots().forEach(consumer);
        }
        if (this.plots_tmp != null) {
            for (HashMap hashMap : this.plots_tmp.values()) {
                hashMap.values().forEach(consumer);
            }
        }
    }

    public boolean isNonStandardGeneration(@NonNull String string, @NonNull BlockVector2 blockVector2) {
        Location location = Location.at(string, blockVector2.getBlockX() << 4, 64, blockVector2.getBlockZ() << 4);
        PlotArea plotArea = this.getPlotAreaManager().getApplicablePlotArea(location);
        if (plotArea == null) {
            return true;
        }
        return plotArea.getTerrain() != PlotAreaTerrainType.NONE;
    }

    public @NonNull YamlConfiguration getConfig() {
        return this.config;
    }

    public @NonNull UUIDPipeline getImpromptuUUIDPipeline() {
        return this.impromptuUUIDPipeline;
    }

    public @NonNull UUIDPipeline getBackgroundUUIDPipeline() {
        return this.backgroundUUIDPipeline;
    }

    public @NonNull WorldEdit getWorldEdit() {
        return this.worldedit;
    }

    public @NonNull File getConfigFile() {
        return this.configFile;
    }

    public @NonNull File getWorldsFile() {
        return this.worldsFile;
    }

    public @NonNull YamlConfiguration getWorldConfiguration() {
        return this.worldConfiguration;
    }

    public @NonNull CaptionMap getCaptionMap(@NonNull String string2) {
        return this.captionMaps.computeIfAbsent(string2.toLowerCase(Locale.ENGLISH), string -> new DummyCaptionMap());
    }

    public void registerCaptionMap(@NonNull String string, @NonNull CaptionMap captionMap) {
        if (string.equalsIgnoreCase("plotsquared")) {
            throw new IllegalArgumentException("Cannot replace default caption map");
        }
        this.captionMaps.put(string.toLowerCase(Locale.ENGLISH), captionMap);
    }

    public @NonNull EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public @NonNull PlotListener getPlotListener() {
        return this.plotListener;
    }

    public boolean isWeInitialised() {
        return this.weInitialised;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$addPlotArea$2(File file, PlotArea plotArea) {
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));){
            List list = (List)objectInputStream.readObject();
            ArrayList arrayList = (ArrayList)list.get(0);
            ArrayList arrayList2 = (ArrayList)list.get(1);
            HashSet<BlockVector2> hashSet = new HashSet<BlockVector2>();
            HashSet<BlockVector2> hashSet2 = new HashSet<BlockVector2>();
            arrayList.forEach(nArray -> hashSet.add(BlockVector2.at((int)nArray[0], (int)nArray[1])));
            arrayList2.forEach(nArray -> hashSet2.add(BlockVector2.at((int)nArray[0], (int)nArray[1])));
            int n = (Integer)list.get(2);
            LOGGER.info("Incomplete road regeneration found. Restarting in world {} with height {}", (Object)plotArea.getWorldName(), (Object)n);
            LOGGER.info("- Regions: {}", (Object)hashSet.size());
            LOGGER.info("- Chunks: {}", (Object)hashSet2.size());
            HybridUtils.UPDATE = true;
            PlotSquared.platform().hybridUtils().scheduleRoadUpdate(plotArea, hashSet, n, hashSet2);
        }
        catch (IOException | ClassNotFoundException exception) {
            LOGGER.error("Error restarting road regeneration", (Throwable)exception);
        }
        finally {
            if (!file.delete()) {
                LOGGER.error("Error deleting persistent_regen_data_{}. Please delete this file manually", (Object)plotArea.getId());
            }
        }
    }

    private final class WEPlatformReadyListener {
        private WEPlatformReadyListener() {
        }

        @Subscribe(priority=EventHandler.Priority.VERY_EARLY)
        public void onPlatformReady(PlatformReadyEvent platformReadyEvent) {
            PlotSquared.this.weInitialised = true;
            WorldEdit.getInstance().getEventBus().unregister((Object)this);
        }
    }

    public static enum SortType {
        CREATION_DATE,
        CREATION_DATE_TIMESTAMP,
        LAST_MODIFIED,
        DISTANCE_FROM_ORIGIN;

    }
}

