/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.arkitektonika;

import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.arkitektonika.ApiClient;
import com.plotsquared.core.arkitektonika.ApiVersion;
import com.plotsquared.core.arkitektonika.ClientFactory;
import com.plotsquared.core.arkitektonika.ResourceStatus;
import com.plotsquared.core.arkitektonika.Schematic;
import com.plotsquared.core.arkitektonika.SchematicKeys;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Arkitektonika {
    private static final ClientFactory clientFactory = new ClientFactory();
    private final ApiClient client;
    private final ExecutorService executorService;

    private Arkitektonika(@NotNull String string, @NotNull ApiVersion apiVersion, @NotNull ExecutorService executorService) {
        this.client = clientFactory.getClient(apiVersion, string);
        this.executorService = executorService;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public ApiClient getClient() {
        return this.client;
    }

    @NotNull
    public CompletableFuture<Boolean> isCompatible() {
        return this.client.checkCompatibility(this.executorService);
    }

    @NotNull
    public CompletableFuture<SchematicKeys> upload(@NotNull File file) {
        return this.client.upload(file, this.executorService);
    }

    @NotNull
    public CompletableFuture<ResourceStatus> checkStatus(@NotNull String string) {
        return this.client.checkStatus(string, this.executorService);
    }

    @NotNull
    public CompletableFuture<Boolean> delete(@NotNull String string) {
        return this.client.delete(string, this.executorService);
    }

    @NotNull
    public CompletableFuture<Schematic> download(@NotNull String string) {
        return this.client.download(string, this.executorService);
    }

    public static final class Builder {
        private String url;
        private ApiVersion version = ApiVersion.V1_0_0;
        private ExecutorService executorService = Executors.newCachedThreadPool();

        private Builder() {
        }

        @NotNull
        public Builder withUrl(@NotNull String string) {
            this.url = Objects.requireNonNull(string);
            return this;
        }

        @NotNull
        public Builder withVersion(@NotNull ApiVersion apiVersion) {
            this.version = Objects.requireNonNull(apiVersion);
            return this;
        }

        @NotNull
        public Builder withExecutorService(@NotNull ExecutorService executorService) {
            this.executorService = Objects.requireNonNull(executorService);
            return this;
        }

        @NotNull
        public Arkitektonika build() {
            if (this.url == null) {
                throw new NullPointerException("No URL was provided");
            }
            return new Arkitektonika(this.url, this.version, this.executorService);
        }
    }
}

