/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.arkitektonika.v1;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.arkitektonika.ApiVersion;
import com.plotsquared.core.arkitektonika.ResourceStatus;
import com.plotsquared.core.arkitektonika.Schematic;
import com.plotsquared.core.arkitektonika.SchematicKeys;
import com.plotsquared.core.arkitektonika.exceptions.InvalidFormatException;
import com.plotsquared.core.arkitektonika.exceptions.ResourceRetrievalException;
import com.plotsquared.core.arkitektonika.exceptions.ResourceUploadException;
import com.plotsquared.core.http.ContentType;
import com.plotsquared.core.http.EntityMapper;
import com.plotsquared.core.http.HttpClient;
import com.plotsquared.core.http.HttpResponse;
import com.plotsquared.core.http.external.GsonMapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

public final class ApiClient
implements com.plotsquared.core.arkitektonika.ApiClient {
    private final HttpClient httpClient;

    public ApiClient(@NotNull String string) {
        this.httpClient = HttpClient.newBuilder().withBaseURL(string).withEntityMapper(EntityMapper.newInstance().registerDeserializer(JsonObject.class, GsonMapper.deserializer(JsonObject.class, new GsonBuilder().create())).registerSerializer(File.class, new SchematicSerializer())).build();
    }

    @Override
    @NotNull
    public ApiVersion getApiVersion() {
        return ApiVersion.V1_0_0;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> checkCompatibility(@NotNull ExecutorService executorService) {
        return CompletableFuture.supplyAsync(() -> {
            HttpResponse httpResponse2 = this.httpClient.get("/").onStatus(200, httpResponse -> {}).onRemaining(httpResponse -> {
                throw new ResourceRetrievalException("/", httpResponse.getStatusCode(), httpResponse.getStatus());
            }).execute();
            JsonObject jsonObject = Objects.requireNonNull(httpResponse2, "Failed to retrieve response").getResponseEntity(JsonObject.class);
            return jsonObject.has("version") && jsonObject.get("version").getAsString().startsWith("1.");
        }, executorService);
    }

    @Override
    @NotNull
    public CompletableFuture<SchematicKeys> upload(@NotNull File file, @NotNull ExecutorService executorService) {
        return CompletableFuture.supplyAsync(() -> {
            HttpResponse httpResponse2 = this.httpClient.post("/upload").withInput(() -> file).onStatus(400, httpResponse -> {
                throw new InvalidFormatException("/upload", 400, httpResponse.getStatus());
            }).onStatus(200, httpResponse -> {}).onRemaining(httpResponse -> {
                throw new ResourceUploadException("/upload", httpResponse.getStatusCode(), httpResponse.getStatus(), "Other");
            }).execute();
            JsonObject jsonObject = Objects.requireNonNull(httpResponse2, "Failed to get response").getResponseEntity(JsonObject.class);
            return new SchematicKeys(jsonObject.get("download_key").getAsString(), jsonObject.get("delete_key").getAsString());
        }, executorService);
    }

    @Override
    @NotNull
    public CompletableFuture<ResourceStatus> checkStatus(@NotNull String string, @NotNull ExecutorService executorService) {
        return CompletableFuture.supplyAsync(() -> {
            HttpResponse httpResponse = this.httpClient.head(String.format("/download/%s", string)).execute();
            if (httpResponse == null) {
                throw new ResourceRetrievalException(String.format("/download/%s", string), 0, "Could not fetch response");
            }
            if (httpResponse.getStatusCode() == 200) {
                return ResourceStatus.OK;
            }
            if (httpResponse.getStatusCode() == 404) {
                return ResourceStatus.NON_EXISTENT;
            }
            if (httpResponse.getStatusCode() == 410) {
                return ResourceStatus.DELETED;
            }
            throw new ResourceRetrievalException(String.format("/download/%s", string), httpResponse.getStatusCode(), httpResponse.getStatus());
        }, executorService);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> delete(@NotNull String string, @NotNull ExecutorService executorService) {
        return CompletableFuture.supplyAsync(() -> {
            HttpResponse httpResponse2 = this.httpClient.delete(String.format("/delete/%s", string)).onStatus(200, httpResponse -> {}).onRemaining(httpResponse -> {
                throw new ResourceRetrievalException(String.format("/delete/%s", string), httpResponse.getStatusCode(), httpResponse.getStatus());
            }).execute();
            if (httpResponse2 == null) {
                throw new ResourceRetrievalException(String.format("/delete/%s", string), 0, "Could not fetch response");
            }
            return true;
        }, executorService);
    }

    @Override
    @NotNull
    public CompletableFuture<Schematic> download(@NotNull String string, @NotNull ExecutorService executorService) {
        return CompletableFuture.supplyAsync(() -> {
            HttpResponse httpResponse2 = this.httpClient.get(String.format("/download/%s", string)).onStatus(200, httpResponse -> {}).onRemaining(httpResponse -> {
                throw new ResourceRetrievalException(String.format("/download/%s", string), httpResponse.getStatusCode(), httpResponse.getStatus());
            }).execute();
            if (httpResponse2 == null) {
                throw new ResourceRetrievalException(String.format("/download/%s", string), 0, "Could not fetch response");
            }
            return new Schematic(string, httpResponse2.getRawResponse());
        }, executorService);
    }

    private static final class SchematicSerializer
    implements EntityMapper.EntitySerializer<File> {
        private final String boundary = UUID.randomUUID().toString();

        private SchematicSerializer() {
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        @NotNull
        public byte[] serialize(@NotNull File file) {
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8), true);
                try {
                    printWriter.append("--").append(this.boundary).append("\r\n");
                    printWriter.append("Content-Disposition: form-data; name=\"schematic\"; filename=\"plot.schem\"\r\n");
                    printWriter.append("Content-Type: application/octet-stream\r\n\r\n").flush();
                    Files.copy(file.toPath(), byteArrayOutputStream);
                    byteArrayOutputStream.flush();
                    printWriter.append("\r\n").flush();
                    printWriter.append("--").append(this.boundary).append("--\r\n").flush();
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    printWriter.close();
                    return byArray;
                }
                catch (Throwable throwable) {
                    try {
                        printWriter.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return new byte[0];
            }
        }

        @Override
        public ContentType getContentType() {
            return ContentType.of(String.format("multipart/form-data; boundary=%s", this.boundary));
        }
    }
}

