/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.backup;

import com.plotsquared.core.backup.Backup;
import com.plotsquared.core.backup.BackupManager;
import com.plotsquared.core.backup.BackupProfile;
import com.plotsquared.core.configuration.adventure.text.minimessage.MiniMessage;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.schematic.Schematic;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.google.Inject;
import com.plotsquared.google.assistedinject.Assisted;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PlayerBackupProfile
implements BackupProfile {
    static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private final UUID owner;
    private final Plot plot;
    private final BackupManager backupManager;
    private final SchematicHandler schematicHandler;
    private final Object backupLock = new Object();
    private volatile List<Backup> backupCache;

    @Inject
    public PlayerBackupProfile(@Assisted @NonNull UUID uUID, @Assisted @NonNull Plot plot, @NonNull BackupManager backupManager, @NonNull SchematicHandler schematicHandler) {
        this.owner = uUID;
        this.plot = plot;
        this.backupManager = backupManager;
        this.schematicHandler = schematicHandler;
    }

    private static boolean isValidFile(@NonNull Path path) {
        String string = path.getFileName().toString();
        return string.endsWith(".schem") || string.endsWith(".schematic");
    }

    private static Path resolve(@NonNull Path path, String string) {
        Path path2 = path;
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            if (!Files.exists(path2 = path.resolve(string), new LinkOption[0])) {
                Files.createDirectory(path2, new FileAttribute[0]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull CompletableFuture<List<Backup>> listBackups() {
        Object object = this.backupLock;
        synchronized (object) {
            if (this.backupCache != null) {
                return CompletableFuture.completedFuture(this.backupCache);
            }
            return CompletableFuture.supplyAsync(() -> {
                Path path2 = this.getBackupDirectory();
                if (!Files.exists(path2, new LinkOption[0])) {
                    try {
                        Files.createDirectories(path2, new FileAttribute[0]);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        return Collections.emptyList();
                    }
                }
                ArrayList<Backup> arrayList = new ArrayList<Backup>();
                try {
                    Files.walk(path2, new FileVisitOption[0]).filter(PlayerBackupProfile::isValidFile).forEach(path -> {
                        try {
                            BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                            arrayList.add(new Backup(this, basicFileAttributes.creationTime().toMillis(), (Path)path));
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    });
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                arrayList.sort(Comparator.comparingLong(Backup::getCreationTime).reversed());
                this.backupCache = arrayList;
                return this.backupCache;
            });
        }
    }

    @Override
    public void destroy() {
        this.listBackups().whenCompleteAsync((list, throwable) -> {
            if (throwable != null) {
                throwable.printStackTrace();
            }
            list.forEach(Backup::delete);
            this.backupCache = null;
        });
    }

    @Override
    public @NonNull Path getBackupDirectory() {
        return PlayerBackupProfile.resolve(PlayerBackupProfile.resolve(PlayerBackupProfile.resolve(this.backupManager.getBackupPath(), Objects.requireNonNull(this.plot.getArea().toString(), "plot area id")), Objects.requireNonNull(this.plot.getId().toDashSeparatedString(), "plot id")), Objects.requireNonNull(this.owner.toString(), "owner"));
    }

    @Override
    public @NonNull CompletableFuture<Backup> createBackup() {
        CompletableFuture<Backup> completableFuture = new CompletableFuture<Backup>();
        this.listBackups().thenAcceptAsync(list -> {
            Object object = this.backupLock;
            synchronized (object) {
                List<Plot> list2;
                boolean bl;
                if (list.size() == this.backupManager.getBackupLimit()) {
                    ((Backup)list.get(list.size() - 1)).delete();
                }
                if (!(bl = this.schematicHandler.exportAll(list2 = Collections.singletonList(this.plot), this.getBackupDirectory().toFile(), "%world%-%id%-" + System.currentTimeMillis(), () -> completableFuture.complete(new Backup(this, System.currentTimeMillis(), null))))) {
                    completableFuture.completeExceptionally(new RuntimeException("Failed to complete the backup"));
                }
                this.backupCache = null;
            }
        });
        return completableFuture;
    }

    @Override
    public @NonNull CompletableFuture<Void> restoreBackup(@NonNull Backup backup, @Nullable PlotPlayer<?> plotPlayer) {
        final CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        if (backup.getFile() == null || !Files.exists(backup.getFile(), new LinkOption[0])) {
            completableFuture.completeExceptionally(new IllegalArgumentException("The specific backup does not exist"));
        } else {
            TaskManager.runTaskAsync(() -> {
                Schematic schematic = null;
                try {
                    schematic = this.schematicHandler.getSchematic(backup.getFile().toFile());
                }
                catch (SchematicHandler.UnsupportedFormatException unsupportedFormatException) {
                    unsupportedFormatException.printStackTrace();
                }
                if (schematic == null) {
                    completableFuture.completeExceptionally(new IllegalArgumentException("The backup is non-existent or not in the correct format"));
                } else {
                    this.schematicHandler.paste(schematic, this.plot, 0, this.plot.getArea().getMinBuildHeight(), 0, false, plotPlayer, new RunnableVal<Boolean>(){

                        @Override
                        public void run(Boolean bl) {
                            if (bl.booleanValue()) {
                                completableFuture.complete(null);
                            } else {
                                completableFuture.completeExceptionally(new RuntimeException(MINI_MESSAGE.escapeTags(TranslatableCaption.of("schematics.schematic_paste_failed").getComponent(ConsolePlayer.getConsole()))));
                            }
                        }
                    });
                }
            });
        }
        return completableFuture;
    }
}

