/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.collection;

import com.plotsquared.core.collection.RandomCollection;
import com.plotsquared.core.util.MathMan;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;

public class FlatRandomCollection<T>
extends RandomCollection<T> {
    private final T[] values;

    public FlatRandomCollection(Map<T, Double> map, Random random) {
        super(map, random);
        int n;
        int n2 = 0;
        int[] nArray = new int[map.size()];
        Double[] doubleArray = map.values().toArray(new Double[0]);
        for (n = 0; n < doubleArray.length; ++n) {
            int n3;
            nArray[n] = n3 = (int)(doubleArray[n] * 100.0);
            if ((double)n3 != doubleArray[n] * 100.0) {
                throw new IllegalArgumentException("Too small");
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        n = MathMan.gcd(nArray);
        if (n2 / n > 100000) {
            throw new IllegalArgumentException("Too large");
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Map.Entry<T, Double> entry : map.entrySet()) {
            int n4 = (int)(100.0 * entry.getValue());
            for (int i = 0; i < n4 / n; ++i) {
                arrayList.add(entry.getKey());
            }
        }
        this.values = arrayList.toArray();
    }

    @Override
    public T next() {
        return this.values[this.random.nextInt(this.values.length)];
    }
}

