/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import com.plotsquared.google.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="add", usage="/plot add <player | *>", category=CommandCategory.SETTINGS, permission="plots.add", requiredType=RequiredType.PLAYER)
public class Add
extends Command {
    private final EventDispatcher eventDispatcher;

    @Inject
    public Add(@NonNull EventDispatcher eventDispatcher) {
        super(MainCommand.getInstance(), true);
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        Plot plot = this.check(plotPlayer.getCurrentPlot(), TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
        this.checkTrue(plot.hasOwner(), TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
        this.checkTrue(plot.isOwner(plotPlayer.getUUID()) || plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_TRUST), TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
        this.checkTrue(stringArray.length == 1, TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot add <player | *>"))));
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        PlayerManager.getUUIDsFromString(stringArray[0], (collection, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof TimeoutException) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                } else {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[0]))));
                }
                completableFuture.completeExceptionally((Throwable)throwable);
                return;
            }
            try {
                this.checkTrue(!collection.isEmpty(), TranslatableCaption.of("errors.invalid_player"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[0]))));
                Iterator iterator = collection.iterator();
                int n = plot.getTrusted().size() + plot.getMembers().size();
                while (iterator.hasNext()) {
                    UUID uUID = (UUID)iterator.next();
                    if (uUID == DBFunc.EVERYONE && !plotPlayer.hasPermission(Permission.PERMISSION_TRUST_EVERYONE) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_TRUST)) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), (CompletableFuture<TagResolver>)PlotSquared.platform().playerManager().getUsernameCaption(uUID).thenApply(caption -> TagResolver.resolver("value", Tag.inserting(caption.toComponent(plotPlayer)))));
                        iterator.remove();
                        continue;
                    }
                    if (plot.isOwner(uUID)) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("member.already_added"), (CompletableFuture<TagResolver>)PlotSquared.platform().playerManager().getUsernameCaption(uUID).thenApply(caption -> TagResolver.resolver("player", Tag.inserting(caption.toComponent(plotPlayer)))));
                        iterator.remove();
                        continue;
                    }
                    if (plot.getMembers().contains(uUID)) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("member.already_added"), (CompletableFuture<TagResolver>)PlotSquared.platform().playerManager().getUsernameCaption(uUID).thenApply(caption -> TagResolver.resolver("player", Tag.inserting(caption.toComponent(plotPlayer)))));
                        iterator.remove();
                        continue;
                    }
                    n += plot.getTrusted().contains(uUID) ? 0 : 1;
                }
                this.checkTrue(!collection.isEmpty(), null, new TagResolver[0]);
                int n2 = plot.getMembers().size();
                int n3 = plotPlayer.hasPermissionRange(Permission.PERMISSION_ADD, Settings.Limit.MAX_PLOTS);
                if (n2 >= n3) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("members.plot_max_members_added"), TagResolver.resolver("amount", Tag.inserting(Component.text(n2))));
                    return;
                }
                runnableVal3.run(this, () -> {
                    for (UUID uUID : collection) {
                        if (uUID != DBFunc.EVERYONE && !plot.removeTrusted(uUID) && plot.getDenied().contains(uUID)) {
                            plot.removeDenied(uUID);
                        }
                        plot.addMember(uUID);
                        this.eventDispatcher.callMember(plotPlayer, plot, uUID, true);
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("member.member_added"), new TagResolver[0]);
                    }
                }, null);
            }
            catch (Throwable throwable2) {
                completableFuture.completeExceptionally(throwable2);
                return;
            }
            completableFuture.complete(true);
        });
        return completableFuture;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        return TabCompletions.completePlayers(plotPlayer, String.join((CharSequence)",", stringArray).trim(), Collections.emptyList());
    }
}

