/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotFlagRemoveEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.PriceFlag;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import com.plotsquared.google.Inject;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="buy", usage="/plot buy", permission="plots.buy", category=CommandCategory.CLAIMING, requiredType=RequiredType.NONE)
public class Buy
extends Command {
    private final EventDispatcher eventDispatcher;
    private final EconHandler econHandler;

    @Inject
    public Buy(@NonNull EventDispatcher eventDispatcher, @NonNull EconHandler econHandler) {
        super(MainCommand.getInstance(), true);
        this.eventDispatcher = eventDispatcher;
        this.econHandler = econHandler;
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        Plot plot;
        PlotArea plotArea = plotPlayer.getPlotAreaAbs();
        this.check(plotArea, TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
        this.check(this.econHandler.isEnabled(plotArea), TranslatableCaption.of("economy.econ_disabled"), new TagResolver[0]);
        if (stringArray.length != 0) {
            if (stringArray.length != 1) {
                this.sendUsage(plotPlayer);
                return CompletableFuture.completedFuture(false);
            }
            plot = this.check(Plot.getPlotFromString(plotPlayer, stringArray[0], true), null, new TagResolver[0]);
        } else {
            plot = this.check(plotPlayer.getCurrentPlot(), TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
        }
        this.checkTrue(plot.hasOwner(), TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
        this.checkTrue(!plot.isOwner(plotPlayer.getUUID()), TranslatableCaption.of("economy.cannot_buy_own"), new TagResolver[0]);
        Set<Plot> set = plot.getConnectedPlots();
        this.checkTrue(plotPlayer.getPlotCount() + set.size() <= plotPlayer.getAllowedPlots(), TranslatableCaption.of("permission.cant_claim_more_plots"), TagResolver.resolver("amount", Tag.inserting(Component.text(plotPlayer.getAllowedPlots()))));
        double d = (Double)plot.getFlag(PriceFlag.class);
        if (d <= 0.0) {
            throw new Command.CommandException(TranslatableCaption.of("economy.not_for_sale"), new TagResolver[0]);
        }
        this.checkTrue(this.econHandler.isSupported(), TranslatableCaption.of("economy.vault_or_consumer_null"), new TagResolver[0]);
        this.checkTrue(this.econHandler.getMoney(plotPlayer) >= d, TranslatableCaption.of("economy.cannot_afford_plot"), TagResolver.builder().tag("money", Tag.inserting(Component.text(this.econHandler.format(d)))).tag("balance", Tag.inserting(Component.text(this.econHandler.format(this.econHandler.getMoney(plotPlayer))))).build());
        this.econHandler.withdrawMoney(plotPlayer, d);
        runnableVal3.run(this, () -> {
            PriceFlag priceFlag;
            PlotFlagRemoveEvent plotFlagRemoveEvent;
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("economy.removed_balance"), TagResolver.resolver("money", Tag.inserting(Component.text(this.econHandler.format(d)))));
            this.econHandler.depositMoney(PlotSquared.platform().playerManager().getOfflinePlayer(plot.getOwnerAbs()), d);
            PlotPlayer<?> plotPlayer2 = PlotSquared.platform().playerManager().getPlayerIfExists(plot.getOwnerAbs());
            if (plotPlayer2 != null) {
                plotPlayer2.sendMessage((Caption)TranslatableCaption.of("economy.plot_sold"), TagResolver.builder().tag("plot", Tag.inserting(Component.text(plot.getId().toString()))).tag("player", Tag.inserting(Component.text(plotPlayer.getName()))).tag("price", Tag.inserting(Component.text(this.econHandler.format(d)))).build());
            }
            if ((plotFlagRemoveEvent = this.eventDispatcher.callFlagRemove(priceFlag = plot.getFlagContainer().getFlag(PriceFlag.class), plot)).getEventResult() != Result.DENY) {
                plot.removeFlag(plotFlagRemoveEvent.getFlag());
            }
            plot.setOwner(plotPlayer.getUUID());
            plot.getPlotModificationManager().setSign(plotPlayer.getName());
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("working.claimed"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.getId().toString()))));
            runnableVal2.run(this, Command.CommandResult.SUCCESS);
        }, () -> {
            this.econHandler.depositMoney(plotPlayer, d);
            runnableVal2.run(this, Command.CommandResult.FAILURE);
        });
        return CompletableFuture.completedFuture(true);
    }
}

