/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.generator.HybridPlotWorld;
import com.plotsquared.core.generator.HybridUtils;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.google.Inject;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="createroadschematic", aliases={"crs"}, category=CommandCategory.ADMINISTRATION, requiredType=RequiredType.PLAYER, permission="plots.createroadschematic", usage="/plot createroadschematic")
public class CreateRoadSchematic
extends SubCommand {
    private final HybridUtils hybridUtils;

    @Inject
    public CreateRoadSchematic(@NonNull HybridUtils hybridUtils) {
        this.hybridUtils = hybridUtils;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        Location location = plotPlayer.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (plot.getVolume() > 2.147483647E9) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
            return false;
        }
        if (!(location.getPlotArea() instanceof HybridPlotWorld)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
        }
        this.hybridUtils.setupRoadSchematic(plot);
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_road_created"), TagResolver.resolver("command", Tag.inserting(Component.text("/plot debugroadregen"))));
        return true;
    }
}

