/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.database.MySQL;
import com.plotsquared.core.database.SQLManager;
import com.plotsquared.core.database.SQLite;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.listener.PlotListener;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.FileUtils;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.google.Inject;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="database", aliases={"convert"}, category=CommandCategory.ADMINISTRATION, permission="plots.database", requiredType=RequiredType.CONSOLE, usage="/plot database [area] <sqlite | mysql | import>")
public class DatabaseCommand
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final EventDispatcher eventDispatcher;
    private final PlotListener plotListener;
    private final YamlConfiguration worldConfiguration;

    @Inject
    public DatabaseCommand(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher, @NonNull PlotListener plotListener, @WorldConfig @NonNull YamlConfiguration yamlConfiguration) {
        this.plotAreaManager = plotAreaManager;
        this.eventDispatcher = eventDispatcher;
        this.plotListener = plotListener;
        this.worldConfiguration = yamlConfiguration;
    }

    public static void insertPlots(SQLManager sQLManager, List<Plot> list, PlotPlayer<?> plotPlayer) {
        TaskManager.runTaskAsync(() -> {
            try {
                ArrayList<Plot> arrayList = new ArrayList<Plot>(list);
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("database.starting_conversion"), new TagResolver[0]);
                sQLManager.createPlotsAndData(arrayList, () -> {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("database.conversion_done"), new TagResolver[0]);
                    sQLManager.close();
                });
            }
            catch (Exception exception) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("database.conversion_failed"), new TagResolver[0]);
                exception.printStackTrace();
            }
        });
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public boolean onCommand(PlotPlayer<?> var1_1, String[] var2_2) {
        if (var2_2.length < 1) {
            var1_1.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver("value", Tag.inserting(Component.text("/plot database [area] <sqlite | mysql | import>")))});
            return false;
        }
        var4_3 = this.plotAreaManager.getPlotAreaByString(var2_2[0]);
        if (var4_3 != null) {
            var3_4 = PlotSquared.get().sortPlotsByTemp(var4_3.getPlots());
            var2_2 = Arrays.copyOfRange(var2_2, 1, var2_2.length);
        } else {
            var3_4 = PlotSquared.get().sortPlotsByTemp(PlotQuery.newQuery().allPlots().asList());
        }
        if (var2_2.length < 1) {
            var1_1.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver("value", Tag.inserting(Component.text("/plot database [area] <sqlite|mysql|import>")))});
            var1_1.sendMessage((Caption)TranslatableCaption.of("database.arg"), new TagResolver[0]);
            return false;
        }
        var6_5 = "";
        var7_6 = var2_2[0].toLowerCase();
        var8_8 = -1;
        switch (var7_6.hashCode()) {
            case -1184795739: {
                if (!var7_6.equals("import")) break;
                var8_8 = 0;
                break;
            }
            case 104382626: {
                if (!var7_6.equals("mysql")) break;
                var8_8 = 1;
                break;
            }
            case -894935028: {
                if (!var7_6.equals("sqlite")) break;
                var8_8 = 2;
            }
        }
        switch (var8_8) {
            case 0: {
                if (var2_2.length < 2) {
                    var1_1.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver("value", Tag.inserting(Component.text("/plot database import <sqlite file> [prefix]")))});
                    return false;
                }
                var9_9 = FileUtils.getFile(PlotSquared.platform().getDirectory(), (String)(var2_2[1].endsWith(".db") != false ? var2_2[1] : var2_2[1] + ".db"));
                if (!var9_9.exists()) {
                    var1_1.sendMessage((Caption)TranslatableCaption.of("database.does_not_exist"), new TagResolver[]{TagResolver.resolver("value", Tag.inserting(Component.text(var9_9.toString())))});
                    return false;
                }
                var1_1.sendMessage((Caption)TranslatableCaption.of("database.starting_conversion"), new TagResolver[0]);
                var5_12 = new SQLite(var9_9);
                var10_15 = new SQLManager(var5_12, var2_2.length == 3 ? var2_2[2] : "", this.eventDispatcher, this.plotListener, this.worldConfiguration);
                var11_17 = var10_15.getPlots();
                var3_4 = new ArrayList<Plot>();
                for (Map.Entry<String, HashMap<PlotId, Plot>> var13_21 : var11_17.entrySet()) {
                    var14_23 = var13_21.getKey();
                    var15_24 = this.plotAreaManager.getPlotAreaByString(var14_23);
                    if (var15_24 != null) {
                        for (Map.Entry var17_26 : var13_21.getValue().entrySet()) {
                            var18_27 = (Plot)var17_26.getValue();
                            if (var15_24.getOwnedPlotAbs(var18_27.getId()) != null) {
                                if (var15_24 instanceof SinglePlotArea && (var19_28 = var15_24.getNextFreePlot(null, var18_27.getId())) != null) {
                                    var20_29 = var19_28.getId();
                                    var21_30 = var18_27.getId();
                                    var22_31 = new File(PlotSquared.platform().worldContainer(), var21_30.toCommaSeparatedString());
                                    if (var22_31.exists()) {
                                        var23_32 = new File(PlotSquared.platform().worldContainer(), var20_29.toCommaSeparatedString());
                                        var22_31.renameTo(var23_32);
                                    }
                                    var18_27.setId(var20_29);
                                    var18_27.setArea(var15_24);
                                    var3_4.add(var18_27);
                                    continue;
                                }
                                var1_1.sendMessage((Caption)TranslatableCaption.of("database.skipping_duplicated_plot"), new TagResolver[]{TagResolver.builder().tag("plot", Tag.inserting(Component.text(var18_27.toString()))).tag("id", Tag.inserting(Component.text(var18_27.temp))).build()});
                                continue;
                            }
                            var18_27.setArea(var15_24);
                            var3_4.add(var18_27);
                        }
                        continue;
                    }
                    var16_25 = PlotSquared.get().plots_tmp.computeIfAbsent(var14_23, (Function<String, HashMap>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$onCommand$2(java.lang.String ), (Ljava/lang/String;)Ljava/util/HashMap;)());
                    var16_25.putAll((Map)var13_21.getValue());
                }
                DBFunc.createPlotsAndData(var3_4, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$onCommand$3(com.plotsquared.core.player.PlotPlayer ), ()V)(var1_1));
                return true;
            }
            case 1: {
                if (var2_2.length < 6) {
                    var1_1.sendMessage((Caption)StaticCaption.of("/plot database mysql [host] [port] [username] [password] [database] {prefix}"), new TagResolver[0]);
                    return false;
                }
                var9_10 = var2_2[1];
                var10_16 = var2_2[2];
                var11_18 = var2_2[3];
                var12_20 = var2_2[4];
                var13_22 = var2_2[5];
                if (var2_2.length > 6) {
                    var6_5 = var2_2[6];
                }
                var5_13 /* !! */  = new MySQL(var9_10, var10_16, var13_22, var11_18, var12_20);
                ** break;
            }
            case 2: {
                if (var2_2.length < 2) {
                    var1_1.sendMessage((Caption)StaticCaption.of("/plot database sqlite [file]"), new TagResolver[0]);
                    return false;
                }
                var9_11 = FileUtils.getFile(PlotSquared.platform().getDirectory(), var2_2[1] + ".db");
                var5_13 /* !! */  = new SQLite(var9_11);
                ** break;
            }
            default: {
                var1_1.sendMessage((Caption)StaticCaption.of("/plot database [sqlite/mysql]"), new TagResolver[0]);
                return false;
lbl99:
                // 2 sources

                break;
            }
        }
        try {
            var7_6 = new SQLManager(var5_13 /* !! */ , var6_5, this.eventDispatcher, this.plotListener, this.worldConfiguration);
            DatabaseCommand.insertPlots((SQLManager)var7_6, var3_4, var1_1);
            return true;
        }
        catch (ClassNotFoundException | SQLException var7_7) {
            try {
                var1_1.sendMessage((Caption)TranslatableCaption.of("database.failed_to_save_plots"), new TagResolver[0]);
                var1_1.sendMessage((Caption)TranslatableCaption.of("errors.stacktrace_begin"), new TagResolver[0]);
                var7_7.printStackTrace();
                var1_1.sendMessage((Caption)TranslatableCaption.of("errors.stacktrace_end"), new TagResolver[0]);
                var1_1.sendMessage((Caption)TranslatableCaption.of("database.invalid_args"), new TagResolver[0]);
                return false;
            }
            catch (ClassNotFoundException | SQLException var5_14) {
                var1_1.sendMessage((Caption)TranslatableCaption.of("database.failed_to_open"), new TagResolver[0]);
                var1_1.sendMessage((Caption)TranslatableCaption.of("errors.stacktrace_begin"), new TagResolver[0]);
                var5_14.printStackTrace();
                var1_1.sendMessage((Caption)TranslatableCaption.of("errors.stacktrace_end"), new TagResolver[0]);
                var1_1.sendMessage((Caption)TranslatableCaption.of("database.invalid_args"), new TagResolver[0]);
                return false;
            }
        }
    }

    private static /* synthetic */ void lambda$onCommand$3(PlotPlayer plotPlayer) {
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("database.conversion_done"), new TagResolver[0]);
    }

    private static /* synthetic */ HashMap lambda$onCommand$2(String string) {
        return new HashMap();
    }
}

