/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.Storage;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.inject.annotations.ConfigFile;
import com.plotsquared.core.inject.annotations.WorldFile;
import com.plotsquared.core.paster.IncendoPaster;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.util.PremiumVerification;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.google.Inject;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Files;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="debugpaste", aliases={"dp"}, usage="/plot debugpaste", permission="plots.debugpaste", category=CommandCategory.DEBUG, confirmation=true, requiredType=RequiredType.NONE)
public class DebugPaste
extends SubCommand {
    private final File configFile;
    private final File worldfile;

    @Inject
    public DebugPaste(@ConfigFile @NonNull File file, @WorldFile @NonNull File file2) {
        this.configFile = file;
        this.worldfile = file2;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        TaskManager.runTaskAsync(() -> {
            block14: {
                try {
                    Object object;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("# Welcome to this paste\n# It is meant to provide us at IntellectualSites with better information about your problem\n");
                    stringBuilder.append("# PlotSquared Information\n");
                    stringBuilder.append("PlotSquared Version: ").append(PlotSquared.get().getVersion()).append("\n");
                    stringBuilder.append("Database Type: ").append(Storage.MySQL.USE ? "MySQL" : "SQLite").append("\n");
                    stringBuilder.append("Resource ID: ").append(PremiumVerification.getResourceID()).append("\n");
                    stringBuilder.append("Download ID: ").append(PremiumVerification.getDownloadID()).append("\n");
                    stringBuilder.append("This PlotSquared version is licensed to the spigot user ").append(PremiumVerification.getUserID()).append("\n\n");
                    stringBuilder.append("# WorldEdit implementation:\n");
                    stringBuilder.append(PlotSquared.platform().worldEditImplementations()).append("\n\n");
                    stringBuilder.append("# Server Information\n");
                    stringBuilder.append("Server Version: ").append(PlotSquared.platform().serverImplementation()).append("\n");
                    stringBuilder.append("online_mode: ").append(!Settings.UUID.OFFLINE).append(';').append(!Settings.UUID.OFFLINE).append('\n');
                    stringBuilder.append(PlotSquared.platform().pluginsFormatted());
                    stringBuilder.append("\n\n# YAY! Now, let's see what we can find in your JVM\n");
                    Runtime runtime = Runtime.getRuntime();
                    RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
                    stringBuilder.append("Uptime: ").append(TimeUnit.MINUTES.convert(runtimeMXBean.getUptime(), TimeUnit.MILLISECONDS)).append(" minutes").append('\n');
                    stringBuilder.append("JVM Flags: ").append(runtimeMXBean.getInputArguments()).append('\n');
                    stringBuilder.append("Free Memory: ").append(runtime.freeMemory() / 1024L / 1024L).append(" MB").append('\n');
                    stringBuilder.append("Max Memory: ").append(runtime.maxMemory() / 1024L / 1024L).append(" MB").append('\n');
                    stringBuilder.append("Total Memory: ").append(runtime.totalMemory() / 1024L / 1024L).append(" MB").append('\n');
                    stringBuilder.append("Available Processors: ").append(runtime.availableProcessors()).append('\n');
                    stringBuilder.append("Java Name: ").append(runtimeMXBean.getVmName()).append('\n');
                    stringBuilder.append("Java Version: '").append(System.getProperty("java.version")).append("'\n");
                    stringBuilder.append("Java Vendor: '").append(System.getProperty("java.vendor")).append("'\n");
                    stringBuilder.append("Operating System: '").append(System.getProperty("os.name")).append("'\n");
                    stringBuilder.append("OS Version: ").append(System.getProperty("os.version")).append('\n');
                    stringBuilder.append("OS Arch: ").append(System.getProperty("os.arch")).append('\n');
                    stringBuilder.append("# Okay :D Great. You are now ready to create your bug report!");
                    stringBuilder.append("\n# You can do so at https://github.com/IntellectualSites/PlotSquared/issues");
                    stringBuilder.append("\n# or via our Discord at https://discord.gg/intellectualsites");
                    IncendoPaster incendoPaster = new IncendoPaster("plotsquared");
                    incendoPaster.addFile(new IncendoPaster.PasteFile("information", stringBuilder.toString()));
                    try {
                        object = new File("logs/latest.log");
                        if (Files.size(((File)object).toPath()) > 14000000L) {
                            throw new IOException("The latest.log is larger than 14MB. Please reboot your server and submit a new paste.");
                        }
                        incendoPaster.addFile((File)object);
                    }
                    catch (IOException iOException) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugpaste.latest_log"), TagResolver.builder().tag("file", Tag.inserting(Component.text("latest.log"))).tag("size", Tag.inserting(Component.text("14MB"))).build());
                    }
                    try {
                        incendoPaster.addFile(this.configFile);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugpaste.empty_file"), TagResolver.resolver("file", Tag.inserting(Component.text("settings.yml"))));
                    }
                    try {
                        incendoPaster.addFile(this.worldfile);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugpaste.empty_file"), TagResolver.resolver("file", Tag.inserting(Component.text("worlds.yml"))));
                    }
                    try {
                        object = new File(PlotSquared.platform().getDirectory(), "../Multiverse-Core/worlds.yml");
                        incendoPaster.addFile((File)object, "Multiverse-Core/worlds.yml");
                    }
                    catch (IOException iOException) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugpaste.skip_multiverse"), TagResolver.resolver("file", Tag.inserting(Component.text("worlds.yml"))));
                    }
                    try {
                        object = incendoPaster.upload();
                        JsonObject jsonObject = new JsonParser().parse((String)object).getAsJsonObject();
                        if (jsonObject.has("created")) {
                            String string = jsonObject.get("paste_id").getAsString();
                            String string2 = String.format("https://athion.net/ISPaster/paste/view/%s", string);
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugpaste.debug_report_created"), TagResolver.resolver("url", Tag.preProcessParsed(string2)));
                            break block14;
                        }
                        String string = jsonObject.get("response").getAsString();
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugpaste.creation_failed"), TagResolver.resolver("value", Tag.inserting(Component.text(string))));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugpaste.creation_failed"), TagResolver.resolver("value", Tag.inserting(Component.text(throwable.getMessage()))));
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
        return true;
    }
}

