/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.generator.HybridPlotManager;
import com.plotsquared.core.generator.HybridUtils;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.google.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="debugroadregen", usage="/plot debugroadregen <plot | region [height]>", requiredType=RequiredType.NONE, category=CommandCategory.DEBUG, permission="plots.debugroadregen")
public class DebugRoadRegen
extends SubCommand {
    public static final String USAGE = "/plot debugroadregen <plot | region [height]>";
    private final HybridUtils hybridUtils;

    @Inject
    public DebugRoadRegen(@NonNull HybridUtils hybridUtils) {
        this.hybridUtils = hybridUtils;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        String string;
        Location location = plotPlayer.getLocation();
        Plot plot = location.getPlotAbs();
        if (stringArray.length < 1) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text(USAGE))));
            return false;
        }
        PlotArea plotArea = plotPlayer.getPlotAreaAbs();
        this.check(plotArea, TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
        if (plot.getVolume() > 2.147483647E9) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
            return false;
        }
        switch (string = stringArray[0].toLowerCase()) {
            case "plot": {
                return this.regenPlot(plotPlayer);
            }
            case "region": {
                return this.regenRegion(plotPlayer, Arrays.copyOfRange(stringArray, 1, stringArray.length));
            }
        }
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text(USAGE))));
        return false;
    }

    public boolean regenPlot(PlotPlayer<?> plotPlayer) {
        Location location = plotPlayer.getLocation();
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
            return false;
        }
        Plot plot = plotPlayer.getCurrentPlot();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
        } else if (plot.isMerged()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("debug.requires_unmerged"), new TagResolver[0]);
        } else {
            PlotManager plotManager = plotArea.getPlotManager();
            QueueCoordinator queueCoordinator = plotArea.getQueue();
            queueCoordinator.setCompleteTask(() -> {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugroadregen.regen_done"), TagResolver.resolver("value", Tag.inserting(Component.text(plot.getId().toString()))));
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugroadregen.regen_all"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot regenallroads"))));
            });
            plotManager.createRoadEast(plot, queueCoordinator);
            plotManager.createRoadSouth(plot, queueCoordinator);
            plotManager.createRoadSouthEast(plot, queueCoordinator);
            queueCoordinator.enqueue();
        }
        return true;
    }

    public boolean regenRegion(PlotPlayer<?> plotPlayer, String[] stringArray) {
        int n = 0;
        if (stringArray.length == 1) {
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.not_valid_number"), TagResolver.resolver("value", Tag.inserting(Component.text("0, 256"))));
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text(USAGE))));
                return false;
            }
        } else if (stringArray.length != 0) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text(USAGE))));
            return false;
        }
        Location location = plotPlayer.getLocation();
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
        }
        Plot plot = plotPlayer.getCurrentPlot();
        PlotManager plotManager = plotArea.getPlotManager();
        if (!(plotManager instanceof HybridPlotManager)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_plot_world"), new TagResolver[0]);
            return true;
        }
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugroadregen.schematic"), TagResolver.resolver("command", Tag.inserting(Component.text("/plot createroadschematic"))));
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugroadregen.regenallroads"), TagResolver.resolver("command", Tag.inserting(Component.text("/plot regenallroads"))));
        boolean bl = this.hybridUtils.scheduleSingleRegionRoadUpdate(plot, n);
        if (!bl) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugexec.mass_schematic_update_in_progress"), new TagResolver[0]);
            return false;
        }
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        return Stream.of("plot", "region").filter(string -> string.startsWith(stringArray[0].toLowerCase(Locale.ENGLISH))).map(string -> new Command(null, false, (String)string, "plots.debugroadregen", RequiredType.NONE, null){}).collect(Collectors.toList());
    }
}

