/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.query.SortingStrategy;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import com.plotsquared.google.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="home", permission="plots.home", usage="/plot home [<page> | <alias> | <area;x;y> | <area> <x;y> | <area> <page>]", aliases={"h"}, requiredType=RequiredType.PLAYER, category=CommandCategory.TELEPORT)
public class HomeCommand
extends Command {
    private final PlotAreaManager plotAreaManager;

    @Inject
    public HomeCommand(@NonNull PlotAreaManager plotAreaManager) {
        super(MainCommand.getInstance(), true);
        this.plotAreaManager = plotAreaManager;
    }

    private void home(@NonNull PlotPlayer<?> plotPlayer, @NonNull PlotQuery plotQuery, int n, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        List<Plot> list = plotQuery.asList();
        if (list.isEmpty()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.found_no_plots"), new TagResolver[0]);
            return;
        }
        if (list.size() < n || n < 1) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.number_not_in_range"), TagResolver.builder().tag("min", Tag.inserting(Component.text(1))).tag("max", Tag.inserting(Component.text(list.size()))).build());
            return;
        }
        Plot plot = list.get(n - 1);
        runnableVal3.run(this, () -> plot.teleportPlayer(plotPlayer, TeleportCause.COMMAND_HOME, bl -> {
            if (bl.booleanValue()) {
                runnableVal2.run(this, Command.CommandResult.SUCCESS);
            } else {
                runnableVal2.run(this, Command.CommandResult.FAILURE);
            }
        }), () -> runnableVal2.run(this, Command.CommandResult.FAILURE));
    }

    private @NonNull PlotQuery query(@NonNull PlotPlayer<?> plotPlayer) {
        return PlotQuery.newQuery().thatPasses(plot -> plot.isOwner(plotPlayer.getUUID()));
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        if (!plotPlayer.hasPermission(Permission.PERMISSION_VISIT_OWNED) && !plotPlayer.hasPermission(Permission.PERMISSION_HOME)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text(Permission.PERMISSION_VISIT_OWNED.toString()))));
            return CompletableFuture.completedFuture(false);
        }
        if (stringArray.length > 2) {
            this.sendUsage(plotPlayer);
            return CompletableFuture.completedFuture(false);
        }
        PlotQuery plotQuery = this.query(plotPlayer);
        int n = 1;
        boolean bl = true;
        switch (stringArray.length) {
            case 1: {
                String string = stringArray[0];
                if (MathMan.isInteger(string)) {
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.not_a_number"), TagResolver.resolver("value", Tag.inserting(Component.text(string))));
                        return CompletableFuture.completedFuture(false);
                    }
                    this.sortBySettings(plotQuery, plotPlayer);
                    break;
                }
                Plot plot = Plot.getPlotFromString(plotPlayer, string, false);
                if (plot != null && plot.isOwner(plotPlayer.getUUID())) {
                    bl = false;
                    plotQuery.withPlot(plot);
                    break;
                }
                PlotArea plotArea = this.plotAreaManager.getPlotAreaByString(stringArray[0]);
                if (plotArea != null) {
                    plotQuery.inArea(plotArea);
                    break;
                }
                plotQuery.withAlias(string);
                break;
            }
            case 2: {
                PlotArea plotArea = this.plotAreaManager.getPlotAreaByString(stringArray[0]);
                String string = stringArray[1];
                if (plotArea == null) {
                    plotQuery.noPlots();
                    break;
                }
                plotQuery.inArea(plotArea);
                if (MathMan.isInteger(string)) {
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.not_a_number"), TagResolver.resolver("value", Tag.inserting(Component.text(string))));
                        return CompletableFuture.completedFuture(false);
                    }
                    plotQuery.withSortingStrategy(SortingStrategy.SORT_BY_CREATION);
                    break;
                }
                PlotId plotId = PlotId.fromStringOrNull(string);
                if (plotId == null) {
                    plotQuery.noPlots();
                    break;
                }
                Plot plot = plotArea.getPlot(plotId);
                if (plot == null) {
                    plotQuery.noPlots();
                    break;
                }
                bl = false;
                plotQuery.withPlot(plot);
                break;
            }
            case 0: {
                this.sortBySettings(plotQuery, plotPlayer);
            }
        }
        if (bl) {
            plotQuery.whereBasePlot();
        }
        this.home(plotPlayer, plotQuery, n, runnableVal3, runnableVal2);
        return CompletableFuture.completedFuture(true);
    }

    private void sortBySettings(PlotQuery plotQuery, PlotPlayer<?> plotPlayer) {
        PlotArea plotArea = plotPlayer.getApplicablePlotArea();
        if (Settings.Teleport.PER_WORLD_VISIT && plotArea != null) {
            plotQuery.relativeToArea(plotArea).withSortingStrategy(SortingStrategy.SORT_BY_CREATION);
        } else {
            plotQuery.withSortingStrategy(SortingStrategy.SORT_BY_TEMP);
        }
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        switch (stringArray.length - 1) {
            case 0: {
                arrayList.addAll(TabCompletions.completeAreas(stringArray[0]));
                if (stringArray[0].isEmpty()) {
                    arrayList.addAll(TabCompletions.asCompletions("1", "2", "3"));
                    break;
                }
                arrayList.addAll(TabCompletions.completeNumbers(stringArray[0], 10, 999));
                break;
            }
            case 1: {
                arrayList.addAll(TabCompletions.completeNumbers(stringArray[1], 10, 999));
            }
        }
        return arrayList;
    }
}

