/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.implementations.HideInfoFlag;
import com.plotsquared.core.util.TabCompletions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

@CommandDeclaration(command="info", aliases={"i"}, usage="/plot info <id> [-f to force info]", category=CommandCategory.INFO)
public class Info
extends SubCommand {
    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        boolean bl;
        Plot plot;
        String string;
        if (stringArray.length > 0) {
            switch (string = stringArray[0]) {
                case "trusted": 
                case "alias": 
                case "biome": 
                case "denied": 
                case "flags": 
                case "id": 
                case "size": 
                case "members": 
                case "creationdate": 
                case "seen": 
                case "owner": 
                case "rating": 
                case "likes": {
                    plot = Plot.getPlotFromString(plotPlayer, null, false);
                    break;
                }
                default: {
                    plot = Plot.getPlotFromString(plotPlayer, string, false);
                    string = stringArray.length == 2 ? stringArray[1] : null;
                }
            }
            if (plot == null) {
                plot = plotPlayer.getCurrentPlot();
            }
        } else {
            string = null;
            plot = plotPlayer.getCurrentPlot();
        }
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (string != null) {
            stringArray = stringArray.length == 1 ? new String[]{} : new String[]{stringArray[1]};
        }
        if (((Boolean)plot.getFlag(HideInfoFlag.class)).booleanValue()) {
            boolean bl2 = false;
            for (String string2 : stringArray) {
                if (!string2.equalsIgnoreCase("-f")) continue;
                if (!plotPlayer.hasPermission(Permission.PERMISSION_AREA_INFO_FORCE.toString())) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_AREA_INFO_FORCE)));
                    return true;
                }
                bl2 = true;
                break;
            }
            if (!bl2) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("info.plot_info_hidden"), new TagResolver[0]);
                return true;
            }
        }
        boolean bl3 = plot.hasOwner();
        boolean bl4 = plot.getTrusted().contains(DBFunc.EVERYONE);
        int n = plot.getMembers().contains(DBFunc.EVERYONE) ? 1 : 0;
        if (!bl3 && !bl4 && n == 0) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("info.plot_info_unclaimed"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.getId().getX() + ";" + plot.getId().getY()))));
            return true;
        }
        Caption caption2 = TranslatableCaption.of("info.plot_info_format");
        if (string != null) {
            caption2 = this.getCaption(string);
            if (caption2 == null) {
                if (Settings.Ratings.USE_LIKES) {
                    plotPlayer.sendMessage((Caption)StaticCaption.of("&6Categories&7: &amembers&7, &aalias&7, &abiome&7, &aseen&7, &adenied&7, &aflags&7, &aid&7, &asize&7, &atrusted&7, &aowner&7,  &alikes"), new TagResolver[0]);
                } else {
                    plotPlayer.sendMessage((Caption)StaticCaption.of("&6Categories&7: &amembers&7, &aalias&7, &abiome&7, &aseen&7, &adenied&7, &aflags&7, &aid&7, &asize&7, &atrusted&7, &aowner&7,  &arating"), new TagResolver[0]);
                }
                return false;
            }
            bl = true;
        } else {
            bl = false;
        }
        plot.format(caption2, plotPlayer, bl).thenAcceptAsync(caption -> plotPlayer.sendMessage((Caption)caption, new TagResolver[0]));
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (plotPlayer.hasPermission(Permission.PERMISSION_AREA_INFO_FORCE)) {
            linkedList.add("-f");
        }
        List list = linkedList.stream().filter(string -> string.toLowerCase().startsWith(stringArray[0].toLowerCase())).map(string -> new Command(null, true, (String)string, "", RequiredType.PLAYER, CommandCategory.INFO){}).collect(Collectors.toCollection(LinkedList::new));
        if (plotPlayer.hasPermission(Permission.PERMISSION_AREA_INFO_FORCE) && stringArray[0].length() > 0) {
            list.addAll(TabCompletions.completePlayers(plotPlayer, stringArray[0], Collections.emptyList()));
        }
        return list;
    }

    private Caption getCaption(String string) {
        return switch (string) {
            case "trusted" -> TranslatableCaption.of("info.plot_info_trusted");
            case "alias" -> TranslatableCaption.of("info.plot_info_alias");
            case "biome" -> TranslatableCaption.of("info.plot_info_biome");
            case "denied" -> TranslatableCaption.of("info.plot_info_denied");
            case "flags" -> TranslatableCaption.of("info.plot_info_flags");
            case "id" -> TranslatableCaption.of("info.plot_info_id");
            case "size" -> TranslatableCaption.of("info.plot_info_size");
            case "members" -> TranslatableCaption.of("info.plot_info_members");
            case "owner" -> TranslatableCaption.of("info.plot_info_owner");
            case "rating" -> TranslatableCaption.of("info.plot_info_rating");
            case "likes" -> TranslatableCaption.of("info.plot_info_likes");
            case "seen" -> TranslatableCaption.of("info.plot_info_seen");
            case "creationdate" -> TranslatableCaption.of("info.plot_info_creationdate");
            default -> null;
        };
    }
}

