/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import com.plotsquared.google.Inject;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="leave", permission="plots.leave", usage="/plot leave", category=CommandCategory.CLAIMING, requiredType=RequiredType.PLAYER)
public class Leave
extends Command {
    private final EventDispatcher eventDispatcher;

    @Inject
    public Leave(@NonNull EventDispatcher eventDispatcher) {
        super(MainCommand.getInstance(), true);
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        Plot plot = this.check(plotPlayer.getCurrentPlot(), TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
        this.checkTrue(plot.hasOwner(), TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
        if (plot.isOwner(plotPlayer.getUUID())) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("member.plot_cant_leave_owner"), new TagResolver[0]);
        } else {
            UUID uUID = plotPlayer.getUUID();
            if (plot.isAdded(uUID)) {
                if (plot.removeTrusted(uUID)) {
                    this.eventDispatcher.callTrusted(plotPlayer, plot, uUID, false);
                }
                if (plot.removeMember(uUID)) {
                    this.eventDispatcher.callMember(plotPlayer, plot, uUID, false);
                }
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("member.plot_left"), TagResolver.resolver("player", Tag.inserting(Component.text(plotPlayer.getName()))));
            } else {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("members.not_added_trusted"), new TagResolver[0]);
            }
        }
        return CompletableFuture.completedFuture(true);
    }
}

