/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.annotation.Nullable;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotFlagAddEvent;
import com.plotsquared.core.events.PlotFlagRemoveEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotInventory;
import com.plotsquared.core.plot.PlotItemStack;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.MusicFlag;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.InventoryUtil;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="music", permission="plots.music", usage="/plot music", category=CommandCategory.APPEARANCE, requiredType=RequiredType.PLAYER)
public class Music
extends SubCommand {
    private static final Collection<String> DISCS = Arrays.asList("music_disc_13", "music_disc_cat", "music_disc_blocks", "music_disc_chirp", "music_disc_far", "music_disc_mall", "music_disc_mellohi", "music_disc_stal", "music_disc_strad", "music_disc_ward", "music_disc_11", "music_disc_wait", "music_disc_otherside", "music_disc_pigstep", "music_disc_5", "music_disc_relic");
    private final InventoryUtil inventoryUtil;
    private final EventDispatcher eventDispatcher;

    @Inject
    public Music(@Nullable InventoryUtil inventoryUtil, @NonNull EventDispatcher eventDispatcher) {
        this.inventoryUtil = inventoryUtil;
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        Location location = plotPlayer.getLocation();
        final Plot plot = location.getPlotAbs();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
            return false;
        }
        if (!plot.isAdded(plotPlayer.getUUID()) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_MUSIC_OTHER)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_ADMIN_MUSIC_OTHER)));
            return true;
        }
        PlotInventory plotInventory = new PlotInventory(this.inventoryUtil, plotPlayer, 2, TranslatableCaption.of("plotjukebox.jukebox_header").getComponent(plotPlayer)){

            @Override
            public boolean onClick(int n) {
                PlotItemStack plotItemStack = this.getItem(n);
                if (plotItemStack == null) {
                    return true;
                }
                if (plotItemStack.getType() == ItemTypes.BEDROCK) {
                    Object f = plot.getFlagContainer().getFlag(MusicFlag.class).createFlagInstance(plotItemStack.getType());
                    PlotFlagRemoveEvent plotFlagRemoveEvent = Music.this.eventDispatcher.callFlagRemove((PlotFlag<?, ?>)f, plot);
                    if (plotFlagRemoveEvent.getEventResult() == Result.DENY) {
                        this.getPlayer().sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Music removal"))));
                        return true;
                    }
                    plot.removeFlag(plotFlagRemoveEvent.getFlag());
                    this.getPlayer().sendMessage((Caption)TranslatableCaption.of("flag.flag_removed"), TagResolver.builder().tag("flag", Tag.inserting(Component.text("music"))).tag("value", Tag.inserting(Component.text("music_disc"))).build());
                } else if (plotItemStack.getName().toLowerCase(Locale.ENGLISH).contains("disc")) {
                    Object f = plot.getFlagContainer().getFlag(MusicFlag.class).createFlagInstance(plotItemStack.getType());
                    PlotFlagAddEvent plotFlagAddEvent = Music.this.eventDispatcher.callFlagAdd((PlotFlag<?, ?>)f, plot);
                    if (plotFlagAddEvent.getEventResult() == Result.DENY) {
                        this.getPlayer().sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Music addition"))));
                        return true;
                    }
                    plot.setFlag(plotFlagAddEvent.getFlag());
                    this.getPlayer().sendMessage((Caption)TranslatableCaption.of("flag.flag_added"), TagResolver.builder().tag("flag", Tag.inserting(Component.text("music"))).tag("value", Tag.inserting(Component.text(plotFlagAddEvent.getFlag().getValue().toString()))).build());
                } else {
                    this.getPlayer().sendMessage((Caption)TranslatableCaption.of("flag.flag_not_added"), new TagResolver[0]);
                }
                return false;
            }
        };
        int n = 0;
        for (String stringArray22 : DISCS) {
            PlotItemStack plotItemStack;
            String string = String.format("<gold>%s</gold>", stringArray22);
            String[] stringArray2 = new String[]{TranslatableCaption.of("plotjukebox.click_to_play").getComponent(plotPlayer)};
            ItemType itemType = ItemTypes.get((String)stringArray22);
            if (itemType == null || !plotInventory.setItemChecked(n, plotItemStack = new PlotItemStack(itemType, 1, string, stringArray2))) continue;
            ++n;
        }
        String string = TranslatableCaption.of("plotjukebox.cancel_music").getComponent(plotPlayer);
        String[] stringArray3 = new String[]{TranslatableCaption.of("plotjukebox.reset_music").getComponent(plotPlayer)};
        plotInventory.setItem(n, new PlotItemStack("bedrock", 1, string, stringArray3));
        plotInventory.openInventory();
        return true;
    }
}

