/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.query.PlotQuery;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@CommandDeclaration(command="target", usage="/plot target <<X;Z> | nearest>", permission="plots.target", requiredType=RequiredType.PLAYER, category=CommandCategory.INFO)
public class Target
extends SubCommand {
    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        Location location = plotPlayer.getLocation();
        if (!location.isPlotArea()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
            return false;
        }
        if (stringArray.length == 0) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot target <<X;Z> | nearest>"))));
            return false;
        }
        Plot plot = null;
        if (StringMan.isEqualIgnoreCaseToAny(stringArray[0], "near", "nearest")) {
            int n = Integer.MAX_VALUE;
            for (Plot plot2 : PlotQuery.newQuery().inWorld(location.getWorldName())) {
                double d = plot2.getCenterSynchronous().getEuclideanDistanceSquared(location);
                if (!(d < (double)n)) continue;
                n = (int)d;
                plot = plot2;
            }
            if (plot == null) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.found_no_plots"), new TagResolver[0]);
                return false;
            }
        } else {
            plot = Plot.getPlotFromString(plotPlayer, stringArray[0], true);
            if (plot == null) {
                return false;
            }
        }
        plot.getCenter(plotPlayer::setCompassTarget);
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("compass.compass_target"), TagResolver.resolver("target", Tag.inserting(Component.text(plot.toString()))));
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        return Stream.of("<X;Z>", "nearest").filter(string -> string.startsWith(stringArray[0].toLowerCase(Locale.ENGLISH))).map(string -> new Command(null, false, (String)string, "plots.target", RequiredType.PLAYER, null){}).collect(Collectors.toList());
    }
}

