/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.ConfigurationNode;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.ConfigurationUtil;
import com.plotsquared.core.configuration.InvalidConfigurationException;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.inject.annotations.WorldFile;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.setup.PlotAreaBuilder;
import com.plotsquared.core.setup.SettingsNodesWrapper;
import com.plotsquared.core.util.FileBytes;
import com.plotsquared.core.util.FileUtils;
import com.plotsquared.core.util.SetupUtils;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.google.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="template", permission="plots.admin", usage="/plot template [import | export] <world> <template>", category=CommandCategory.ADMINISTRATION)
public class Template
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final YamlConfiguration worldConfiguration;
    private final File worldFile;
    private final SetupUtils setupUtils;
    private final WorldUtil worldUtil;

    @Inject
    public Template(@NonNull PlotAreaManager plotAreaManager, @WorldConfig @NonNull YamlConfiguration yamlConfiguration, @WorldFile @NonNull File file, @NonNull SetupUtils setupUtils, @NonNull WorldUtil worldUtil) {
        this.plotAreaManager = plotAreaManager;
        this.worldConfiguration = yamlConfiguration;
        this.worldFile = file;
        this.setupUtils = setupUtils;
        this.worldUtil = worldUtil;
    }

    public static boolean extractAllFiles(String string, String string2) {
        try {
            File file = FileUtils.getFile(PlotSquared.platform().getDirectory(), Settings.Paths.TEMPLATES);
            if (!file.exists()) {
                return false;
            }
            File file2 = PlotSquared.platform().getDirectory();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            File file3 = new File(file + File.separator + string2 + ".template");
            try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file3));){
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                byte[] byArray = new byte[2048];
                while (zipEntry != null) {
                    if (!zipEntry.isDirectory()) {
                        String string3 = zipEntry.getName().replace('\\', File.separatorChar).replace('/', File.separatorChar);
                        File file4 = new File((file2 + File.separator + string3).replaceAll("__TEMP_DIR__", string));
                        File file5 = file4.getParentFile();
                        if (file5 != null) {
                            file5.mkdirs();
                        }
                        try (FileOutputStream fileOutputStream = new FileOutputStream(file4);){
                            int n;
                            while ((n = zipInputStream.read(byArray)) > 0) {
                                fileOutputStream.write(byArray, 0, n);
                            }
                        }
                    }
                    zipEntry = zipInputStream.getNextEntry();
                }
                zipInputStream.closeEntry();
            }
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public static byte[] getBytes(PlotArea plotArea) {
        ConfigurationSection configurationSection = PlotSquared.get().getWorldConfiguration().getConfigurationSection("worlds." + plotArea.getWorldName());
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        String string = PlotSquared.platform().setupUtils().getGenerator(plotArea);
        if (string != null) {
            yamlConfiguration.set("generator.plugin", string);
        }
        for (String string2 : configurationSection.getKeys(true)) {
            yamlConfiguration.set(string2, configurationSection.get(string2));
        }
        return yamlConfiguration.saveToString().getBytes();
    }

    public static void zipAll(String string, Set<FileBytes> set) {
        File file = FileUtils.getFile(PlotSquared.platform().getDirectory(), Settings.Paths.TEMPLATES);
        file.mkdirs();
        try (FileOutputStream fileOutputStream = new FileOutputStream(file + File.separator + string + ".template");
             ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);){
            for (FileBytes fileBytes : set) {
                ZipEntry zipEntry = new ZipEntry(fileBytes.path());
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.write(fileBytes.data());
            }
            zipOutputStream.closeEntry();
        }
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        if (stringArray.length != 2 && stringArray.length != 3) {
            if (stringArray.length == 1) {
                if (stringArray[0].equalsIgnoreCase("export")) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot template export <world>"))));
                    return true;
                }
                if (stringArray[0].equalsIgnoreCase("import")) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot template import <world> <template>"))));
                    return true;
                }
            }
            this.sendUsage(plotPlayer);
            return true;
        }
        String string = stringArray[1];
        switch (stringArray[0].toLowerCase()) {
            case "import": {
                if (stringArray.length != 3) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot template import <world> <template>"))));
                    return false;
                }
                if (this.plotAreaManager.hasPlotArea(string)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_world_taken"), TagResolver.resolver("value", Tag.inserting(Component.text(string))));
                    return false;
                }
                boolean bl = Template.extractAllFiles(string, stringArray[2]);
                if (!bl) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("template.invalid_template"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[2]))));
                    return false;
                }
                File file = FileUtils.getFile(PlotSquared.platform().getDirectory(), Settings.Paths.TEMPLATES + File.separator + "tmp-data.yml");
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration(file);
                this.worldConfiguration.set("worlds." + string, yamlConfiguration.get(""));
                try {
                    this.worldConfiguration.save(this.worldFile);
                    this.worldConfiguration.load(this.worldFile);
                }
                catch (InvalidConfigurationException | IOException exception) {
                    exception.printStackTrace();
                }
                String string2 = yamlConfiguration.getString("generator.plugin", PlotSquared.platform().pluginName());
                String string3 = yamlConfiguration.getString("generator.init", string2);
                PlotAreaBuilder plotAreaBuilder = PlotAreaBuilder.newBuilder().plotAreaType(ConfigurationUtil.getType(yamlConfiguration)).terrainType(ConfigurationUtil.getTerrain(yamlConfiguration)).plotManager(string2).generatorName(string3).settingsNodesWrapper(new SettingsNodesWrapper(new ConfigurationNode[0], null)).worldName(string);
                this.setupUtils.setupWorld(plotAreaBuilder);
                TaskManager.runTask(() -> {
                    plotPlayer.teleport(this.worldUtil.getSpawn(string), TeleportCause.COMMAND_TEMPLATE);
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_finished"), new TagResolver[0]);
                });
                return true;
            }
            case "export": {
                if (stringArray.length != 2) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot template export <world>"))));
                    return false;
                }
                PlotArea plotArea = this.plotAreaManager.getPlotAreaByString(string);
                if (plotArea == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_valid_plot_world"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[1]))));
                    return false;
                }
                PlotManager plotManager = plotArea.getPlotManager();
                TaskManager.runTaskAsync(() -> {
                    try {
                        plotManager.exportTemplate();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("template.template_failed"), TagResolver.resolver("value", Tag.inserting(Component.text(exception.getMessage()))));
                        return;
                    }
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_finished"), new TagResolver[0]);
                });
                return true;
            }
        }
        this.sendUsage(plotPlayer);
        return false;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        if (stringArray.length == 1) {
            LinkedList<String> linkedList = new LinkedList<String>();
            if (plotPlayer.hasPermission(Permission.PERMISSION_TEMPLATE_EXPORT)) {
                linkedList.add("export");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_TEMPLATE_IMPORT)) {
                linkedList.add("import");
            }
            List list = linkedList.stream().filter(string -> string.toLowerCase().startsWith(stringArray[0].toLowerCase())).map(string -> new Command(null, true, (String)string, "", RequiredType.NONE, CommandCategory.ADMINISTRATION){}).collect(Collectors.toCollection(LinkedList::new));
            if (plotPlayer.hasPermission(Permission.PERMISSION_TEMPLATE) && stringArray[0].length() > 0) {
                list.addAll(TabCompletions.completePlayers(plotPlayer, stringArray[0], Collections.emptyList()));
            }
            return list;
        }
        return TabCompletions.completePlayers(plotPlayer, String.join((CharSequence)",", stringArray).trim(), Collections.emptyList());
    }
}

