/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.RegionManager;
import com.plotsquared.core.util.RegionUtil;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="trim", permission="plots.admin", usage="/plot trim <world> [regenerate]", requiredType=RequiredType.CONSOLE, category=CommandCategory.ADMINISTRATION)
public class Trim
extends SubCommand {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + Trim.class.getSimpleName()));
    private static volatile boolean TASK = false;
    private final PlotAreaManager plotAreaManager;
    private final WorldUtil worldUtil;
    private final GlobalBlockQueue blockQueue;
    private final RegionManager regionManager;

    @Inject
    public Trim(@NonNull PlotAreaManager plotAreaManager, @NonNull WorldUtil worldUtil, @NonNull GlobalBlockQueue globalBlockQueue, @NonNull RegionManager regionManager) {
        this.plotAreaManager = plotAreaManager;
        this.worldUtil = worldUtil;
        this.blockQueue = globalBlockQueue;
        this.regionManager = regionManager;
    }

    public static boolean getTrimRegions(String string, final RunnableVal2<Set<BlockVector2>, Set<BlockVector2>> runnableVal2) {
        if (runnableVal2 == null) {
            return false;
        }
        TranslatableCaption.of("trim.trim_starting");
        List<Plot> list = PlotQuery.newQuery().inWorld(string).asList();
        if (PlotSquared.platform().expireManager() != null) {
            list.removeAll(PlotSquared.platform().expireManager().getPendingExpired());
        }
        runnableVal2.value1 = new HashSet<BlockVector2>(PlotSquared.platform().worldUtil().getChunkChunks(string));
        runnableVal2.value2 = new HashSet();
        StaticCaption.of(" - MCA #: " + ((Set)runnableVal2.value1).size());
        StaticCaption.of(" - CHUNKS: " + ((Set)runnableVal2.value1).size() * 1024 + " (max)");
        StaticCaption.of(" - TIME ESTIMATE: 12 Parsecs");
        TaskManager.getPlatformImplementation().objectTask(list, new RunnableVal<Plot>(){

            @Override
            public void run(Plot plot) {
                Location location = plot.getCorners()[0];
                Location location2 = plot.getCorners()[1];
                int n = location.getX() >> 9;
                int n2 = location.getZ() >> 9;
                int n3 = location2.getX() >> 9;
                int n4 = location2.getZ() >> 9;
                for (int i = n; i <= n3; ++i) {
                    for (int j = n2; j <= n4; ++j) {
                        BlockVector2 blockVector2 = BlockVector2.at((int)i, (int)j);
                        if (!((Set)runnableVal2.value1).remove(blockVector2)) continue;
                        ((Set)runnableVal2.value2).add(blockVector2);
                    }
                }
            }
        }).thenAccept(void_ -> TaskManager.getPlatformImplementation().taskLater(runnableVal2, TaskTime.ticks(1L)));
        return true;
    }

    @Override
    public boolean onCommand(final PlotPlayer<?> plotPlayer, String[] stringArray) {
        if (stringArray.length == 0) {
            this.sendUsage(plotPlayer);
            return false;
        }
        final String string = stringArray[0];
        if (!this.worldUtil.isWorld(string) || !this.plotAreaManager.hasPlotArea(string)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_valid_world"), new TagResolver[0]);
            return false;
        }
        if (TASK) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("trim.trim_in_progress"), new TagResolver[0]);
            return false;
        }
        TASK = true;
        final boolean bl = stringArray.length == 2 && Boolean.parseBoolean(stringArray[1]);
        Trim.getTrimRegions(string, new RunnableVal2<Set<BlockVector2>, Set<BlockVector2>>(){

            @Override
            public void run(Set<BlockVector2> set, final Set<BlockVector2> set2) {
                Runnable runnable;
                if (bl) {
                    LOGGER.info("Starting regen task");
                    LOGGER.info(" - This is a VERY slow command");
                    LOGGER.info(" - It will say 'Trim done!' when complete");
                    runnable = new Runnable(){

                        @Override
                        public void run() {
                            BlockVector2 blockVector2;
                            int n;
                            int n2;
                            if (set2.isEmpty()) {
                                TASK = false;
                                plotPlayer.sendMessage((Caption)TranslatableCaption.of("trim.trim_done"), new TagResolver[0]);
                                LOGGER.info("Trim done!");
                                return;
                            }
                            Iterator iterator = set2.iterator();
                            BlockVector2 blockVector22 = (BlockVector2)iterator.next();
                            iterator.remove();
                            int n3 = blockVector22.getX() << 5;
                            int n4 = blockVector22.getZ() << 5;
                            HashSet<BlockVector2> hashSet = new HashSet<BlockVector2>();
                            for (n2 = n3; n2 < n3 + 32; ++n2) {
                                for (n = n4; n < n4 + 32; ++n) {
                                    blockVector2 = BlockVector2.at((int)n2, (int)n);
                                    hashSet.add(blockVector2);
                                }
                            }
                            n2 = n3 << 4;
                            n = n4 << 4;
                            blockVector2 = RegionUtil.createRegion(n2, n2 + 511, 0, 0, n, n + 511);
                            for (Plot plot : PlotQuery.newQuery().inWorld(string)) {
                                Location location = plot.getBottomAbs();
                                Location location2 = plot.getExtendedTopAbs();
                                CuboidRegion cuboidRegion = RegionUtil.createRegion(location.getX(), location2.getX(), 0, 0, location.getZ(), location2.getZ());
                                if (!RegionUtil.intersects((CuboidRegion)blockVector2, cuboidRegion)) continue;
                                for (int i = cuboidRegion.getMinimumPoint().getX() >> 4; i <= cuboidRegion.getMaximumPoint().getX() >> 4; ++i) {
                                    for (int j = cuboidRegion.getMinimumPoint().getZ() >> 4; j <= cuboidRegion.getMaximumPoint().getZ() >> 4; ++j) {
                                        BlockVector2 blockVector23 = BlockVector2.at((int)i, (int)j);
                                        hashSet.remove(blockVector23);
                                    }
                                }
                            }
                            final QueueCoordinator queueCoordinator = Trim.this.blockQueue.getNewQueue(Trim.this.worldUtil.getWeWorld(string));
                            TaskManager.getPlatformImplementation().objectTask(hashSet, new RunnableVal<BlockVector2>(){

                                @Override
                                public void run(BlockVector2 blockVector2) {
                                    queueCoordinator.regenChunk(blockVector2.getX(), blockVector2.getZ());
                                }
                            }).thenAccept(void_ -> TaskManager.getPlatformImplementation().taskLater(this, TaskTime.ticks(1L)));
                        }
                    };
                } else {
                    runnable = () -> {
                        TASK = false;
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("trim.trim_done"), new TagResolver[0]);
                        LOGGER.info("Trim done!");
                    };
                }
                Trim.this.regionManager.deleteRegionFiles(string, set, runnable);
            }
        });
        return true;
    }
}

