/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.CmdConfirm;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotUnlinkEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.google.Inject;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="unlink", aliases={"u", "unmerge"}, usage="/plot unlink [createroads]", requiredType=RequiredType.PLAYER, category=CommandCategory.SETTINGS, confirmation=true)
public class Unlink
extends SubCommand {
    private final EventDispatcher eventDispatcher;

    @Inject
    public Unlink(@NonNull EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        boolean bl;
        boolean bl2;
        Location location = plotPlayer.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
            return false;
        }
        if (plot.getVolume() > 2.147483647E9) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
            return false;
        }
        if (!plot.isMerged()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("merge.unlink_impossible"), new TagResolver[0]);
            return false;
        }
        if (stringArray.length != 0) {
            if (stringArray.length != 1 || !StringMan.isEqualIgnoreCaseToAny(stringArray[0], "true", "false")) {
                this.sendUsage(plotPlayer);
                return false;
            }
            bl2 = Boolean.parseBoolean(stringArray[0]);
        } else {
            bl2 = true;
        }
        PlotUnlinkEvent plotUnlinkEvent = this.eventDispatcher.callUnlink(plot.getArea(), plot, bl2, bl2, PlotUnlinkEvent.REASON.PLAYER_COMMAND);
        if (plotUnlinkEvent.getEventResult() == Result.DENY) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Unlink"))));
            return true;
        }
        boolean bl3 = bl = plotUnlinkEvent.getEventResult() == Result.FORCE;
        if (!(bl || plot.isOwner(plotPlayer.getUUID()) || plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_UNLINK))) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
            return true;
        }
        Runnable runnable = () -> {
            if (!plot.getPlotModificationManager().unlinkPlot(bl2, bl2)) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("merge.unmerge_cancelled"), new TagResolver[0]);
                return;
            }
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("merge.unlink_success"), new TagResolver[0]);
            this.eventDispatcher.callPostUnlink(plot, PlotUnlinkEvent.REASON.PLAYER_COMMAND);
        };
        if (this.hasConfirmation(plotPlayer)) {
            CmdConfirm.addPending(plotPlayer, "/plot unlink " + plot.getId(), runnable);
        } else {
            TaskManager.runTask(runnable);
        }
        return true;
    }
}

