/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.components;

import com.plotsquared.core.configuration.serialization.ConfigurationSerializable;
import com.plotsquared.core.configuration.serialization.SerializableAs;
import com.plotsquared.core.generator.ClassicPlotManagerComponent;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

@SerializableAs(value="preset")
public record ComponentPreset(ClassicPlotManagerComponent component, String pattern, double cost, String permission, String displayName, List<String> description, ItemType icon) implements ConfigurationSerializable
{
    public static ComponentPreset deserialize(@NonNull Map<String, Object> map) {
        ClassicPlotManagerComponent classicPlotManagerComponent = ClassicPlotManagerComponent.fromString(map.getOrDefault("component", "").toString()).orElseThrow(() -> new IllegalArgumentException("The preset in components.yml needs a valid target component, got: " + map.get("component")));
        String string = map.getOrDefault("pattern", "").toString();
        double d = Double.parseDouble(map.getOrDefault("cost", "0.0").toString());
        String string2 = map.getOrDefault("permission", "").toString();
        String string3 = map.getOrDefault("name", "New Package").toString();
        List list = map.getOrDefault("description", new ArrayList());
        ItemType itemType = ItemTypes.get((String)map.getOrDefault("icon", "dirt").toString());
        return new ComponentPreset(classicPlotManagerComponent, string, d, string2, string3, list, itemType);
    }

    @Override
    public Map<String, Object> serialize() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("component", this.component.name().toLowerCase());
        hashMap.put("pattern", this.pattern);
        hashMap.put("cost", this.cost);
        hashMap.put("permission", this.permission);
        hashMap.put("name", this.displayName);
        hashMap.put("description", this.description);
        hashMap.put("icon", this.icon.getId().replace("minecraft:", ""));
        return hashMap;
    }
}

