/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.components;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.backup.BackupManager;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.components.ComponentCommand;
import com.plotsquared.core.components.ComponentPreset;
import com.plotsquared.core.configuration.MemorySection;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.MiniMessage;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.configuration.file.FileConfiguration;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.configuration.serialization.ConfigurationSerialization;
import com.plotsquared.core.generator.ClassicPlotManagerComponent;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotInventory;
import com.plotsquared.core.plot.PlotItemStack;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.core.util.InventoryUtil;
import com.plotsquared.core.util.PatternUtil;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ComponentPresetManager {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + ComponentPresetManager.class.getSimpleName()));
    private final List<ComponentPreset> presets;
    private final EconHandler econHandler;
    private final InventoryUtil inventoryUtil;
    private File componentsFile;

    @Inject
    public ComponentPresetManager(@NonNull EconHandler econHandler, @NonNull InventoryUtil inventoryUtil) {
        Iterable<Path> iterable;
        Object object;
        this.econHandler = econHandler;
        this.inventoryUtil = inventoryUtil;
        File file = new File(Objects.requireNonNull(PlotSquared.platform()).getDirectory(), "components.yml");
        File file2 = new File(Objects.requireNonNull(PlotSquared.platform()).getDirectory(), "config");
        if (!file2.exists() && !file2.mkdirs()) {
            LOGGER.error("Failed to create the /plugins/PlotSquared/config folder. Please create it manually");
        }
        if (file.exists()) {
            object = Paths.get(PlotSquared.platform().getDirectory() + "/components.yml", new String[0]);
            iterable = Paths.get(PlotSquared.platform().getDirectory() + "/config/components.yml", new String[0]);
            Files.move((Path)object, (Path)iterable, new CopyOption[0]);
        }
        try {
            this.componentsFile = new File(file2, "components.yml");
            if (!this.componentsFile.exists() && !this.componentsFile.createNewFile()) {
                LOGGER.error("Could not create the components.yml file. Please create 'components.yml' manually.");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ConfigurationSerialization.registerClass(ComponentPreset.class, "ComponentPreset");
        object = YamlConfiguration.loadConfiguration(this.componentsFile);
        if (((MemorySection)object).contains("title")) {
            ((MemorySection)object).set("title", "#Now in /lang/messages_%.json, preset.title");
            try {
                ((FileConfiguration)object).save(this.componentsFile);
            }
            catch (IOException iOException) {
                LOGGER.error("Failed to save default values to components.yml", (Throwable)iOException);
            }
        }
        if (((MemorySection)object).contains("presets")) {
            this.presets = ((MemorySection)object).getMapList("presets").stream().map(map -> map).map(ComponentPreset::deserialize).collect(Collectors.toList());
        } else {
            iterable = Collections.singletonList(new ComponentPreset(ClassicPlotManagerComponent.FLOOR, "##wool", 0.0, "", "<rainbow:2>Disco Floor</rainbow>", List.of("<gold>Spice up your plot floor</gold>"), ItemTypes.YELLOW_WOOL));
            ((MemorySection)object).set("presets", iterable.stream().map(ComponentPreset::serialize).collect(Collectors.toList()));
            try {
                ((FileConfiguration)object).save(this.componentsFile);
            }
            catch (IOException iOException) {
                LOGGER.error("Failed to save default values to components.yml", (Throwable)iOException);
            }
            this.presets = iterable;
        }
        MainCommand.getInstance().register(new ComponentCommand(this));
    }

    public @Nullable PlotInventory buildInventory(final PlotPlayer<?> plotPlayer) {
        final Plot plot = plotPlayer.getCurrentPlot();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return null;
        }
        if (!plot.hasOwner()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
            return null;
        }
        if (!(plot.isOwner(plotPlayer.getUUID()) || plot.getTrusted().contains(plotPlayer.getUUID()) || plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_COMPONENTS_OTHER))) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
            return null;
        }
        if (plot.getVolume() > 2.147483647E9) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
            return null;
        }
        final ArrayList<ComponentPreset> arrayList = new ArrayList<ComponentPreset>(this.presets.size());
        for (ComponentPreset object2 : this.presets) {
            if (!object2.permission().isEmpty() && !plotPlayer.hasPermission(object2.permission())) continue;
            arrayList.add(object2);
        }
        if (arrayList.isEmpty()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("preset.empty"), new TagResolver[0]);
            return null;
        }
        int n = (int)Math.ceil((double)arrayList.size() / 9.0);
        PlotInventory plotInventory = new PlotInventory(this.inventoryUtil, plotPlayer, n, TranslatableCaption.of("preset.title").getComponent(plotPlayer)){

            @Override
            public boolean onClick(int n) {
                if (!this.getPlayer().getCurrentPlot().equals(plot)) {
                    return false;
                }
                if (n < 0 || n >= arrayList.size()) {
                    return false;
                }
                ComponentPreset componentPreset = (ComponentPreset)arrayList.get(n);
                if (componentPreset == null) {
                    return false;
                }
                if (plot.getRunning() > 0) {
                    this.getPlayer().sendMessage((Caption)TranslatableCaption.of("errors.wait_for_timer"), new TagResolver[0]);
                    return false;
                }
                Pattern pattern = PatternUtil.parse(null, componentPreset.pattern(), false);
                if (pattern == null) {
                    this.getPlayer().sendMessage((Caption)TranslatableCaption.of("preset.preset_invalid"), new TagResolver[0]);
                    return false;
                }
                if (componentPreset.cost() > 0.0 && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_BYPASS_ECON)) {
                    if (!ComponentPresetManager.this.econHandler.isEnabled(plot.getArea())) {
                        this.getPlayer().sendMessage((Caption)TranslatableCaption.of("preset.economy_disabled"), TagResolver.resolver("preset", Tag.inserting(Component.text(componentPreset.displayName()))));
                        return false;
                    }
                    if (ComponentPresetManager.this.econHandler.getMoney(this.getPlayer()) < componentPreset.cost()) {
                        this.getPlayer().sendMessage((Caption)TranslatableCaption.of("preset.preset_cannot_afford"), new TagResolver[0]);
                        return false;
                    }
                    ComponentPresetManager.this.econHandler.withdrawMoney(this.getPlayer(), componentPreset.cost());
                    this.getPlayer().sendMessage((Caption)TranslatableCaption.of("economy.removed_balance"), TagResolver.resolver("money", Tag.inserting(Component.text(ComponentPresetManager.this.econHandler.format(componentPreset.cost())))));
                }
                BackupManager.backup(this.getPlayer(), plot, () -> {
                    plot.addRunning();
                    QueueCoordinator queueCoordinator = plot.getArea().getQueue();
                    queueCoordinator.setCompleteTask(plot::removeRunning);
                    for (Plot plot2 : plot.getConnectedPlots()) {
                        plot2.getPlotModificationManager().setComponent(componentPreset.component().name(), pattern, plotPlayer, queueCoordinator);
                    }
                    queueCoordinator.enqueue();
                    this.getPlayer().sendMessage((Caption)TranslatableCaption.of("working.generating_component"), new TagResolver[0]);
                });
                return false;
            }
        };
        for (int i = 0; i < arrayList.size(); ++i) {
            ComponentPreset componentPreset = (ComponentPreset)arrayList.get(i);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (componentPreset.cost() > 0.0) {
                if (!this.econHandler.isEnabled(plot.getArea())) {
                    arrayList2.add((String)MINI_MESSAGE.serialize(MINI_MESSAGE.deserialize(TranslatableCaption.of("preset.preset_lore_economy_disabled").getComponent(plotPlayer))));
                } else {
                    arrayList2.add((String)MINI_MESSAGE.serialize(MINI_MESSAGE.deserialize(TranslatableCaption.of("preset.preset_lore_cost").getComponent(plotPlayer), (TagResolver)TagResolver.resolver("cost", Tag.inserting(Component.text(String.format("%.2f", componentPreset.cost())))))));
                }
            }
            arrayList2.add((String)MINI_MESSAGE.serialize(MINI_MESSAGE.deserialize(TranslatableCaption.of("preset.preset_lore_component").getComponent(plotPlayer), TagResolver.builder().tag("component", Tag.inserting(Component.text(componentPreset.component().name().toLowerCase()))).tag("prefix", Tag.inserting(TranslatableCaption.of("core.prefix").toComponent(plotPlayer))).build())));
            arrayList2.removeIf(String::isEmpty);
            arrayList2.addAll(componentPreset.description());
            plotInventory.setItem(i, new PlotItemStack(componentPreset.icon().getId().replace("minecraft:", ""), 1, componentPreset.displayName(), arrayList2.toArray(new String[0])));
        }
        return plotInventory;
    }
}

