/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration;

import com.plotsquared.core.configuration.MemorySection;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.util.StringMan;
import java.io.File;
import java.io.PrintWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + Config.class.getSimpleName()));

    public static void set(String string, Object object, Class<? extends Config> clazz) {
        Field field;
        String[] stringArray = string.split("\\.");
        Object object2 = Config.getInstance(stringArray, clazz);
        if (object2 != null && (field = Config.getField(stringArray, object2)) != null) {
            try {
                if (field.getAnnotation(Final.class) != null) {
                    return;
                }
                if (field.getType() == String.class && !(object instanceof String)) {
                    object = "" + object;
                }
                field.set(object2, object);
                return;
            }
            catch (Throwable throwable) {
                LOGGER.error("Invalid configuration value '{}: {}' in {}", (Object)string, object, (Object)clazz.getSimpleName());
                throwable.printStackTrace();
            }
        }
        LOGGER.error("Failed to set config option '{}: {}' | {}", (Object)string, object, object2);
    }

    public static boolean load(File file, Class<? extends Config> clazz) {
        if (!file.exists()) {
            return false;
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration(file);
        for (String string : yamlConfiguration.getKeys(true)) {
            Object object = yamlConfiguration.get(string);
            if (object instanceof MemorySection) continue;
            Config.set(string, object, clazz);
        }
        return true;
    }

    public static void save(File file, Class<? extends Config> clazz) {
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            try (PrintWriter printWriter = new PrintWriter(file);){
                Config config = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Config.save(printWriter, clazz, config, 0);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static Map<String, Object> getFields(Class<Settings.Enabled_Components> clazz) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Field field : clazz.getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                hashMap.put(Config.toNodeName(field.getName()), field.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        return hashMap;
    }

    private static String toYamlString(Object object, String string) {
        if (object instanceof List) {
            Collection collection = (Collection)object;
            if (collection.isEmpty()) {
                return "[]";
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Object e : collection) {
                stringBuilder.append(System.lineSeparator()).append(string).append("- ").append(Config.toYamlString(e, string));
            }
            return stringBuilder.toString();
        }
        if (object instanceof String) {
            String string2 = (String)object;
            if (string2.isEmpty()) {
                return "''";
            }
            return "\"" + string2 + "\"";
        }
        return object != null ? object.toString() : "null";
    }

    private static void save(PrintWriter printWriter, Class<?> clazz, Object object, int n) {
        try {
            Object object2;
            Comment comment;
            String string = System.lineSeparator();
            String string2 = StringMan.repeat(" ", n);
            block2: for (Field annotatedElement : clazz.getFields()) {
                if (annotatedElement.getAnnotation(Ignore.class) != null) continue;
                comment = annotatedElement.getAnnotation(Comment.class);
                if (comment != null) {
                    object2 = comment.value();
                    int n2 = ((String[])object2).length;
                    for (int i = 0; i < n2; ++i) {
                        String string3 = object2[i];
                        printWriter.write(string2 + "# " + string3 + string);
                    }
                }
                if ((object2 = annotatedElement.getAnnotation(Create.class)) != null) {
                    Class<?>[] configBlock;
                    Object field = annotatedElement.get(object);
                    if (field != null || annotatedElement.getType() == ConfigBlock.class) continue;
                    Config.setAccessible(annotatedElement);
                    for (Class<?> clazz2 : configBlock = clazz.getDeclaredClasses()) {
                        if (!StringMan.isEqual(clazz2.getSimpleName(), annotatedElement.getName())) continue;
                        annotatedElement.set(object, clazz2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        continue block2;
                    }
                    continue;
                }
                printWriter.write(string2 + Config.toNodeName(annotatedElement.getName() + ": ") + Config.toYamlString(annotatedElement.get(object), string2) + string);
            }
            for (AnnotatedElement annotatedElement : clazz.getClasses()) {
                if (((Class)annotatedElement).isInterface() || ((Class)annotatedElement).getAnnotation(Ignore.class) != null) continue;
                if (n == 0) {
                    printWriter.write(string);
                }
                if ((comment = ((Class)annotatedElement).getAnnotation(Comment.class)) != null) {
                    for (String string4 : comment.value()) {
                        printWriter.write(string2 + "# " + string4 + string);
                    }
                }
                printWriter.write(string2 + Config.toNodeName(((Class)annotatedElement).getSimpleName()) + ":" + string);
                object2 = ((Class)annotatedElement).getAnnotation(BlockName.class);
                if (object2 != null) {
                    Field field = clazz.getDeclaredField(Config.toFieldName(((Class)annotatedElement).getSimpleName()));
                    Config.setAccessible(field);
                    ConfigBlock configBlock = (ConfigBlock)field.get(object);
                    if (configBlock == null) {
                        configBlock = new ConfigBlock();
                        field.set(object, configBlock);
                        for (String string5 : object2.value()) {
                            configBlock.put(string5, ((Class)annotatedElement).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        }
                    }
                    for (Map.Entry entry : configBlock.getRaw().entrySet()) {
                        String string6 = entry.getKey();
                        printWriter.write(string2 + "  " + Config.toNodeName(string6) + ":" + string);
                        Config.save(printWriter, annotatedElement, entry.getValue(), n + 4);
                    }
                    continue;
                }
                Config.save(printWriter, annotatedElement, ((Class)annotatedElement).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), n + 2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static Field getField(String[] stringArray, Object object) {
        try {
            Field field = object.getClass().getField(Config.toFieldName(stringArray[stringArray.length - 1]));
            Config.setAccessible(field);
            return field;
        }
        catch (Throwable throwable) {
            LOGGER.error("Invalid config field: {} for {}. It's likely you are in the process of updating from an older major release of PlotSquared. The entries named can be removed safely from the settings.yml. They are likely no longer in use, moved to a different location or have been merged with other configuration options. Check the changelog for more information.", (Object)StringMan.join(stringArray, "."), (Object)Config.toNodeName(object.getClass().getSimpleName()));
            throwable.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object getInstance(String[] stringArray, Class<?> clazz) {
        try {
            Class<?> clazz2 = clazz == null ? MethodHandles.lookup().lookupClass() : clazz;
            Object object = clazz2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            while (stringArray.length > 0) {
                if (stringArray.length == 1) {
                    return object;
                }
                Class<?> clazz3 = null;
                Class<?>[] classArray = clazz2.getDeclaredClasses();
                for (Class<?> clazz4 : classArray) {
                    if (!clazz4.getSimpleName().equalsIgnoreCase(Config.toFieldName(stringArray[0]))) continue;
                    clazz3 = clazz4;
                    break;
                }
                try {
                    Field field = clazz2.getDeclaredField(Config.toFieldName(stringArray[0]));
                    Config.setAccessible(field);
                    if (field.getType() != ConfigBlock.class) {
                        Object object2 = field.get(object);
                        if (object2 == null) {
                            object2 = clazz3.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            field.set(object, object2);
                        }
                        clazz2 = clazz3;
                        object = object2;
                        stringArray = Arrays.copyOfRange(stringArray, 1, stringArray.length);
                        continue;
                    }
                    ConfigBlock configBlock = (ConfigBlock)field.get(object);
                    if (configBlock == null) {
                        configBlock = new ConfigBlock();
                        field.set(object, configBlock);
                    }
                    if ((object = configBlock.get(stringArray[1])) == null) {
                        object = clazz3.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        configBlock.put(stringArray[1], object);
                    }
                    clazz2 = clazz3;
                    stringArray = Arrays.copyOfRange(stringArray, 2, stringArray.length);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if (clazz3 == null) return null;
                    stringArray = Arrays.copyOfRange(stringArray, 1, stringArray.length);
                    clazz2 = clazz3;
                    object = clazz2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    continue;
                    return null;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    private static String toFieldName(String string) {
        return string.toUpperCase().replaceAll("-", "_");
    }

    private static String toNodeName(String string) {
        return string.toLowerCase().replace("_", "-");
    }

    private static void setAccessible(Field field) {
        field.setAccessible(true);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Final {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    public static @interface Ignore {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    public static @interface Comment {
        public String[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Create {
    }

    @Ignore
    public static class ConfigBlock<T> {
        private final HashMap<String, T> INSTANCES = new HashMap();

        public T get(String string) {
            return this.INSTANCES.get(string);
        }

        public void put(String string, T t) {
            this.INSTANCES.put(string, t);
        }

        public Collection<T> getInstances() {
            return this.INSTANCES.values();
        }

        private Map<String, T> getRaw() {
            return this.INSTANCES;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    public static @interface BlockName {
        public String[] value();
    }
}

