/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration;

import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.plot.BlockBucket;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.util.MathMan;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ConfigurationUtil {
    public static final SettingValue<Integer> INTEGER = new SettingValue<Integer>("INTEGER"){

        @Override
        public boolean validateValue(String string) {
            try {
                Integer.parseInt(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }

        @Override
        public Integer parseString(String string) {
            return Integer.parseInt(string);
        }
    };
    public static final SettingValue<Boolean> BOOLEAN = new SettingValue<Boolean>("BOOLEAN"){

        @Override
        public boolean validateValue(String string) {
            Boolean.parseBoolean(string);
            return true;
        }

        @Override
        public Boolean parseString(String string) {
            return Boolean.parseBoolean(string);
        }
    };
    public static final SettingValue<BiomeType> BIOME = new SettingValue<BiomeType>("BIOME"){

        @Override
        public boolean validateValue(String string) {
            try {
                return BiomeTypes.get((String)string) != null;
            }
            catch (Exception exception) {
                return false;
            }
        }

        @Override
        public BiomeType parseString(String string) {
            if (this.validateValue(string)) {
                return BiomeTypes.get((String)string.toLowerCase());
            }
            return BiomeTypes.FOREST;
        }
    };
    public static final SettingValue<BlockBucket> BLOCK_BUCKET = new SettingValue<BlockBucket>("BLOCK_BUCKET"){

        @Override
        public BlockBucket parseString(String string) {
            BlockBucket blockBucket = new BlockBucket(string);
            blockBucket.compile();
            Pattern pattern = blockBucket.toPattern();
            return pattern != null ? blockBucket : null;
        }

        @Override
        public boolean validateValue(String string) {
            try {
                return this.parseString(string) != null;
            }
            catch (Exception exception) {
                return false;
            }
        }
    };

    private static <T> T getValueFromConfig(ConfigurationSection configurationSection, String string, IntFunction<Optional<T>> intFunction, Function<String, Optional<T>> function, Supplier<T> supplier) {
        String string2 = configurationSection.getString(string);
        if (string2 == null) {
            return supplier.get();
        }
        if (MathMan.isInteger(string2)) {
            return intFunction.apply(Integer.parseInt(string2)).orElseGet(supplier);
        }
        return function.apply(string2).orElseGet(supplier);
    }

    public static PlotAreaType getType(ConfigurationSection configurationSection) {
        return ConfigurationUtil.getValueFromConfig(configurationSection, "generator.type", PlotAreaType::fromLegacyInt, PlotAreaType::fromString, () -> PlotAreaType.NORMAL);
    }

    public static PlotAreaTerrainType getTerrain(ConfigurationSection configurationSection) {
        return ConfigurationUtil.getValueFromConfig(configurationSection, "generator.terrain", PlotAreaTerrainType::fromLegacyInt, PlotAreaTerrainType::fromString, () -> PlotAreaTerrainType.NONE);
    }

    public static abstract class SettingValue<T> {
        private final String type;

        SettingValue(String string) {
            this.type = string;
        }

        public String getType() {
            return this.type;
        }

        public abstract T parseString(String var1);

        public abstract boolean validateValue(String var1);
    }

    public static final class UnsafeBlockException
    extends IllegalArgumentException {
        private final BlockState unsafeBlock;

        UnsafeBlockException(@NonNull BlockState blockState) {
            super(String.format("%s is not a valid block", blockState));
            this.unsafeBlock = blockState;
        }

        public BlockState getUnsafeBlock() {
            return this.unsafeBlock;
        }
    }

    public static final class UnknownBlockException
    extends IllegalArgumentException {
        private final String unknownValue;

        UnknownBlockException(@NonNull String string) {
            super(String.format("\"%s\" is not a valid block", string));
            this.unknownValue = string;
        }

        public String getUnknownValue() {
            return this.unknownValue;
        }
    }
}

