/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.adventure.nbt;

import com.plotsquared.core.annotations.annotations.Debug;
import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import com.plotsquared.core.configuration.adventure.nbt.AbstractBinaryTag;
import com.plotsquared.core.configuration.adventure.nbt.DoubleBinaryTag;
import com.plotsquared.core.configuration.adventure.nbt.ShadyPines;
import com.plotsquared.core.configuration.examination.ExaminableProperty;
import java.util.stream.Stream;

@Debug.Renderer(text="String.valueOf(this.value) + \"d\"", hasChildren="false")
final class DoubleBinaryTagImpl
extends AbstractBinaryTag
implements DoubleBinaryTag {
    private final double value;

    DoubleBinaryTagImpl(double d) {
        this.value = d;
    }

    @Override
    public double value() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return (byte)(ShadyPines.floor(this.value) & 0xFF);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public int intValue() {
        return ShadyPines.floor(this.value);
    }

    @Override
    public long longValue() {
        return (long)Math.floor(this.value);
    }

    @Override
    public short shortValue() {
        return (short)(ShadyPines.floor(this.value) & 0xFFFF);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DoubleBinaryTagImpl doubleBinaryTagImpl = (DoubleBinaryTagImpl)object;
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(doubleBinaryTagImpl.value);
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("value", this.value));
    }
}

