/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.adventure.text.minimessage;

import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.ArgumentQueueImpl;
import com.plotsquared.core.configuration.adventure.text.minimessage.Context;
import com.plotsquared.core.configuration.adventure.text.minimessage.MiniMessage;
import com.plotsquared.core.configuration.adventure.text.minimessage.MiniMessageImpl;
import com.plotsquared.core.configuration.adventure.text.minimessage.ParsingException;
import com.plotsquared.core.configuration.adventure.text.minimessage.internal.parser.ParsingExceptionImpl;
import com.plotsquared.core.configuration.adventure.text.minimessage.internal.parser.Token;
import com.plotsquared.core.configuration.adventure.text.minimessage.internal.parser.node.TagPart;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

class ContextImpl
implements Context {
    private static final Token[] EMPTY_TOKEN_ARRAY = new Token[0];
    private final boolean strict;
    private final Consumer<String> debugOutput;
    private String message;
    private final MiniMessage miniMessage;
    private final TagResolver tagResolver;
    private final UnaryOperator<String> preProcessor;
    private final UnaryOperator<Component> postProcessor;

    ContextImpl(boolean bl, Consumer<String> consumer, String string, MiniMessage miniMessage, @NotNull TagResolver tagResolver, UnaryOperator<String> unaryOperator, UnaryOperator<Component> unaryOperator2) {
        this.strict = bl;
        this.debugOutput = consumer;
        this.message = string;
        this.miniMessage = miniMessage;
        this.tagResolver = tagResolver;
        this.preProcessor = unaryOperator == null ? UnaryOperator.identity() : unaryOperator;
        this.postProcessor = unaryOperator2 == null ? UnaryOperator.identity() : unaryOperator2;
    }

    static ContextImpl of(boolean bl, Consumer<String> consumer, String string, MiniMessageImpl miniMessageImpl, TagResolver tagResolver, UnaryOperator<String> unaryOperator, UnaryOperator<Component> unaryOperator2) {
        return new ContextImpl(bl, consumer, string, miniMessageImpl, tagResolver, unaryOperator, unaryOperator2);
    }

    public boolean strict() {
        return this.strict;
    }

    public Consumer<String> debugOutput() {
        return this.debugOutput;
    }

    @NotNull
    public String message() {
        return this.message;
    }

    void message(@NotNull String string) {
        this.message = string;
    }

    @NotNull
    public TagResolver extraTags() {
        return this.tagResolver;
    }

    public UnaryOperator<Component> postProcessor() {
        return this.postProcessor;
    }

    public UnaryOperator<String> preProcessor() {
        return this.preProcessor;
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull String string) {
        return this.miniMessage.deserialize(Objects.requireNonNull(string, "message"), this.tagResolver);
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull String string, @NotNull TagResolver tagResolver) {
        return this.miniMessage.deserialize(Objects.requireNonNull(string, "message"), TagResolver.builder().resolver(this.tagResolver).resolver(Objects.requireNonNull(tagResolver, "resolver")).build());
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull String string, TagResolver ... tagResolverArray) {
        return this.miniMessage.deserialize(Objects.requireNonNull(string, "message"), TagResolver.builder().resolver(this.tagResolver).resolvers(Objects.requireNonNull(tagResolverArray, "resolvers")).build());
    }

    @Override
    @NotNull
    public ParsingException newException(@NotNull String string) {
        return new ParsingExceptionImpl(string, this.message, null, false, EMPTY_TOKEN_ARRAY);
    }

    @Override
    @NotNull
    public ParsingException newException(@NotNull String string, @NotNull ArgumentQueue argumentQueue) {
        return new ParsingExceptionImpl(string, this.message, null, false, ContextImpl.tagsToTokens(((ArgumentQueueImpl)argumentQueue).args));
    }

    @Override
    @NotNull
    public ParsingException newException(@NotNull String string, @Nullable Throwable throwable, @NotNull ArgumentQueue argumentQueue) {
        return new ParsingExceptionImpl(string, this.message, throwable, false, ContextImpl.tagsToTokens(((ArgumentQueueImpl)argumentQueue).args));
    }

    private static Token[] tagsToTokens(List<? extends Tag.Argument> list) {
        Token[] tokenArray = new Token[list.size()];
        int n = tokenArray.length;
        for (int i = 0; i < n; ++i) {
            tokenArray[i] = ((TagPart)list.get(i)).token();
        }
        return tokenArray;
    }
}

