/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.adventure.text.renderer;

import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.configuration.adventure.text.BlockNBTComponent;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.EntityNBTComponent;
import com.plotsquared.core.configuration.adventure.text.KeybindComponent;
import com.plotsquared.core.configuration.adventure.text.NBTComponent;
import com.plotsquared.core.configuration.adventure.text.ScoreComponent;
import com.plotsquared.core.configuration.adventure.text.SelectorComponent;
import com.plotsquared.core.configuration.adventure.text.StorageNBTComponent;
import com.plotsquared.core.configuration.adventure.text.TextComponent;
import com.plotsquared.core.configuration.adventure.text.TranslatableComponent;
import com.plotsquared.core.configuration.adventure.text.renderer.ComponentRenderer;

public abstract class AbstractComponentRenderer<C>
implements ComponentRenderer<C> {
    @Override
    @NotNull
    public Component render(@NotNull Component component, @NotNull C c) {
        if (component instanceof TextComponent) {
            return this.renderText((TextComponent)component, c);
        }
        if (component instanceof TranslatableComponent) {
            return this.renderTranslatable((TranslatableComponent)component, c);
        }
        if (component instanceof KeybindComponent) {
            return this.renderKeybind((KeybindComponent)component, c);
        }
        if (component instanceof ScoreComponent) {
            return this.renderScore((ScoreComponent)component, c);
        }
        if (component instanceof SelectorComponent) {
            return this.renderSelector((SelectorComponent)component, c);
        }
        if (component instanceof NBTComponent) {
            if (component instanceof BlockNBTComponent) {
                return this.renderBlockNbt((BlockNBTComponent)component, c);
            }
            if (component instanceof EntityNBTComponent) {
                return this.renderEntityNbt((EntityNBTComponent)component, c);
            }
            if (component instanceof StorageNBTComponent) {
                return this.renderStorageNbt((StorageNBTComponent)component, c);
            }
        }
        return component;
    }

    @NotNull
    protected abstract Component renderBlockNbt(@NotNull BlockNBTComponent var1, @NotNull C var2);

    @NotNull
    protected abstract Component renderEntityNbt(@NotNull EntityNBTComponent var1, @NotNull C var2);

    @NotNull
    protected abstract Component renderStorageNbt(@NotNull StorageNBTComponent var1, @NotNull C var2);

    @NotNull
    protected abstract Component renderKeybind(@NotNull KeybindComponent var1, @NotNull C var2);

    @NotNull
    protected abstract Component renderScore(@NotNull ScoreComponent var1, @NotNull C var2);

    @NotNull
    protected abstract Component renderSelector(@NotNull SelectorComponent var1, @NotNull C var2);

    @NotNull
    protected abstract Component renderText(@NotNull TextComponent var1, @NotNull C var2);

    @NotNull
    protected abstract Component renderTranslatable(@NotNull TranslatableComponent var1, @NotNull C var2);
}

